/* Copyright 2017 R. Thomas
 * Copyright 2017 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_PE_MSVCR100_DLL_LOOKUP_H_
#define LIEF_PE_MSVCR100_DLL_LOOKUP_H_

#include <map>

namespace LIEF {
namespace PE {

static const std::map<uint32_t, const char*> msvcr100_dll_lookup {
    { 0x010f, "$I10_OUTPUT"                                                                                                       },
    { 0x0001, "??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z"                                                              },
    { 0x0002, "??0?$_SpinWait@$0A@@details@Concurrency@@QAE@P6AXXZ@Z"                                                             },
    { 0x0003, "??0SchedulerPolicy@Concurrency@@QAA@IZZ"                                                                           },
    { 0x0004, "??0SchedulerPolicy@Concurrency@@QAE@ABV01@@Z"                                                                      },
    { 0x0005, "??0SchedulerPolicy@Concurrency@@QAE@XZ"                                                                            },
    { 0x0006, "??0_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ"                                                          },
    { 0x0007, "??0_NonReentrantPPLLock@details@Concurrency@@QAE@XZ"                                                               },
    { 0x0008, "??0_ReaderWriterLock@details@Concurrency@@QAE@XZ"                                                                  },
    { 0x0009, "??0_ReentrantBlockingLock@details@Concurrency@@QAE@XZ"                                                             },
    { 0x000a, "??0_ReentrantLock@details@Concurrency@@QAE@XZ"                                                                     },
    { 0x000b, "??0_ReentrantPPLLock@details@Concurrency@@QAE@XZ"                                                                  },
    { 0x000c, "??0_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z"                                           },
    { 0x000d, "??0_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z"                                              },
    { 0x000e, "??0_SpinLock@details@Concurrency@@QAE@ACJ@Z"                                                                       },
    { 0x000f, "??0_TaskCollection@details@Concurrency@@QAE@XZ"                                                                    },
    { 0x0010, "??0_Timer@details@Concurrency@@IAE@I_N@Z"                                                                          },
    { 0x0011, "??0__non_rtti_object@std@@QAE@ABV01@@Z"                                                                            },
    { 0x0012, "??0__non_rtti_object@std@@QAE@PBD@Z"                                                                               },
    { 0x0013, "??0bad_cast@std@@AAE@PBQBD@Z"                                                                                      },
    { 0x0014, "??0bad_cast@std@@QAE@ABV01@@Z"                                                                                     },
    { 0x0015, "??0bad_cast@std@@QAE@PBD@Z"                                                                                        },
    { 0x0016, "??0bad_target@Concurrency@@QAE@PBD@Z"                                                                              },
    { 0x0017, "??0bad_target@Concurrency@@QAE@XZ"                                                                                 },
    { 0x0018, "??0bad_typeid@std@@QAE@ABV01@@Z"                                                                                   },
    { 0x0019, "??0bad_typeid@std@@QAE@PBD@Z"                                                                                      },
    { 0x001a, "??0context_self_unblock@Concurrency@@QAE@PBD@Z"                                                                    },
    { 0x001b, "??0context_self_unblock@Concurrency@@QAE@XZ"                                                                       },
    { 0x001c, "??0context_unblock_unbalanced@Concurrency@@QAE@PBD@Z"                                                              },
    { 0x001d, "??0context_unblock_unbalanced@Concurrency@@QAE@XZ"                                                                 },
    { 0x001e, "??0critical_section@Concurrency@@QAE@XZ"                                                                           },
    { 0x001f, "??0default_scheduler_exists@Concurrency@@QAE@PBD@Z"                                                                },
    { 0x0020, "??0default_scheduler_exists@Concurrency@@QAE@XZ"                                                                   },
    { 0x0021, "??0event@Concurrency@@QAE@XZ"                                                                                      },
    { 0x0022, "??0exception@std@@QAE@ABQBD@Z"                                                                                     },
    { 0x0023, "??0exception@std@@QAE@ABQBDH@Z"                                                                                    },
    { 0x0024, "??0exception@std@@QAE@ABV01@@Z"                                                                                    },
    { 0x0025, "??0exception@std@@QAE@XZ"                                                                                          },
    { 0x0026, "??0improper_lock@Concurrency@@QAE@PBD@Z"                                                                           },
    { 0x0027, "??0improper_lock@Concurrency@@QAE@XZ"                                                                              },
    { 0x0028, "??0improper_scheduler_attach@Concurrency@@QAE@PBD@Z"                                                               },
    { 0x0029, "??0improper_scheduler_attach@Concurrency@@QAE@XZ"                                                                  },
    { 0x002a, "??0improper_scheduler_detach@Concurrency@@QAE@PBD@Z"                                                               },
    { 0x002b, "??0improper_scheduler_detach@Concurrency@@QAE@XZ"                                                                  },
    { 0x002c, "??0improper_scheduler_reference@Concurrency@@QAE@PBD@Z"                                                            },
    { 0x002d, "??0improper_scheduler_reference@Concurrency@@QAE@XZ"                                                               },
    { 0x002e, "??0invalid_link_target@Concurrency@@QAE@PBD@Z"                                                                     },
    { 0x002f, "??0invalid_link_target@Concurrency@@QAE@XZ"                                                                        },
    { 0x0030, "??0invalid_multiple_scheduling@Concurrency@@QAE@PBD@Z"                                                             },
    { 0x0031, "??0invalid_multiple_scheduling@Concurrency@@QAE@XZ"                                                                },
    { 0x0032, "??0invalid_operation@Concurrency@@QAE@PBD@Z"                                                                       },
    { 0x0033, "??0invalid_operation@Concurrency@@QAE@XZ"                                                                          },
    { 0x0034, "??0invalid_oversubscribe_operation@Concurrency@@QAE@PBD@Z"                                                         },
    { 0x0035, "??0invalid_oversubscribe_operation@Concurrency@@QAE@XZ"                                                            },
    { 0x0036, "??0invalid_scheduler_policy_key@Concurrency@@QAE@PBD@Z"                                                            },
    { 0x0037, "??0invalid_scheduler_policy_key@Concurrency@@QAE@XZ"                                                               },
    { 0x0038, "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@PBD@Z"                                           },
    { 0x0039, "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@XZ"                                              },
    { 0x003a, "??0invalid_scheduler_policy_value@Concurrency@@QAE@PBD@Z"                                                          },
    { 0x003b, "??0invalid_scheduler_policy_value@Concurrency@@QAE@XZ"                                                             },
    { 0x003c, "??0message_not_found@Concurrency@@QAE@PBD@Z"                                                                       },
    { 0x003d, "??0message_not_found@Concurrency@@QAE@XZ"                                                                          },
    { 0x003e, "??0missing_wait@Concurrency@@QAE@PBD@Z"                                                                            },
    { 0x003f, "??0missing_wait@Concurrency@@QAE@XZ"                                                                               },
    { 0x0040, "??0nested_scheduler_missing_detach@Concurrency@@QAE@PBD@Z"                                                         },
    { 0x0041, "??0nested_scheduler_missing_detach@Concurrency@@QAE@XZ"                                                            },
    { 0x0042, "??0operation_timed_out@Concurrency@@QAE@PBD@Z"                                                                     },
    { 0x0043, "??0operation_timed_out@Concurrency@@QAE@XZ"                                                                        },
    { 0x0044, "??0reader_writer_lock@Concurrency@@QAE@XZ"                                                                         },
    { 0x0045, "??0scheduler_not_attached@Concurrency@@QAE@PBD@Z"                                                                  },
    { 0x0046, "??0scheduler_not_attached@Concurrency@@QAE@XZ"                                                                     },
    { 0x0047, "??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z"                                                       },
    { 0x0048, "??0scheduler_resource_allocation_error@Concurrency@@QAE@PBDJ@Z"                                                    },
    { 0x0049, "??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z"                                                         },
    { 0x004a, "??0scoped_lock@reader_writer_lock@Concurrency@@QAE@AAV12@@Z"                                                       },
    { 0x004b, "??0scoped_lock_read@reader_writer_lock@Concurrency@@QAE@AAV12@@Z"                                                  },
    { 0x004c, "??0task_canceled@details@Concurrency@@QAE@PBD@Z"                                                                   },
    { 0x004d, "??0task_canceled@details@Concurrency@@QAE@XZ"                                                                      },
    { 0x004e, "??0unsupported_os@Concurrency@@QAE@PBD@Z"                                                                          },
    { 0x004f, "??0unsupported_os@Concurrency@@QAE@XZ"                                                                             },
    { 0x0050, "??1SchedulerPolicy@Concurrency@@QAE@XZ"                                                                            },
    { 0x0051, "??1_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ"                                                          },
    { 0x0052, "??1_ReentrantBlockingLock@details@Concurrency@@QAE@XZ"                                                             },
    { 0x0053, "??1_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@XZ"                                                  },
    { 0x0054, "??1_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@XZ"                                                     },
    { 0x0055, "??1_SpinLock@details@Concurrency@@QAE@XZ"                                                                          },
    { 0x0056, "??1_TaskCollection@details@Concurrency@@QAE@XZ"                                                                    },
    { 0x0057, "??1_Timer@details@Concurrency@@IAE@XZ"                                                                             },
    { 0x0058, "??1__non_rtti_object@std@@UAE@XZ"                                                                                  },
    { 0x0059, "??1bad_cast@std@@UAE@XZ"                                                                                           },
    { 0x005a, "??1bad_typeid@std@@UAE@XZ"                                                                                         },
    { 0x005b, "??1critical_section@Concurrency@@QAE@XZ"                                                                           },
    { 0x005c, "??1event@Concurrency@@QAE@XZ"                                                                                      },
    { 0x005d, "??1exception@std@@UAE@XZ"                                                                                          },
    { 0x005e, "??1reader_writer_lock@Concurrency@@QAE@XZ"                                                                         },
    { 0x005f, "??1scoped_lock@critical_section@Concurrency@@QAE@XZ"                                                               },
    { 0x0060, "??1scoped_lock@reader_writer_lock@Concurrency@@QAE@XZ"                                                             },
    { 0x0061, "??1scoped_lock_read@reader_writer_lock@Concurrency@@QAE@XZ"                                                        },
    { 0x0062, "??1type_info@@UAE@XZ"                                                                                              },
    { 0x0063, "??2@YAPAXI@Z"                                                                                                      },
    { 0x0064, "??2@YAPAXIHPBDH@Z"                                                                                                 },
    { 0x0065, "??3@YAXPAX@Z"                                                                                                      },
    { 0x0066, "??4?$_SpinWait@$00@details@Concurrency@@QAEAAV012@ABV012@@Z"                                                       },
    { 0x0067, "??4?$_SpinWait@$0A@@details@Concurrency@@QAEAAV012@ABV012@@Z"                                                      },
    { 0x0068, "??4SchedulerPolicy@Concurrency@@QAEAAV01@ABV01@@Z"                                                                 },
    { 0x0069, "??4__non_rtti_object@std@@QAEAAV01@ABV01@@Z"                                                                       },
    { 0x006a, "??4bad_cast@std@@QAEAAV01@ABV01@@Z"                                                                                },
    { 0x006b, "??4bad_typeid@std@@QAEAAV01@ABV01@@Z"                                                                              },
    { 0x006c, "??4exception@std@@QAEAAV01@ABV01@@Z"                                                                               },
    { 0x006d, "??8type_info@@QBE_NABV0@@Z"                                                                                        },
    { 0x006e, "??9type_info@@QBE_NABV0@@Z"                                                                                        },
    { 0x006f, "??_7__non_rtti_object@std@@6B@"                                                                                    },
    { 0x0070, "??_7bad_cast@std@@6B@"                                                                                             },
    { 0x0071, "??_7bad_typeid@std@@6B@"                                                                                           },
    { 0x0072, "??_7exception@@6B@"                                                                                                },
    { 0x0073, "??_7exception@std@@6B@"                                                                                            },
    { 0x0074, "??_F?$_SpinWait@$00@details@Concurrency@@QAEXXZ"                                                                   },
    { 0x0075, "??_F?$_SpinWait@$0A@@details@Concurrency@@QAEXXZ"                                                                  },
    { 0x0076, "??_Fbad_cast@std@@QAEXXZ"                                                                                          },
    { 0x0077, "??_Fbad_typeid@std@@QAEXXZ"                                                                                        },
    { 0x0078, "??_U@YAPAXI@Z"                                                                                                     },
    { 0x0079, "??_U@YAPAXIHPBDH@Z"                                                                                                },
    { 0x007a, "??_V@YAXPAX@Z"                                                                                                     },
    { 0x007b, "?Alloc@Concurrency@@YAPAXI@Z"                                                                                      },
    { 0x007c, "?Block@Context@Concurrency@@SAXXZ"                                                                                 },
    { 0x007d, "?Create@CurrentScheduler@Concurrency@@SAXABVSchedulerPolicy@2@@Z"                                                  },
    { 0x007e, "?Create@Scheduler@Concurrency@@SAPAV12@ABVSchedulerPolicy@2@@Z"                                                    },
    { 0x007f, "?CreateResourceManager@Concurrency@@YAPAUIResourceManager@1@XZ"                                                    },
    { 0x0080, "?CreateScheduleGroup@CurrentScheduler@Concurrency@@SAPAVScheduleGroup@2@XZ"                                        },
    { 0x0081, "?CurrentContext@Context@Concurrency@@SAPAV12@XZ"                                                                   },
    { 0x0082, "?Detach@CurrentScheduler@Concurrency@@SAXXZ"                                                                       },
    { 0x0083, "?DisableTracing@Concurrency@@YAJXZ"                                                                                },
    { 0x0084, "?EnableTracing@Concurrency@@YAJXZ"                                                                                 },
    { 0x0085, "?Free@Concurrency@@YAXPAX@Z"                                                                                       },
    { 0x0086, "?Get@CurrentScheduler@Concurrency@@SAPAVScheduler@2@XZ"                                                            },
    { 0x0087, "?GetExecutionContextId@Concurrency@@YAIXZ"                                                                         },
    { 0x0088, "?GetNumberOfVirtualProcessors@CurrentScheduler@Concurrency@@SAIXZ"                                                 },
    { 0x0089, "?GetOSVersion@Concurrency@@YA?AW4OSVersion@IResourceManager@1@XZ"                                                  },
    { 0x008a, "?GetPolicy@CurrentScheduler@Concurrency@@SA?AVSchedulerPolicy@2@XZ"                                                },
    { 0x008b, "?GetPolicyValue@SchedulerPolicy@Concurrency@@QBEIW4PolicyElementKey@2@@Z"                                          },
    { 0x008c, "?GetProcessorCount@Concurrency@@YAIXZ"                                                                             },
    { 0x008d, "?GetProcessorNodeCount@Concurrency@@YAIXZ"                                                                         },
    { 0x008e, "?GetSchedulerId@Concurrency@@YAIXZ"                                                                                },
    { 0x008f, "?GetSharedTimerQueue@details@Concurrency@@YAPAXXZ"                                                                 },
    { 0x0090, "?Id@Context@Concurrency@@SAIXZ"                                                                                    },
    { 0x0091, "?Id@CurrentScheduler@Concurrency@@SAIXZ"                                                                           },
    { 0x0092, "?IsCurrentTaskCollectionCanceling@Context@Concurrency@@SA_NXZ"                                                     },
    { 0x0093, "?Log2@details@Concurrency@@YAKI@Z"                                                                                 },
    { 0x0094, "?Oversubscribe@Context@Concurrency@@SAX_N@Z"                                                                       },
    { 0x0095, "?RegisterShutdownEvent@CurrentScheduler@Concurrency@@SAXPAX@Z"                                                     },
    { 0x0096, "?ResetDefaultSchedulerPolicy@Scheduler@Concurrency@@SAXXZ"                                                         },
    { 0x0097, "?ScheduleGroupId@Context@Concurrency@@SAIXZ"                                                                       },
    { 0x0098, "?ScheduleTask@CurrentScheduler@Concurrency@@SAXP6AXPAX@Z0@Z"                                                       },
    { 0x0099, "?SetConcurrencyLimits@SchedulerPolicy@Concurrency@@QAEXII@Z"                                                       },
    { 0x009a, "?SetDefaultSchedulerPolicy@Scheduler@Concurrency@@SAXABVSchedulerPolicy@2@@Z"                                      },
    { 0x009b, "?SetPolicyValue@SchedulerPolicy@Concurrency@@QAEIW4PolicyElementKey@2@I@Z"                                         },
    { 0x009c, "?VirtualProcessorId@Context@Concurrency@@SAIXZ"                                                                    },
    { 0x009d, "?Yield@Context@Concurrency@@SAXXZ"                                                                                 },
    { 0x009e, "?_Abort@_StructuredTaskCollection@details@Concurrency@@AAEXXZ"                                                     },
    { 0x009f, "?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ"                                                   },
    { 0x00a0, "?_Acquire@_NonReentrantPPLLock@details@Concurrency@@QAEXPAX@Z"                                                     },
    { 0x00a1, "?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QAEXXZ"                                                      },
    { 0x00a2, "?_Acquire@_ReentrantLock@details@Concurrency@@QAEXXZ"                                                              },
    { 0x00a3, "?_Acquire@_ReentrantPPLLock@details@Concurrency@@QAEXPAX@Z"                                                        },
    { 0x00a4, "?_AcquireRead@_ReaderWriterLock@details@Concurrency@@QAEXXZ"                                                       },
    { 0x00a5, "?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"                                                      },
    { 0x00a6, "?_Cancel@_StructuredTaskCollection@details@Concurrency@@QAEXXZ"                                                    },
    { 0x00a7, "?_Cancel@_TaskCollection@details@Concurrency@@QAEXXZ"                                                              },
    { 0x00a8, "?_CheckTaskCollection@_UnrealizedChore@details@Concurrency@@IAEXXZ"                                                },
    { 0x00a9, "?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z"                                                                   },
    { 0x00aa, "?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z"                                                               },
    { 0x00ab, "?_ConcRT_DumpMessage@details@Concurrency@@YAXPB_WZZ"                                                               },
    { 0x00ac, "?_ConcRT_Trace@details@Concurrency@@YAXHPB_WZZ"                                                                    },
    { 0x00ad, "?_Copy_str@exception@std@@AAEXPBD@Z"                                                                               },
    { 0x00ae, "?_DoYield@?$_SpinWait@$00@details@Concurrency@@IAEXXZ"                                                             },
    { 0x00af, "?_DoYield@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ"                                                            },
    { 0x00b0, "?_IsCanceling@_StructuredTaskCollection@details@Concurrency@@QAE_NXZ"                                              },
    { 0x00b1, "?_IsCanceling@_TaskCollection@details@Concurrency@@QAE_NXZ"                                                        },
    { 0x00b2, "?_Name_base@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z"                                                          },
    { 0x00b3, "?_Name_base_internal@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z"                                                 },
    { 0x00b4, "?_NumberOfSpins@?$_SpinWait@$00@details@Concurrency@@IAEKXZ"                                                       },
    { 0x00b5, "?_NumberOfSpins@?$_SpinWait@$0A@@details@Concurrency@@IAEKXZ"                                                      },
    { 0x00b6, "?_Release@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ"                                                   },
    { 0x00b7, "?_Release@_NonReentrantPPLLock@details@Concurrency@@QAEXXZ"                                                        },
    { 0x00b8, "?_Release@_ReentrantBlockingLock@details@Concurrency@@QAEXXZ"                                                      },
    { 0x00b9, "?_Release@_ReentrantLock@details@Concurrency@@QAEXXZ"                                                              },
    { 0x00ba, "?_Release@_ReentrantPPLLock@details@Concurrency@@QAEXXZ"                                                           },
    { 0x00bb, "?_ReleaseRead@_ReaderWriterLock@details@Concurrency@@QAEXXZ"                                                       },
    { 0x00bc, "?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"                                                      },
    { 0x00bd, "?_Reset@?$_SpinWait@$00@details@Concurrency@@IAEXXZ"                                                               },
    { 0x00be, "?_Reset@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ"                                                              },
    { 0x00bf, "?_RunAndWait@_StructuredTaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z" },
    { 0x00c0, "?_RunAndWait@_TaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z"       },
    { 0x00c1, "?_Schedule@_StructuredTaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"                           },
    { 0x00c2, "?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"                                     },
    { 0x00c3, "?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z"                                                       },
    { 0x00c4, "?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QAEXI@Z"                                                      },
    { 0x00c5, "?_ShouldSpinAgain@?$_SpinWait@$00@details@Concurrency@@IAE_NXZ"                                                    },
    { 0x00c6, "?_ShouldSpinAgain@?$_SpinWait@$0A@@details@Concurrency@@IAE_NXZ"                                                   },
    { 0x00c7, "?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"                                                           },
    { 0x00c8, "?_SpinOnce@?$_SpinWait@$0A@@details@Concurrency@@QAE_NXZ"                                                          },
    { 0x00c9, "?_SpinYield@Context@Concurrency@@SAXXZ"                                                                            },
    { 0x00ca, "?_Start@_Timer@details@Concurrency@@IAEXXZ"                                                                        },
    { 0x00cb, "?_Stop@_Timer@details@Concurrency@@IAEXXZ"                                                                         },
    { 0x00cc, "?_Tidy@exception@std@@AAEXXZ"                                                                                      },
    { 0x00cd, "?_Trace_ppl_function@Concurrency@@YAXABU_GUID@@EW4ConcRT_EventType@1@@Z"                                           },
    { 0x00ce, "?_TryAcquire@_NonReentrantBlockingLock@details@Concurrency@@QAE_NXZ"                                               },
    { 0x00cf, "?_TryAcquire@_ReentrantBlockingLock@details@Concurrency@@QAE_NXZ"                                                  },
    { 0x00d0, "?_TryAcquire@_ReentrantLock@details@Concurrency@@QAE_NXZ"                                                          },
    { 0x00d1, "?_TryAcquireWrite@_ReaderWriterLock@details@Concurrency@@QAE_NXZ"                                                  },
    { 0x00d2, "?_Type_info_dtor@type_info@@CAXPAV1@@Z"                                                                            },
    { 0x00d3, "?_Type_info_dtor_internal@type_info@@CAXPAV1@@Z"                                                                   },
    { 0x00d4, "?_UnderlyingYield@details@Concurrency@@YAXXZ"                                                                      },
    { 0x00d5, "?_ValidateExecute@@YAHP6GHXZ@Z"                                                                                    },
    { 0x00d6, "?_ValidateRead@@YAHPBXI@Z"                                                                                         },
    { 0x00d7, "?_ValidateWrite@@YAHPAXI@Z"                                                                                        },
    { 0x00d8, "?_Value@_SpinCount@details@Concurrency@@SAIXZ"                                                                     },
    { 0x00d9, "?__ExceptionPtrAssign@@YAXPAXPBX@Z"                                                                                },
    { 0x00da, "?__ExceptionPtrCompare@@YA_NPBX0@Z"                                                                                },
    { 0x00db, "?__ExceptionPtrCopy@@YAXPAXPBX@Z"                                                                                  },
    { 0x00dc, "?__ExceptionPtrCopyException@@YAXPAXPBX1@Z"                                                                        },
    { 0x00dd, "?__ExceptionPtrCreate@@YAXPAX@Z"                                                                                   },
    { 0x00de, "?__ExceptionPtrCurrentException@@YAXPAX@Z"                                                                         },
    { 0x00df, "?__ExceptionPtrDestroy@@YAXPAX@Z"                                                                                  },
    { 0x00e0, "?__ExceptionPtrRethrow@@YAXPBX@Z"                                                                                  },
    { 0x00e2, "?_inconsistency@@YAXXZ"                                                                                            },
    { 0x00e3, "?_invalid_parameter@@YAXPBG00II@Z"                                                                                 },
    { 0x00e4, "?_is_exception_typeof@@YAHABVtype_info@@PAU_EXCEPTION_POINTERS@@@Z"                                                },
    { 0x00e5, "?_name_internal_method@type_info@@QBEPBDPAU__type_info_node@@@Z"                                                   },
    { 0x00e6, "?_open@@YAHPBDHH@Z"                                                                                                },
    { 0x00e7, "?_query_new_handler@@YAP6AHI@ZXZ"                                                                                  },
    { 0x00e8, "?_query_new_mode@@YAHXZ"                                                                                           },
    { 0x00e9, "?_set_new_handler@@YAP6AHI@ZH@Z"                                                                                   },
    { 0x00ea, "?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z"                                                                             },
    { 0x00eb, "?_set_new_mode@@YAHH@Z"                                                                                            },
    { 0x00ec, "?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZH@Z"                                                         },
    { 0x00ed, "?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z"                                                  },
    { 0x00ee, "?_sopen@@YAHPBDHHH@Z"                                                                                              },
    { 0x00ef, "?_type_info_dtor_internal_method@type_info@@QAEXXZ"                                                                },
    { 0x00f0, "?_wopen@@YAHPB_WHH@Z"                                                                                              },
    { 0x00f1, "?_wsopen@@YAHPB_WHHH@Z"                                                                                            },
    { 0x00f2, "?before@type_info@@QBEHABV1@@Z"                                                                                    },
    { 0x00f3, "?get_error_code@scheduler_resource_allocation_error@Concurrency@@QBEJXZ"                                           },
    { 0x00f4, "?lock@critical_section@Concurrency@@QAEXXZ"                                                                        },
    { 0x00f5, "?lock@reader_writer_lock@Concurrency@@QAEXXZ"                                                                      },
    { 0x00f6, "?lock_read@reader_writer_lock@Concurrency@@QAEXXZ"                                                                 },
    { 0x00f7, "?name@type_info@@QBEPBDPAU__type_info_node@@@Z"                                                                    },
    { 0x00f8, "?native_handle@critical_section@Concurrency@@QAEAAV12@XZ"                                                          },
    { 0x00f9, "?raw_name@type_info@@QBEPBDXZ"                                                                                     },
    { 0x00fa, "?reset@event@Concurrency@@QAEXXZ"                                                                                  },
    { 0x00fb, "?set@event@Concurrency@@QAEXXZ"                                                                                    },
    { 0x00fc, "?set_new_handler@@YAP6AXXZP6AXXZ@Z"                                                                                },
    { 0x00fd, "?set_terminate@@YAP6AXXZH@Z"                                                                                       },
    { 0x00fe, "?set_terminate@@YAP6AXXZP6AXXZ@Z"                                                                                  },
    { 0x00ff, "?set_unexpected@@YAP6AXXZH@Z"                                                                                      },
    { 0x0100, "?set_unexpected@@YAP6AXXZP6AXXZ@Z"                                                                                 },
    { 0x0101, "?swprintf@@YAHPAGIPBGZZ"                                                                                           },
    { 0x0102, "?swprintf@@YAHPA_WIPB_WZZ"                                                                                         },
    { 0x0103, "?terminate@@YAXXZ"                                                                                                 },
    { 0x0104, "?try_lock@critical_section@Concurrency@@QAE_NXZ"                                                                   },
    { 0x0105, "?try_lock@reader_writer_lock@Concurrency@@QAE_NXZ"                                                                 },
    { 0x0106, "?try_lock_read@reader_writer_lock@Concurrency@@QAE_NXZ"                                                            },
    { 0x0107, "?unexpected@@YAXXZ"                                                                                                },
    { 0x0108, "?unlock@critical_section@Concurrency@@QAEXXZ"                                                                      },
    { 0x0109, "?unlock@reader_writer_lock@Concurrency@@QAEXXZ"                                                                    },
    { 0x010a, "?vswprintf@@YAHPA_WIPB_WPAD@Z"                                                                                     },
    { 0x010b, "?wait@Concurrency@@YAXI@Z"                                                                                         },
    { 0x010c, "?wait@event@Concurrency@@QAEII@Z"                                                                                  },
    { 0x010d, "?wait_for_multiple@event@Concurrency@@SAIPAPAV12@I_NI@Z"                                                           },
    { 0x010e, "?what@exception@std@@UBEPBDXZ"                                                                                     },
    { 0x0110, "_CIacos"                                                                                                           },
    { 0x0111, "_CIasin"                                                                                                           },
    { 0x0112, "_CIatan"                                                                                                           },
    { 0x0113, "_CIatan2"                                                                                                          },
    { 0x0114, "_CIcos"                                                                                                            },
    { 0x0115, "_CIcosh"                                                                                                           },
    { 0x0116, "_CIexp"                                                                                                            },
    { 0x0117, "_CIfmod"                                                                                                           },
    { 0x0118, "_CIlog"                                                                                                            },
    { 0x0119, "_CIlog10"                                                                                                          },
    { 0x011a, "_CIpow"                                                                                                            },
    { 0x011b, "_CIsin"                                                                                                            },
    { 0x011c, "_CIsinh"                                                                                                           },
    { 0x011d, "_CIsqrt"                                                                                                           },
    { 0x011e, "_CItan"                                                                                                            },
    { 0x011f, "_CItanh"                                                                                                           },
    { 0x0120, "_CRT_RTC_INIT"                                                                                                     },
    { 0x0121, "_CRT_RTC_INITW"                                                                                                    },
    { 0x0122, "_CreateFrameInfo"                                                                                                  },
    { 0x0123, "_CxxThrowException"                                                                                                },
    { 0x0124, "_EH_prolog"                                                                                                        },
    { 0x0125, "_FindAndUnlinkFrame"                                                                                               },
    { 0x0126, "_Getdays"                                                                                                          },
    { 0x0127, "_Getmonths"                                                                                                        },
    { 0x0128, "_Gettnames"                                                                                                        },
    { 0x0129, "_HUGE"                                                                                                             },
    { 0x012a, "_IsExceptionObjectToBeDestroyed"                                                                                   },
    { 0x012b, "_NLG_Dispatch2"                                                                                                    },
    { 0x012c, "_NLG_Return"                                                                                                       },
    { 0x012d, "_NLG_Return2"                                                                                                      },
    { 0x012e, "_Strftime"                                                                                                         },
    { 0x012f, "_XcptFilter"                                                                                                       },
    { 0x0130, "__AdjustPointer"                                                                                                   },
    { 0x0131, "__BuildCatchObject"                                                                                                },
    { 0x0132, "__BuildCatchObjectHelper"                                                                                          },
    { 0x0133, "__CppXcptFilter"                                                                                                   },
    { 0x0134, "__CxxCallUnwindDelDtor"                                                                                            },
    { 0x0135, "__CxxCallUnwindDtor"                                                                                               },
    { 0x0136, "__CxxCallUnwindStdDelDtor"                                                                                         },
    { 0x0137, "__CxxCallUnwindVecDtor"                                                                                            },
    { 0x0138, "__CxxDetectRethrow"                                                                                                },
    { 0x0139, "__CxxExceptionFilter"                                                                                              },
    { 0x013a, "__CxxFrameHandler"                                                                                                 },
    { 0x013b, "__CxxFrameHandler2"                                                                                                },
    { 0x013c, "__CxxFrameHandler3"                                                                                                },
    { 0x013d, "__CxxLongjmpUnwind"                                                                                                },
    { 0x013e, "__CxxQueryExceptionSize"                                                                                           },
    { 0x013f, "__CxxRegisterExceptionObject"                                                                                      },
    { 0x0140, "__CxxUnregisterExceptionObject"                                                                                    },
    { 0x0141, "__DestructExceptionObject"                                                                                         },
    { 0x0142, "__FrameUnwindFilter"                                                                                               },
    { 0x0143, "__RTCastToVoid"                                                                                                    },
    { 0x0144, "__RTDynamicCast"                                                                                                   },
    { 0x0145, "__RTtypeid"                                                                                                        },
    { 0x0146, "__STRINGTOLD"                                                                                                      },
    { 0x0147, "__STRINGTOLD_L"                                                                                                    },
    { 0x0148, "__TypeMatch"                                                                                                       },
    { 0x015e, "___fls_getvalue@4"                                                                                                 },
    { 0x015f, "___fls_setvalue@8"                                                                                                 },
    { 0x0149, "___lc_codepage_func"                                                                                               },
    { 0x014a, "___lc_collate_cp_func"                                                                                             },
    { 0x014b, "___lc_handle_func"                                                                                                 },
    { 0x014c, "___mb_cur_max_func"                                                                                                },
    { 0x014d, "___mb_cur_max_l_func"                                                                                              },
    { 0x014e, "___setlc_active_func"                                                                                              },
    { 0x014f, "___unguarded_readlc_active_add_func"                                                                               },
    { 0x0150, "__argc"                                                                                                            },
    { 0x0151, "__argv"                                                                                                            },
    { 0x0152, "__badioinfo"                                                                                                       },
    { 0x0153, "__clean_type_info_names_internal"                                                                                  },
    { 0x0154, "__control87_2"                                                                                                     },
    { 0x0155, "__create_locale"                                                                                                   },
    { 0x0156, "__crtCompareStringA"                                                                                               },
    { 0x0157, "__crtCompareStringW"                                                                                               },
    { 0x0158, "__crtLCMapStringA"                                                                                                 },
    { 0x0159, "__crtLCMapStringW"                                                                                                 },
    { 0x015a, "__daylight"                                                                                                        },
    { 0x015b, "__dllonexit"                                                                                                       },
    { 0x015c, "__doserrno"                                                                                                        },
    { 0x015d, "__dstbias"                                                                                                         },
    { 0x0160, "__fpecode"                                                                                                         },
    { 0x0161, "__free_locale"                                                                                                     },
    { 0x0162, "__get_current_locale"                                                                                              },
    { 0x0163, "__get_flsindex"                                                                                                    },
    { 0x0164, "__get_tlsindex"                                                                                                    },
    { 0x0165, "__getmainargs"                                                                                                     },
    { 0x0166, "__initenv"                                                                                                         },
    { 0x0167, "__iob_func"                                                                                                        },
    { 0x0168, "__isascii"                                                                                                         },
    { 0x0169, "__iscsym"                                                                                                          },
    { 0x016a, "__iscsymf"                                                                                                         },
    { 0x016b, "__iswcsym"                                                                                                         },
    { 0x016c, "__iswcsymf"                                                                                                        },
    { 0x016d, "__lconv"                                                                                                           },
    { 0x016e, "__lconv_init"                                                                                                      },
    { 0x016f, "__libm_sse2_acos"                                                                                                  },
    { 0x0170, "__libm_sse2_acosf"                                                                                                 },
    { 0x0171, "__libm_sse2_asin"                                                                                                  },
    { 0x0172, "__libm_sse2_asinf"                                                                                                 },
    { 0x0173, "__libm_sse2_atan"                                                                                                  },
    { 0x0174, "__libm_sse2_atan2"                                                                                                 },
    { 0x0175, "__libm_sse2_atanf"                                                                                                 },
    { 0x0176, "__libm_sse2_cos"                                                                                                   },
    { 0x0177, "__libm_sse2_cosf"                                                                                                  },
    { 0x0178, "__libm_sse2_exp"                                                                                                   },
    { 0x0179, "__libm_sse2_expf"                                                                                                  },
    { 0x017a, "__libm_sse2_log"                                                                                                   },
    { 0x017b, "__libm_sse2_log10"                                                                                                 },
    { 0x017c, "__libm_sse2_log10f"                                                                                                },
    { 0x017d, "__libm_sse2_logf"                                                                                                  },
    { 0x017e, "__libm_sse2_pow"                                                                                                   },
    { 0x017f, "__libm_sse2_powf"                                                                                                  },
    { 0x0180, "__libm_sse2_sin"                                                                                                   },
    { 0x0181, "__libm_sse2_sinf"                                                                                                  },
    { 0x0182, "__libm_sse2_tan"                                                                                                   },
    { 0x0183, "__libm_sse2_tanf"                                                                                                  },
    { 0x0184, "__mb_cur_max"                                                                                                      },
    { 0x0185, "__p___argc"                                                                                                        },
    { 0x0186, "__p___argv"                                                                                                        },
    { 0x0187, "__p___initenv"                                                                                                     },
    { 0x0188, "__p___mb_cur_max"                                                                                                  },
    { 0x0189, "__p___wargv"                                                                                                       },
    { 0x018a, "__p___winitenv"                                                                                                    },
    { 0x018b, "__p__acmdln"                                                                                                       },
    { 0x018c, "__p__commode"                                                                                                      },
    { 0x018d, "__p__daylight"                                                                                                     },
    { 0x018e, "__p__dstbias"                                                                                                      },
    { 0x018f, "__p__environ"                                                                                                      },
    { 0x0190, "__p__fmode"                                                                                                        },
    { 0x0191, "__p__iob"                                                                                                          },
    { 0x0192, "__p__mbcasemap"                                                                                                    },
    { 0x0193, "__p__mbctype"                                                                                                      },
    { 0x0194, "__p__pctype"                                                                                                       },
    { 0x0195, "__p__pgmptr"                                                                                                       },
    { 0x0196, "__p__pwctype"                                                                                                      },
    { 0x0197, "__p__timezone"                                                                                                     },
    { 0x0198, "__p__tzname"                                                                                                       },
    { 0x0199, "__p__wcmdln"                                                                                                       },
    { 0x019a, "__p__wenviron"                                                                                                     },
    { 0x019b, "__p__wpgmptr"                                                                                                      },
    { 0x019c, "__pctype_func"                                                                                                     },
    { 0x019d, "__pioinfo"                                                                                                         },
    { 0x019e, "__pwctype_func"                                                                                                    },
    { 0x019f, "__pxcptinfoptrs"                                                                                                   },
    { 0x01a0, "__report_gsfailure"                                                                                                },
    { 0x01a1, "__set_app_type"                                                                                                    },
    { 0x01a2, "__set_flsgetvalue"                                                                                                 },
    { 0x01a3, "__setlc_active"                                                                                                    },
    { 0x01a4, "__setusermatherr"                                                                                                  },
    { 0x01a5, "__strncnt"                                                                                                         },
    { 0x01a6, "__swprintf_l"                                                                                                      },
    { 0x01a7, "__sys_errlist"                                                                                                     },
    { 0x01a8, "__sys_nerr"                                                                                                        },
    { 0x01a9, "__threadhandle"                                                                                                    },
    { 0x01aa, "__threadid"                                                                                                        },
    { 0x01ab, "__timezone"                                                                                                        },
    { 0x01ac, "__toascii"                                                                                                         },
    { 0x01ad, "__tzname"                                                                                                          },
    { 0x01ae, "__unDName"                                                                                                         },
    { 0x01af, "__unDNameEx"                                                                                                       },
    { 0x01b0, "__unDNameHelper"                                                                                                   },
    { 0x00e1, "__uncaught_exception"                                                                                              },
    { 0x01b1, "__unguarded_readlc_active"                                                                                         },
    { 0x01b2, "__vswprintf_l"                                                                                                     },
    { 0x01b3, "__wargv"                                                                                                           },
    { 0x01b4, "__wcserror"                                                                                                        },
    { 0x01b5, "__wcserror_s"                                                                                                      },
    { 0x01b6, "__wcsncnt"                                                                                                         },
    { 0x01b7, "__wgetmainargs"                                                                                                    },
    { 0x01b8, "__winitenv"                                                                                                        },
    { 0x01b9, "_abnormal_termination"                                                                                             },
    { 0x01ba, "_abs64"                                                                                                            },
    { 0x01bb, "_access"                                                                                                           },
    { 0x01bc, "_access_s"                                                                                                         },
    { 0x01bd, "_acmdln"                                                                                                           },
    { 0x01be, "_aligned_free"                                                                                                     },
    { 0x01bf, "_aligned_malloc"                                                                                                   },
    { 0x01c0, "_aligned_msize"                                                                                                    },
    { 0x01c1, "_aligned_offset_malloc"                                                                                            },
    { 0x01c2, "_aligned_offset_realloc"                                                                                           },
    { 0x01c3, "_aligned_offset_recalloc"                                                                                          },
    { 0x01c4, "_aligned_realloc"                                                                                                  },
    { 0x01c5, "_aligned_recalloc"                                                                                                 },
    { 0x01c6, "_amsg_exit"                                                                                                        },
    { 0x01c7, "_assert"                                                                                                           },
    { 0x01c8, "_atodbl"                                                                                                           },
    { 0x01c9, "_atodbl_l"                                                                                                         },
    { 0x01ca, "_atof_l"                                                                                                           },
    { 0x01cb, "_atoflt"                                                                                                           },
    { 0x01cc, "_atoflt_l"                                                                                                         },
    { 0x01cd, "_atoi64"                                                                                                           },
    { 0x01ce, "_atoi64_l"                                                                                                         },
    { 0x01cf, "_atoi_l"                                                                                                           },
    { 0x01d0, "_atol_l"                                                                                                           },
    { 0x01d1, "_atoldbl"                                                                                                          },
    { 0x01d2, "_atoldbl_l"                                                                                                        },
    { 0x01d3, "_beep"                                                                                                             },
    { 0x01d4, "_beginthread"                                                                                                      },
    { 0x01d5, "_beginthreadex"                                                                                                    },
    { 0x01d6, "_byteswap_uint64"                                                                                                  },
    { 0x01d7, "_byteswap_ulong"                                                                                                   },
    { 0x01d8, "_byteswap_ushort"                                                                                                  },
    { 0x01d9, "_c_exit"                                                                                                           },
    { 0x01da, "_cabs"                                                                                                             },
    { 0x01db, "_callnewh"                                                                                                         },
    { 0x01dc, "_calloc_crt"                                                                                                       },
    { 0x01dd, "_cexit"                                                                                                            },
    { 0x01de, "_cgets"                                                                                                            },
    { 0x01df, "_cgets_s"                                                                                                          },
    { 0x01e0, "_cgetws"                                                                                                           },
    { 0x01e1, "_cgetws_s"                                                                                                         },
    { 0x01e2, "_chdir"                                                                                                            },
    { 0x01e3, "_chdrive"                                                                                                          },
    { 0x01e4, "_chgsign"                                                                                                          },
    { 0x01e5, "_chkesp"                                                                                                           },
    { 0x01e6, "_chmod"                                                                                                            },
    { 0x01e7, "_chsize"                                                                                                           },
    { 0x01e8, "_chsize_s"                                                                                                         },
    { 0x01e9, "_clearfp"                                                                                                          },
    { 0x01ea, "_close"                                                                                                            },
    { 0x01eb, "_commit"                                                                                                           },
    { 0x01ec, "_commode"                                                                                                          },
    { 0x01ed, "_configthreadlocale"                                                                                               },
    { 0x01ee, "_control87"                                                                                                        },
    { 0x01ef, "_controlfp"                                                                                                        },
    { 0x01f0, "_controlfp_s"                                                                                                      },
    { 0x01f1, "_copysign"                                                                                                         },
    { 0x01f2, "_cprintf"                                                                                                          },
    { 0x01f3, "_cprintf_l"                                                                                                        },
    { 0x01f4, "_cprintf_p"                                                                                                        },
    { 0x01f5, "_cprintf_p_l"                                                                                                      },
    { 0x01f6, "_cprintf_s"                                                                                                        },
    { 0x01f7, "_cprintf_s_l"                                                                                                      },
    { 0x01f8, "_cputs"                                                                                                            },
    { 0x01f9, "_cputws"                                                                                                           },
    { 0x01fa, "_creat"                                                                                                            },
    { 0x01fb, "_create_locale"                                                                                                    },
    { 0x01fc, "_crt_debugger_hook"                                                                                                },
    { 0x01fd, "_cscanf"                                                                                                           },
    { 0x01fe, "_cscanf_l"                                                                                                         },
    { 0x01ff, "_cscanf_s"                                                                                                         },
    { 0x0200, "_cscanf_s_l"                                                                                                       },
    { 0x0201, "_ctime32"                                                                                                          },
    { 0x0202, "_ctime32_s"                                                                                                        },
    { 0x0203, "_ctime64"                                                                                                          },
    { 0x0204, "_ctime64_s"                                                                                                        },
    { 0x0205, "_cwait"                                                                                                            },
    { 0x0206, "_cwprintf"                                                                                                         },
    { 0x0207, "_cwprintf_l"                                                                                                       },
    { 0x0208, "_cwprintf_p"                                                                                                       },
    { 0x0209, "_cwprintf_p_l"                                                                                                     },
    { 0x020a, "_cwprintf_s"                                                                                                       },
    { 0x020b, "_cwprintf_s_l"                                                                                                     },
    { 0x020c, "_cwscanf"                                                                                                          },
    { 0x020d, "_cwscanf_l"                                                                                                        },
    { 0x020e, "_cwscanf_s"                                                                                                        },
    { 0x020f, "_cwscanf_s_l"                                                                                                      },
    { 0x0210, "_daylight"                                                                                                         },
    { 0x0211, "_difftime32"                                                                                                       },
    { 0x0212, "_difftime64"                                                                                                       },
    { 0x0213, "_dosmaperr"                                                                                                        },
    { 0x0214, "_dstbias"                                                                                                          },
    { 0x0215, "_dup"                                                                                                              },
    { 0x0216, "_dup2"                                                                                                             },
    { 0x0217, "_dupenv_s"                                                                                                         },
    { 0x0218, "_ecvt"                                                                                                             },
    { 0x0219, "_ecvt_s"                                                                                                           },
    { 0x021a, "_encoded_null"                                                                                                     },
    { 0x021b, "_endthread"                                                                                                        },
    { 0x021c, "_endthreadex"                                                                                                      },
    { 0x021d, "_environ"                                                                                                          },
    { 0x021e, "_eof"                                                                                                              },
    { 0x021f, "_errno"                                                                                                            },
    { 0x0220, "_except_handler2"                                                                                                  },
    { 0x0221, "_except_handler3"                                                                                                  },
    { 0x0222, "_except_handler4_common"                                                                                           },
    { 0x0223, "_execl"                                                                                                            },
    { 0x0224, "_execle"                                                                                                           },
    { 0x0225, "_execlp"                                                                                                           },
    { 0x0226, "_execlpe"                                                                                                          },
    { 0x0227, "_execv"                                                                                                            },
    { 0x0228, "_execve"                                                                                                           },
    { 0x0229, "_execvp"                                                                                                           },
    { 0x022a, "_execvpe"                                                                                                          },
    { 0x022b, "_exit"                                                                                                             },
    { 0x022c, "_expand"                                                                                                           },
    { 0x022d, "_fclose_nolock"                                                                                                    },
    { 0x022e, "_fcloseall"                                                                                                        },
    { 0x022f, "_fcvt"                                                                                                             },
    { 0x0230, "_fcvt_s"                                                                                                           },
    { 0x0231, "_fdopen"                                                                                                           },
    { 0x0232, "_fflush_nolock"                                                                                                    },
    { 0x0233, "_fgetchar"                                                                                                         },
    { 0x0234, "_fgetwc_nolock"                                                                                                    },
    { 0x0235, "_fgetwchar"                                                                                                        },
    { 0x0236, "_filbuf"                                                                                                           },
    { 0x0237, "_filelength"                                                                                                       },
    { 0x0238, "_filelengthi64"                                                                                                    },
    { 0x0239, "_fileno"                                                                                                           },
    { 0x023a, "_findclose"                                                                                                        },
    { 0x023b, "_findfirst32"                                                                                                      },
    { 0x023c, "_findfirst32i64"                                                                                                   },
    { 0x023d, "_findfirst64"                                                                                                      },
    { 0x023e, "_findfirst64i32"                                                                                                   },
    { 0x023f, "_findnext32"                                                                                                       },
    { 0x0240, "_findnext32i64"                                                                                                    },
    { 0x0241, "_findnext64"                                                                                                       },
    { 0x0242, "_findnext64i32"                                                                                                    },
    { 0x0243, "_finite"                                                                                                           },
    { 0x0244, "_flsbuf"                                                                                                           },
    { 0x0245, "_flushall"                                                                                                         },
    { 0x0246, "_fmode"                                                                                                            },
    { 0x0247, "_fpclass"                                                                                                          },
    { 0x0248, "_fpieee_flt"                                                                                                       },
    { 0x0249, "_fpreset"                                                                                                          },
    { 0x024a, "_fprintf_l"                                                                                                        },
    { 0x024b, "_fprintf_p"                                                                                                        },
    { 0x024c, "_fprintf_p_l"                                                                                                      },
    { 0x024d, "_fprintf_s_l"                                                                                                      },
    { 0x024e, "_fputchar"                                                                                                         },
    { 0x024f, "_fputwc_nolock"                                                                                                    },
    { 0x0250, "_fputwchar"                                                                                                        },
    { 0x0251, "_fread_nolock"                                                                                                     },
    { 0x0252, "_fread_nolock_s"                                                                                                   },
    { 0x0253, "_free_locale"                                                                                                      },
    { 0x0254, "_freea"                                                                                                            },
    { 0x0255, "_freea_s"                                                                                                          },
    { 0x0256, "_freefls"                                                                                                          },
    { 0x0257, "_fscanf_l"                                                                                                         },
    { 0x0258, "_fscanf_s_l"                                                                                                       },
    { 0x0259, "_fseek_nolock"                                                                                                     },
    { 0x025a, "_fseeki64"                                                                                                         },
    { 0x025b, "_fseeki64_nolock"                                                                                                  },
    { 0x025c, "_fsopen"                                                                                                           },
    { 0x025d, "_fstat32"                                                                                                          },
    { 0x025e, "_fstat32i64"                                                                                                       },
    { 0x025f, "_fstat64"                                                                                                          },
    { 0x0260, "_fstat64i32"                                                                                                       },
    { 0x0261, "_ftell_nolock"                                                                                                     },
    { 0x0262, "_ftelli64"                                                                                                         },
    { 0x0263, "_ftelli64_nolock"                                                                                                  },
    { 0x0264, "_ftime32"                                                                                                          },
    { 0x0265, "_ftime32_s"                                                                                                        },
    { 0x0266, "_ftime64"                                                                                                          },
    { 0x0267, "_ftime64_s"                                                                                                        },
    { 0x0268, "_ftol"                                                                                                             },
    { 0x0269, "_fullpath"                                                                                                         },
    { 0x026a, "_futime32"                                                                                                         },
    { 0x026b, "_futime64"                                                                                                         },
    { 0x026c, "_fwprintf_l"                                                                                                       },
    { 0x026d, "_fwprintf_p"                                                                                                       },
    { 0x026e, "_fwprintf_p_l"                                                                                                     },
    { 0x026f, "_fwprintf_s_l"                                                                                                     },
    { 0x0270, "_fwrite_nolock"                                                                                                    },
    { 0x0271, "_fwscanf_l"                                                                                                        },
    { 0x0272, "_fwscanf_s_l"                                                                                                      },
    { 0x0273, "_gcvt"                                                                                                             },
    { 0x0274, "_gcvt_s"                                                                                                           },
    { 0x0275, "_get_current_locale"                                                                                               },
    { 0x0276, "_get_daylight"                                                                                                     },
    { 0x0277, "_get_doserrno"                                                                                                     },
    { 0x0278, "_get_dstbias"                                                                                                      },
    { 0x0279, "_get_errno"                                                                                                        },
    { 0x027a, "_get_fmode"                                                                                                        },
    { 0x027b, "_get_heap_handle"                                                                                                  },
    { 0x027c, "_get_invalid_parameter_handler"                                                                                    },
    { 0x027d, "_get_osfhandle"                                                                                                    },
    { 0x027e, "_get_output_format"                                                                                                },
    { 0x027f, "_get_pgmptr"                                                                                                       },
    { 0x0280, "_get_printf_count_output"                                                                                          },
    { 0x0281, "_get_purecall_handler"                                                                                             },
    { 0x0282, "_get_terminate"                                                                                                    },
    { 0x0283, "_get_timezone"                                                                                                     },
    { 0x0284, "_get_tzname"                                                                                                       },
    { 0x0285, "_get_unexpected"                                                                                                   },
    { 0x0286, "_get_wpgmptr"                                                                                                      },
    { 0x0287, "_getc_nolock"                                                                                                      },
    { 0x0288, "_getch"                                                                                                            },
    { 0x0289, "_getch_nolock"                                                                                                     },
    { 0x028a, "_getche"                                                                                                           },
    { 0x028b, "_getche_nolock"                                                                                                    },
    { 0x028c, "_getcwd"                                                                                                           },
    { 0x028d, "_getdcwd"                                                                                                          },
    { 0x028e, "_getdcwd_nolock"                                                                                                   },
    { 0x028f, "_getdiskfree"                                                                                                      },
    { 0x0290, "_getdllprocaddr"                                                                                                   },
    { 0x0291, "_getdrive"                                                                                                         },
    { 0x0292, "_getdrives"                                                                                                        },
    { 0x0293, "_getmaxstdio"                                                                                                      },
    { 0x0294, "_getmbcp"                                                                                                          },
    { 0x0295, "_getpid"                                                                                                           },
    { 0x0296, "_getptd"                                                                                                           },
    { 0x0297, "_getsystime"                                                                                                       },
    { 0x0298, "_getw"                                                                                                             },
    { 0x0299, "_getwch"                                                                                                           },
    { 0x029a, "_getwch_nolock"                                                                                                    },
    { 0x029b, "_getwche"                                                                                                          },
    { 0x029c, "_getwche_nolock"                                                                                                   },
    { 0x029d, "_getws"                                                                                                            },
    { 0x029e, "_getws_s"                                                                                                          },
    { 0x029f, "_global_unwind2"                                                                                                   },
    { 0x02a0, "_gmtime32"                                                                                                         },
    { 0x02a1, "_gmtime32_s"                                                                                                       },
    { 0x02a2, "_gmtime64"                                                                                                         },
    { 0x02a3, "_gmtime64_s"                                                                                                       },
    { 0x02a4, "_heapadd"                                                                                                          },
    { 0x02a5, "_heapchk"                                                                                                          },
    { 0x02a6, "_heapmin"                                                                                                          },
    { 0x02a7, "_heapset"                                                                                                          },
    { 0x02a8, "_heapused"                                                                                                         },
    { 0x02a9, "_heapwalk"                                                                                                         },
    { 0x02aa, "_hypot"                                                                                                            },
    { 0x02ab, "_hypotf"                                                                                                           },
    { 0x02ac, "_i64toa"                                                                                                           },
    { 0x02ad, "_i64toa_s"                                                                                                         },
    { 0x02ae, "_i64tow"                                                                                                           },
    { 0x02af, "_i64tow_s"                                                                                                         },
    { 0x02b0, "_initptd"                                                                                                          },
    { 0x02b1, "_initterm"                                                                                                         },
    { 0x02b2, "_initterm_e"                                                                                                       },
    { 0x02b3, "_inp"                                                                                                              },
    { 0x02b4, "_inpd"                                                                                                             },
    { 0x02b5, "_inpw"                                                                                                             },
    { 0x02b6, "_invalid_parameter"                                                                                                },
    { 0x02b7, "_invalid_parameter_noinfo"                                                                                         },
    { 0x02b8, "_invalid_parameter_noinfo_noreturn"                                                                                },
    { 0x02b9, "_invoke_watson"                                                                                                    },
    { 0x02ba, "_iob"                                                                                                              },
    { 0x02bb, "_isalnum_l"                                                                                                        },
    { 0x02bc, "_isalpha_l"                                                                                                        },
    { 0x02bd, "_isatty"                                                                                                           },
    { 0x02be, "_iscntrl_l"                                                                                                        },
    { 0x02bf, "_isctype"                                                                                                          },
    { 0x02c0, "_isctype_l"                                                                                                        },
    { 0x02c1, "_isdigit_l"                                                                                                        },
    { 0x02c2, "_isgraph_l"                                                                                                        },
    { 0x02c3, "_isleadbyte_l"                                                                                                     },
    { 0x02c4, "_islower_l"                                                                                                        },
    { 0x02c5, "_ismbbalnum"                                                                                                       },
    { 0x02c6, "_ismbbalnum_l"                                                                                                     },
    { 0x02c7, "_ismbbalpha"                                                                                                       },
    { 0x02c8, "_ismbbalpha_l"                                                                                                     },
    { 0x02c9, "_ismbbgraph"                                                                                                       },
    { 0x02ca, "_ismbbgraph_l"                                                                                                     },
    { 0x02cb, "_ismbbkalnum"                                                                                                      },
    { 0x02cc, "_ismbbkalnum_l"                                                                                                    },
    { 0x02cd, "_ismbbkana"                                                                                                        },
    { 0x02ce, "_ismbbkana_l"                                                                                                      },
    { 0x02cf, "_ismbbkprint"                                                                                                      },
    { 0x02d0, "_ismbbkprint_l"                                                                                                    },
    { 0x02d1, "_ismbbkpunct"                                                                                                      },
    { 0x02d2, "_ismbbkpunct_l"                                                                                                    },
    { 0x02d3, "_ismbblead"                                                                                                        },
    { 0x02d4, "_ismbblead_l"                                                                                                      },
    { 0x02d5, "_ismbbprint"                                                                                                       },
    { 0x02d6, "_ismbbprint_l"                                                                                                     },
    { 0x02d7, "_ismbbpunct"                                                                                                       },
    { 0x02d8, "_ismbbpunct_l"                                                                                                     },
    { 0x02d9, "_ismbbtrail"                                                                                                       },
    { 0x02da, "_ismbbtrail_l"                                                                                                     },
    { 0x02db, "_ismbcalnum"                                                                                                       },
    { 0x02dc, "_ismbcalnum_l"                                                                                                     },
    { 0x02dd, "_ismbcalpha"                                                                                                       },
    { 0x02de, "_ismbcalpha_l"                                                                                                     },
    { 0x02df, "_ismbcdigit"                                                                                                       },
    { 0x02e0, "_ismbcdigit_l"                                                                                                     },
    { 0x02e1, "_ismbcgraph"                                                                                                       },
    { 0x02e2, "_ismbcgraph_l"                                                                                                     },
    { 0x02e3, "_ismbchira"                                                                                                        },
    { 0x02e4, "_ismbchira_l"                                                                                                      },
    { 0x02e5, "_ismbckata"                                                                                                        },
    { 0x02e6, "_ismbckata_l"                                                                                                      },
    { 0x02e7, "_ismbcl0"                                                                                                          },
    { 0x02e8, "_ismbcl0_l"                                                                                                        },
    { 0x02e9, "_ismbcl1"                                                                                                          },
    { 0x02ea, "_ismbcl1_l"                                                                                                        },
    { 0x02eb, "_ismbcl2"                                                                                                          },
    { 0x02ec, "_ismbcl2_l"                                                                                                        },
    { 0x02ed, "_ismbclegal"                                                                                                       },
    { 0x02ee, "_ismbclegal_l"                                                                                                     },
    { 0x02ef, "_ismbclower"                                                                                                       },
    { 0x02f0, "_ismbclower_l"                                                                                                     },
    { 0x02f1, "_ismbcprint"                                                                                                       },
    { 0x02f2, "_ismbcprint_l"                                                                                                     },
    { 0x02f3, "_ismbcpunct"                                                                                                       },
    { 0x02f4, "_ismbcpunct_l"                                                                                                     },
    { 0x02f5, "_ismbcspace"                                                                                                       },
    { 0x02f6, "_ismbcspace_l"                                                                                                     },
    { 0x02f7, "_ismbcsymbol"                                                                                                      },
    { 0x02f8, "_ismbcsymbol_l"                                                                                                    },
    { 0x02f9, "_ismbcupper"                                                                                                       },
    { 0x02fa, "_ismbcupper_l"                                                                                                     },
    { 0x02fb, "_ismbslead"                                                                                                        },
    { 0x02fc, "_ismbslead_l"                                                                                                      },
    { 0x02fd, "_ismbstrail"                                                                                                       },
    { 0x02fe, "_ismbstrail_l"                                                                                                     },
    { 0x02ff, "_isnan"                                                                                                            },
    { 0x0300, "_isprint_l"                                                                                                        },
    { 0x0301, "_ispunct_l"                                                                                                        },
    { 0x0302, "_isspace_l"                                                                                                        },
    { 0x0303, "_isupper_l"                                                                                                        },
    { 0x0304, "_iswalnum_l"                                                                                                       },
    { 0x0305, "_iswalpha_l"                                                                                                       },
    { 0x0306, "_iswcntrl_l"                                                                                                       },
    { 0x0307, "_iswcsym_l"                                                                                                        },
    { 0x0308, "_iswcsymf_l"                                                                                                       },
    { 0x0309, "_iswctype_l"                                                                                                       },
    { 0x030a, "_iswdigit_l"                                                                                                       },
    { 0x030b, "_iswgraph_l"                                                                                                       },
    { 0x030c, "_iswlower_l"                                                                                                       },
    { 0x030d, "_iswprint_l"                                                                                                       },
    { 0x030e, "_iswpunct_l"                                                                                                       },
    { 0x030f, "_iswspace_l"                                                                                                       },
    { 0x0310, "_iswupper_l"                                                                                                       },
    { 0x0311, "_iswxdigit_l"                                                                                                      },
    { 0x0312, "_isxdigit_l"                                                                                                       },
    { 0x0313, "_itoa"                                                                                                             },
    { 0x0314, "_itoa_s"                                                                                                           },
    { 0x0315, "_itow"                                                                                                             },
    { 0x0316, "_itow_s"                                                                                                           },
    { 0x0317, "_j0"                                                                                                               },
    { 0x0318, "_j1"                                                                                                               },
    { 0x0319, "_jn"                                                                                                               },
    { 0x031a, "_kbhit"                                                                                                            },
    { 0x031b, "_lfind"                                                                                                            },
    { 0x031c, "_lfind_s"                                                                                                          },
    { 0x031d, "_loaddll"                                                                                                          },
    { 0x031e, "_local_unwind2"                                                                                                    },
    { 0x031f, "_local_unwind4"                                                                                                    },
    { 0x0320, "_localtime32"                                                                                                      },
    { 0x0321, "_localtime32_s"                                                                                                    },
    { 0x0322, "_localtime64"                                                                                                      },
    { 0x0323, "_localtime64_s"                                                                                                    },
    { 0x0324, "_lock"                                                                                                             },
    { 0x0325, "_lock_file"                                                                                                        },
    { 0x0326, "_locking"                                                                                                          },
    { 0x0327, "_logb"                                                                                                             },
    { 0x0328, "_longjmpex"                                                                                                        },
    { 0x0329, "_lrotl"                                                                                                            },
    { 0x032a, "_lrotr"                                                                                                            },
    { 0x032b, "_lsearch"                                                                                                          },
    { 0x032c, "_lsearch_s"                                                                                                        },
    { 0x032d, "_lseek"                                                                                                            },
    { 0x032e, "_lseeki64"                                                                                                         },
    { 0x032f, "_ltoa"                                                                                                             },
    { 0x0330, "_ltoa_s"                                                                                                           },
    { 0x0331, "_ltow"                                                                                                             },
    { 0x0332, "_ltow_s"                                                                                                           },
    { 0x0333, "_makepath"                                                                                                         },
    { 0x0334, "_makepath_s"                                                                                                       },
    { 0x0335, "_malloc_crt"                                                                                                       },
    { 0x0336, "_mbbtombc"                                                                                                         },
    { 0x0337, "_mbbtombc_l"                                                                                                       },
    { 0x0338, "_mbbtype"                                                                                                          },
    { 0x0339, "_mbbtype_l"                                                                                                        },
    { 0x033a, "_mbcasemap"                                                                                                        },
    { 0x033b, "_mbccpy"                                                                                                           },
    { 0x033c, "_mbccpy_l"                                                                                                         },
    { 0x033d, "_mbccpy_s"                                                                                                         },
    { 0x033e, "_mbccpy_s_l"                                                                                                       },
    { 0x033f, "_mbcjistojms"                                                                                                      },
    { 0x0340, "_mbcjistojms_l"                                                                                                    },
    { 0x0341, "_mbcjmstojis"                                                                                                      },
    { 0x0342, "_mbcjmstojis_l"                                                                                                    },
    { 0x0343, "_mbclen"                                                                                                           },
    { 0x0344, "_mbclen_l"                                                                                                         },
    { 0x0345, "_mbctohira"                                                                                                        },
    { 0x0346, "_mbctohira_l"                                                                                                      },
    { 0x0347, "_mbctokata"                                                                                                        },
    { 0x0348, "_mbctokata_l"                                                                                                      },
    { 0x0349, "_mbctolower"                                                                                                       },
    { 0x034a, "_mbctolower_l"                                                                                                     },
    { 0x034b, "_mbctombb"                                                                                                         },
    { 0x034c, "_mbctombb_l"                                                                                                       },
    { 0x034d, "_mbctoupper"                                                                                                       },
    { 0x034e, "_mbctoupper_l"                                                                                                     },
    { 0x034f, "_mbctype"                                                                                                          },
    { 0x0350, "_mblen_l"                                                                                                          },
    { 0x0351, "_mbsbtype"                                                                                                         },
    { 0x0352, "_mbsbtype_l"                                                                                                       },
    { 0x0353, "_mbscat_s"                                                                                                         },
    { 0x0354, "_mbscat_s_l"                                                                                                       },
    { 0x0355, "_mbschr"                                                                                                           },
    { 0x0356, "_mbschr_l"                                                                                                         },
    { 0x0357, "_mbscmp"                                                                                                           },
    { 0x0358, "_mbscmp_l"                                                                                                         },
    { 0x0359, "_mbscoll"                                                                                                          },
    { 0x035a, "_mbscoll_l"                                                                                                        },
    { 0x035b, "_mbscpy_s"                                                                                                         },
    { 0x035c, "_mbscpy_s_l"                                                                                                       },
    { 0x035d, "_mbscspn"                                                                                                          },
    { 0x035e, "_mbscspn_l"                                                                                                        },
    { 0x035f, "_mbsdec"                                                                                                           },
    { 0x0360, "_mbsdec_l"                                                                                                         },
    { 0x0361, "_mbsicmp"                                                                                                          },
    { 0x0362, "_mbsicmp_l"                                                                                                        },
    { 0x0363, "_mbsicoll"                                                                                                         },
    { 0x0364, "_mbsicoll_l"                                                                                                       },
    { 0x0365, "_mbsinc"                                                                                                           },
    { 0x0366, "_mbsinc_l"                                                                                                         },
    { 0x0367, "_mbslen"                                                                                                           },
    { 0x0368, "_mbslen_l"                                                                                                         },
    { 0x0369, "_mbslwr"                                                                                                           },
    { 0x036a, "_mbslwr_l"                                                                                                         },
    { 0x036b, "_mbslwr_s"                                                                                                         },
    { 0x036c, "_mbslwr_s_l"                                                                                                       },
    { 0x036d, "_mbsnbcat"                                                                                                         },
    { 0x036e, "_mbsnbcat_l"                                                                                                       },
    { 0x036f, "_mbsnbcat_s"                                                                                                       },
    { 0x0370, "_mbsnbcat_s_l"                                                                                                     },
    { 0x0371, "_mbsnbcmp"                                                                                                         },
    { 0x0372, "_mbsnbcmp_l"                                                                                                       },
    { 0x0373, "_mbsnbcnt"                                                                                                         },
    { 0x0374, "_mbsnbcnt_l"                                                                                                       },
    { 0x0375, "_mbsnbcoll"                                                                                                        },
    { 0x0376, "_mbsnbcoll_l"                                                                                                      },
    { 0x0377, "_mbsnbcpy"                                                                                                         },
    { 0x0378, "_mbsnbcpy_l"                                                                                                       },
    { 0x0379, "_mbsnbcpy_s"                                                                                                       },
    { 0x037a, "_mbsnbcpy_s_l"                                                                                                     },
    { 0x037b, "_mbsnbicmp"                                                                                                        },
    { 0x037c, "_mbsnbicmp_l"                                                                                                      },
    { 0x037d, "_mbsnbicoll"                                                                                                       },
    { 0x037e, "_mbsnbicoll_l"                                                                                                     },
    { 0x037f, "_mbsnbset"                                                                                                         },
    { 0x0380, "_mbsnbset_l"                                                                                                       },
    { 0x0381, "_mbsnbset_s"                                                                                                       },
    { 0x0382, "_mbsnbset_s_l"                                                                                                     },
    { 0x0383, "_mbsncat"                                                                                                          },
    { 0x0384, "_mbsncat_l"                                                                                                        },
    { 0x0385, "_mbsncat_s"                                                                                                        },
    { 0x0386, "_mbsncat_s_l"                                                                                                      },
    { 0x0387, "_mbsnccnt"                                                                                                         },
    { 0x0388, "_mbsnccnt_l"                                                                                                       },
    { 0x0389, "_mbsncmp"                                                                                                          },
    { 0x038a, "_mbsncmp_l"                                                                                                        },
    { 0x038b, "_mbsncoll"                                                                                                         },
    { 0x038c, "_mbsncoll_l"                                                                                                       },
    { 0x038d, "_mbsncpy"                                                                                                          },
    { 0x038e, "_mbsncpy_l"                                                                                                        },
    { 0x038f, "_mbsncpy_s"                                                                                                        },
    { 0x0390, "_mbsncpy_s_l"                                                                                                      },
    { 0x0391, "_mbsnextc"                                                                                                         },
    { 0x0392, "_mbsnextc_l"                                                                                                       },
    { 0x0393, "_mbsnicmp"                                                                                                         },
    { 0x0394, "_mbsnicmp_l"                                                                                                       },
    { 0x0395, "_mbsnicoll"                                                                                                        },
    { 0x0396, "_mbsnicoll_l"                                                                                                      },
    { 0x0397, "_mbsninc"                                                                                                          },
    { 0x0398, "_mbsninc_l"                                                                                                        },
    { 0x0399, "_mbsnlen"                                                                                                          },
    { 0x039a, "_mbsnlen_l"                                                                                                        },
    { 0x039b, "_mbsnset"                                                                                                          },
    { 0x039c, "_mbsnset_l"                                                                                                        },
    { 0x039d, "_mbsnset_s"                                                                                                        },
    { 0x039e, "_mbsnset_s_l"                                                                                                      },
    { 0x039f, "_mbspbrk"                                                                                                          },
    { 0x03a0, "_mbspbrk_l"                                                                                                        },
    { 0x03a1, "_mbsrchr"                                                                                                          },
    { 0x03a2, "_mbsrchr_l"                                                                                                        },
    { 0x03a3, "_mbsrev"                                                                                                           },
    { 0x03a4, "_mbsrev_l"                                                                                                         },
    { 0x03a5, "_mbsset"                                                                                                           },
    { 0x03a6, "_mbsset_l"                                                                                                         },
    { 0x03a7, "_mbsset_s"                                                                                                         },
    { 0x03a8, "_mbsset_s_l"                                                                                                       },
    { 0x03a9, "_mbsspn"                                                                                                           },
    { 0x03aa, "_mbsspn_l"                                                                                                         },
    { 0x03ab, "_mbsspnp"                                                                                                          },
    { 0x03ac, "_mbsspnp_l"                                                                                                        },
    { 0x03ad, "_mbsstr"                                                                                                           },
    { 0x03ae, "_mbsstr_l"                                                                                                         },
    { 0x03af, "_mbstok"                                                                                                           },
    { 0x03b0, "_mbstok_l"                                                                                                         },
    { 0x03b1, "_mbstok_s"                                                                                                         },
    { 0x03b2, "_mbstok_s_l"                                                                                                       },
    { 0x03b3, "_mbstowcs_l"                                                                                                       },
    { 0x03b4, "_mbstowcs_s_l"                                                                                                     },
    { 0x03b5, "_mbstrlen"                                                                                                         },
    { 0x03b6, "_mbstrlen_l"                                                                                                       },
    { 0x03b7, "_mbstrnlen"                                                                                                        },
    { 0x03b8, "_mbstrnlen_l"                                                                                                      },
    { 0x03b9, "_mbsupr"                                                                                                           },
    { 0x03ba, "_mbsupr_l"                                                                                                         },
    { 0x03bb, "_mbsupr_s"                                                                                                         },
    { 0x03bc, "_mbsupr_s_l"                                                                                                       },
    { 0x03bd, "_mbtowc_l"                                                                                                         },
    { 0x03be, "_memccpy"                                                                                                          },
    { 0x03bf, "_memicmp"                                                                                                          },
    { 0x03c0, "_memicmp_l"                                                                                                        },
    { 0x03c1, "_mkdir"                                                                                                            },
    { 0x03c2, "_mkgmtime32"                                                                                                       },
    { 0x03c3, "_mkgmtime64"                                                                                                       },
    { 0x03c4, "_mktemp"                                                                                                           },
    { 0x03c5, "_mktemp_s"                                                                                                         },
    { 0x03c6, "_mktime32"                                                                                                         },
    { 0x03c7, "_mktime64"                                                                                                         },
    { 0x03c8, "_msize"                                                                                                            },
    { 0x03c9, "_nextafter"                                                                                                        },
    { 0x03ca, "_onexit"                                                                                                           },
    { 0x03cb, "_open"                                                                                                             },
    { 0x03cc, "_open_osfhandle"                                                                                                   },
    { 0x03cd, "_outp"                                                                                                             },
    { 0x03ce, "_outpd"                                                                                                            },
    { 0x03cf, "_outpw"                                                                                                            },
    { 0x03d0, "_pclose"                                                                                                           },
    { 0x03d1, "_pctype"                                                                                                           },
    { 0x03d2, "_pgmptr"                                                                                                           },
    { 0x03d3, "_pipe"                                                                                                             },
    { 0x03d4, "_popen"                                                                                                            },
    { 0x03d5, "_printf_l"                                                                                                         },
    { 0x03d6, "_printf_p"                                                                                                         },
    { 0x03d7, "_printf_p_l"                                                                                                       },
    { 0x03d8, "_printf_s_l"                                                                                                       },
    { 0x03d9, "_purecall"                                                                                                         },
    { 0x03da, "_putch"                                                                                                            },
    { 0x03db, "_putch_nolock"                                                                                                     },
    { 0x03dc, "_putenv"                                                                                                           },
    { 0x03dd, "_putenv_s"                                                                                                         },
    { 0x03de, "_putw"                                                                                                             },
    { 0x03df, "_putwch"                                                                                                           },
    { 0x03e0, "_putwch_nolock"                                                                                                    },
    { 0x03e1, "_putws"                                                                                                            },
    { 0x03e2, "_pwctype"                                                                                                          },
    { 0x03e3, "_read"                                                                                                             },
    { 0x03e4, "_realloc_crt"                                                                                                      },
    { 0x03e5, "_recalloc"                                                                                                         },
    { 0x03e6, "_recalloc_crt"                                                                                                     },
    { 0x03e7, "_resetstkoflw"                                                                                                     },
    { 0x03e8, "_rmdir"                                                                                                            },
    { 0x03e9, "_rmtmp"                                                                                                            },
    { 0x03ea, "_rotl"                                                                                                             },
    { 0x03eb, "_rotl64"                                                                                                           },
    { 0x03ec, "_rotr"                                                                                                             },
    { 0x03ed, "_rotr64"                                                                                                           },
    { 0x03ee, "_scalb"                                                                                                            },
    { 0x03ef, "_scanf_l"                                                                                                          },
    { 0x03f0, "_scanf_s_l"                                                                                                        },
    { 0x03f1, "_scprintf"                                                                                                         },
    { 0x03f2, "_scprintf_l"                                                                                                       },
    { 0x03f3, "_scprintf_p"                                                                                                       },
    { 0x03f4, "_scprintf_p_l"                                                                                                     },
    { 0x03f5, "_scwprintf"                                                                                                        },
    { 0x03f6, "_scwprintf_l"                                                                                                      },
    { 0x03f7, "_scwprintf_p"                                                                                                      },
    { 0x03f8, "_scwprintf_p_l"                                                                                                    },
    { 0x03f9, "_searchenv"                                                                                                        },
    { 0x03fa, "_searchenv_s"                                                                                                      },
    { 0x03fc, "_seh_longjmp_unwind"                                                                                               },
    { 0x03fb, "_seh_longjmp_unwind4"                                                                                              },
    { 0x03fd, "_set_SSE2_enable"                                                                                                  },
    { 0x03fe, "_set_abort_behavior"                                                                                               },
    { 0x03ff, "_set_controlfp"                                                                                                    },
    { 0x0400, "_set_doserrno"                                                                                                     },
    { 0x0401, "_set_errno"                                                                                                        },
    { 0x0402, "_set_error_mode"                                                                                                   },
    { 0x0403, "_set_fmode"                                                                                                        },
    { 0x0404, "_set_invalid_parameter_handler"                                                                                    },
    { 0x0405, "_set_malloc_crt_max_wait"                                                                                          },
    { 0x0406, "_set_output_format"                                                                                                },
    { 0x0407, "_set_printf_count_output"                                                                                          },
    { 0x0408, "_set_purecall_handler"                                                                                             },
    { 0x0409, "_seterrormode"                                                                                                     },
    { 0x040a, "_setjmp"                                                                                                           },
    { 0x040b, "_setjmp3"                                                                                                          },
    { 0x040c, "_setmaxstdio"                                                                                                      },
    { 0x040d, "_setmbcp"                                                                                                          },
    { 0x040e, "_setmode"                                                                                                          },
    { 0x040f, "_setsystime"                                                                                                       },
    { 0x0410, "_sleep"                                                                                                            },
    { 0x0411, "_snprintf"                                                                                                         },
    { 0x0412, "_snprintf_c"                                                                                                       },
    { 0x0413, "_snprintf_c_l"                                                                                                     },
    { 0x0414, "_snprintf_l"                                                                                                       },
    { 0x0415, "_snprintf_s"                                                                                                       },
    { 0x0416, "_snprintf_s_l"                                                                                                     },
    { 0x0417, "_snscanf"                                                                                                          },
    { 0x0418, "_snscanf_l"                                                                                                        },
    { 0x0419, "_snscanf_s"                                                                                                        },
    { 0x041a, "_snscanf_s_l"                                                                                                      },
    { 0x041b, "_snwprintf"                                                                                                        },
    { 0x041c, "_snwprintf_l"                                                                                                      },
    { 0x041d, "_snwprintf_s"                                                                                                      },
    { 0x041e, "_snwprintf_s_l"                                                                                                    },
    { 0x041f, "_snwscanf"                                                                                                         },
    { 0x0420, "_snwscanf_l"                                                                                                       },
    { 0x0421, "_snwscanf_s"                                                                                                       },
    { 0x0422, "_snwscanf_s_l"                                                                                                     },
    { 0x0423, "_sopen"                                                                                                            },
    { 0x0424, "_sopen_s"                                                                                                          },
    { 0x0425, "_spawnl"                                                                                                           },
    { 0x0426, "_spawnle"                                                                                                          },
    { 0x0427, "_spawnlp"                                                                                                          },
    { 0x0428, "_spawnlpe"                                                                                                         },
    { 0x0429, "_spawnv"                                                                                                           },
    { 0x042a, "_spawnve"                                                                                                          },
    { 0x042b, "_spawnvp"                                                                                                          },
    { 0x042c, "_spawnvpe"                                                                                                         },
    { 0x042d, "_splitpath"                                                                                                        },
    { 0x042e, "_splitpath_s"                                                                                                      },
    { 0x042f, "_sprintf_l"                                                                                                        },
    { 0x0430, "_sprintf_p"                                                                                                        },
    { 0x0431, "_sprintf_p_l"                                                                                                      },
    { 0x0432, "_sprintf_s_l"                                                                                                      },
    { 0x0433, "_sscanf_l"                                                                                                         },
    { 0x0434, "_sscanf_s_l"                                                                                                       },
    { 0x0435, "_stat32"                                                                                                           },
    { 0x0436, "_stat32i64"                                                                                                        },
    { 0x0437, "_stat64"                                                                                                           },
    { 0x0438, "_stat64i32"                                                                                                        },
    { 0x0439, "_statusfp"                                                                                                         },
    { 0x043a, "_statusfp2"                                                                                                        },
    { 0x043b, "_strcoll_l"                                                                                                        },
    { 0x043c, "_strdate"                                                                                                          },
    { 0x043d, "_strdate_s"                                                                                                        },
    { 0x043e, "_strdup"                                                                                                           },
    { 0x043f, "_strerror"                                                                                                         },
    { 0x0440, "_strerror_s"                                                                                                       },
    { 0x0441, "_strftime_l"                                                                                                       },
    { 0x0442, "_stricmp"                                                                                                          },
    { 0x0443, "_stricmp_l"                                                                                                        },
    { 0x0444, "_stricoll"                                                                                                         },
    { 0x0445, "_stricoll_l"                                                                                                       },
    { 0x0446, "_strlwr"                                                                                                           },
    { 0x0447, "_strlwr_l"                                                                                                         },
    { 0x0448, "_strlwr_s"                                                                                                         },
    { 0x0449, "_strlwr_s_l"                                                                                                       },
    { 0x044a, "_strncoll"                                                                                                         },
    { 0x044b, "_strncoll_l"                                                                                                       },
    { 0x044c, "_strnicmp"                                                                                                         },
    { 0x044d, "_strnicmp_l"                                                                                                       },
    { 0x044e, "_strnicoll"                                                                                                        },
    { 0x044f, "_strnicoll_l"                                                                                                      },
    { 0x0450, "_strnset"                                                                                                          },
    { 0x0451, "_strnset_s"                                                                                                        },
    { 0x0452, "_strrev"                                                                                                           },
    { 0x0453, "_strset"                                                                                                           },
    { 0x0454, "_strset_s"                                                                                                         },
    { 0x0455, "_strtime"                                                                                                          },
    { 0x0456, "_strtime_s"                                                                                                        },
    { 0x0457, "_strtod_l"                                                                                                         },
    { 0x0458, "_strtoi64"                                                                                                         },
    { 0x0459, "_strtoi64_l"                                                                                                       },
    { 0x045a, "_strtol_l"                                                                                                         },
    { 0x045b, "_strtoui64"                                                                                                        },
    { 0x045c, "_strtoui64_l"                                                                                                      },
    { 0x045d, "_strtoul_l"                                                                                                        },
    { 0x045e, "_strupr"                                                                                                           },
    { 0x045f, "_strupr_l"                                                                                                         },
    { 0x0460, "_strupr_s"                                                                                                         },
    { 0x0461, "_strupr_s_l"                                                                                                       },
    { 0x0462, "_strxfrm_l"                                                                                                        },
    { 0x0463, "_swab"                                                                                                             },
    { 0x0464, "_swprintf"                                                                                                         },
    { 0x0465, "_swprintf_c"                                                                                                       },
    { 0x0466, "_swprintf_c_l"                                                                                                     },
    { 0x0467, "_swprintf_p"                                                                                                       },
    { 0x0468, "_swprintf_p_l"                                                                                                     },
    { 0x0469, "_swprintf_s_l"                                                                                                     },
    { 0x046a, "_swscanf_l"                                                                                                        },
    { 0x046b, "_swscanf_s_l"                                                                                                      },
    { 0x046c, "_sys_errlist"                                                                                                      },
    { 0x046d, "_sys_nerr"                                                                                                         },
    { 0x046e, "_tell"                                                                                                             },
    { 0x046f, "_telli64"                                                                                                          },
    { 0x0470, "_tempnam"                                                                                                          },
    { 0x0471, "_time32"                                                                                                           },
    { 0x0472, "_time64"                                                                                                           },
    { 0x0473, "_timezone"                                                                                                         },
    { 0x0474, "_tolower"                                                                                                          },
    { 0x0475, "_tolower_l"                                                                                                        },
    { 0x0476, "_toupper"                                                                                                          },
    { 0x0477, "_toupper_l"                                                                                                        },
    { 0x0478, "_towlower_l"                                                                                                       },
    { 0x0479, "_towupper_l"                                                                                                       },
    { 0x047a, "_tzname"                                                                                                           },
    { 0x047b, "_tzset"                                                                                                            },
    { 0x047c, "_ui64toa"                                                                                                          },
    { 0x047d, "_ui64toa_s"                                                                                                        },
    { 0x047e, "_ui64tow"                                                                                                          },
    { 0x047f, "_ui64tow_s"                                                                                                        },
    { 0x0480, "_ultoa"                                                                                                            },
    { 0x0481, "_ultoa_s"                                                                                                          },
    { 0x0482, "_ultow"                                                                                                            },
    { 0x0483, "_ultow_s"                                                                                                          },
    { 0x0484, "_umask"                                                                                                            },
    { 0x0485, "_umask_s"                                                                                                          },
    { 0x0486, "_ungetc_nolock"                                                                                                    },
    { 0x0487, "_ungetch"                                                                                                          },
    { 0x0488, "_ungetch_nolock"                                                                                                   },
    { 0x0489, "_ungetwc_nolock"                                                                                                   },
    { 0x048a, "_ungetwch"                                                                                                         },
    { 0x048b, "_ungetwch_nolock"                                                                                                  },
    { 0x048c, "_unlink"                                                                                                           },
    { 0x048d, "_unloaddll"                                                                                                        },
    { 0x048e, "_unlock"                                                                                                           },
    { 0x048f, "_unlock_file"                                                                                                      },
    { 0x0490, "_utime32"                                                                                                          },
    { 0x0491, "_utime64"                                                                                                          },
    { 0x0492, "_vcprintf"                                                                                                         },
    { 0x0493, "_vcprintf_l"                                                                                                       },
    { 0x0494, "_vcprintf_p"                                                                                                       },
    { 0x0495, "_vcprintf_p_l"                                                                                                     },
    { 0x0496, "_vcprintf_s"                                                                                                       },
    { 0x0497, "_vcprintf_s_l"                                                                                                     },
    { 0x0498, "_vcwprintf"                                                                                                        },
    { 0x0499, "_vcwprintf_l"                                                                                                      },
    { 0x049a, "_vcwprintf_p"                                                                                                      },
    { 0x049b, "_vcwprintf_p_l"                                                                                                    },
    { 0x049c, "_vcwprintf_s"                                                                                                      },
    { 0x049d, "_vcwprintf_s_l"                                                                                                    },
    { 0x049e, "_vfprintf_l"                                                                                                       },
    { 0x049f, "_vfprintf_p"                                                                                                       },
    { 0x04a0, "_vfprintf_p_l"                                                                                                     },
    { 0x04a1, "_vfprintf_s_l"                                                                                                     },
    { 0x04a2, "_vfwprintf_l"                                                                                                      },
    { 0x04a3, "_vfwprintf_p"                                                                                                      },
    { 0x04a4, "_vfwprintf_p_l"                                                                                                    },
    { 0x04a5, "_vfwprintf_s_l"                                                                                                    },
    { 0x04a6, "_vprintf_l"                                                                                                        },
    { 0x04a7, "_vprintf_p"                                                                                                        },
    { 0x04a8, "_vprintf_p_l"                                                                                                      },
    { 0x04a9, "_vprintf_s_l"                                                                                                      },
    { 0x04aa, "_vscprintf"                                                                                                        },
    { 0x04ab, "_vscprintf_l"                                                                                                      },
    { 0x04ac, "_vscprintf_p"                                                                                                      },
    { 0x04ad, "_vscprintf_p_l"                                                                                                    },
    { 0x04ae, "_vscwprintf"                                                                                                       },
    { 0x04af, "_vscwprintf_l"                                                                                                     },
    { 0x04b0, "_vscwprintf_p"                                                                                                     },
    { 0x04b1, "_vscwprintf_p_l"                                                                                                   },
    { 0x04b2, "_vsnprintf"                                                                                                        },
    { 0x04b3, "_vsnprintf_c"                                                                                                      },
    { 0x04b4, "_vsnprintf_c_l"                                                                                                    },
    { 0x04b5, "_vsnprintf_l"                                                                                                      },
    { 0x04b6, "_vsnprintf_s"                                                                                                      },
    { 0x04b7, "_vsnprintf_s_l"                                                                                                    },
    { 0x04b8, "_vsnwprintf"                                                                                                       },
    { 0x04b9, "_vsnwprintf_l"                                                                                                     },
    { 0x04ba, "_vsnwprintf_s"                                                                                                     },
    { 0x04bb, "_vsnwprintf_s_l"                                                                                                   },
    { 0x04bc, "_vsprintf_l"                                                                                                       },
    { 0x04bd, "_vsprintf_p"                                                                                                       },
    { 0x04be, "_vsprintf_p_l"                                                                                                     },
    { 0x04bf, "_vsprintf_s_l"                                                                                                     },
    { 0x04c0, "_vswprintf"                                                                                                        },
    { 0x04c1, "_vswprintf_c"                                                                                                      },
    { 0x04c2, "_vswprintf_c_l"                                                                                                    },
    { 0x04c3, "_vswprintf_l"                                                                                                      },
    { 0x04c4, "_vswprintf_p"                                                                                                      },
    { 0x04c5, "_vswprintf_p_l"                                                                                                    },
    { 0x04c6, "_vswprintf_s_l"                                                                                                    },
    { 0x04c7, "_vwprintf_l"                                                                                                       },
    { 0x04c8, "_vwprintf_p"                                                                                                       },
    { 0x04c9, "_vwprintf_p_l"                                                                                                     },
    { 0x04ca, "_vwprintf_s_l"                                                                                                     },
    { 0x04cb, "_waccess"                                                                                                          },
    { 0x04cc, "_waccess_s"                                                                                                        },
    { 0x04cd, "_wasctime"                                                                                                         },
    { 0x04ce, "_wasctime_s"                                                                                                       },
    { 0x04cf, "_wassert"                                                                                                          },
    { 0x04d0, "_wchdir"                                                                                                           },
    { 0x04d1, "_wchmod"                                                                                                           },
    { 0x04d2, "_wcmdln"                                                                                                           },
    { 0x04d3, "_wcreat"                                                                                                           },
    { 0x04d4, "_wcscoll_l"                                                                                                        },
    { 0x04d5, "_wcsdup"                                                                                                           },
    { 0x04d6, "_wcserror"                                                                                                         },
    { 0x04d7, "_wcserror_s"                                                                                                       },
    { 0x04d8, "_wcsftime_l"                                                                                                       },
    { 0x04d9, "_wcsicmp"                                                                                                          },
    { 0x04da, "_wcsicmp_l"                                                                                                        },
    { 0x04db, "_wcsicoll"                                                                                                         },
    { 0x04dc, "_wcsicoll_l"                                                                                                       },
    { 0x04dd, "_wcslwr"                                                                                                           },
    { 0x04de, "_wcslwr_l"                                                                                                         },
    { 0x04df, "_wcslwr_s"                                                                                                         },
    { 0x04e0, "_wcslwr_s_l"                                                                                                       },
    { 0x04e1, "_wcsncoll"                                                                                                         },
    { 0x04e2, "_wcsncoll_l"                                                                                                       },
    { 0x04e3, "_wcsnicmp"                                                                                                         },
    { 0x04e4, "_wcsnicmp_l"                                                                                                       },
    { 0x04e5, "_wcsnicoll"                                                                                                        },
    { 0x04e6, "_wcsnicoll_l"                                                                                                      },
    { 0x04e7, "_wcsnset"                                                                                                          },
    { 0x04e8, "_wcsnset_s"                                                                                                        },
    { 0x04e9, "_wcsrev"                                                                                                           },
    { 0x04ea, "_wcsset"                                                                                                           },
    { 0x04eb, "_wcsset_s"                                                                                                         },
    { 0x04ec, "_wcstod_l"                                                                                                         },
    { 0x04ed, "_wcstoi64"                                                                                                         },
    { 0x04ee, "_wcstoi64_l"                                                                                                       },
    { 0x04ef, "_wcstol_l"                                                                                                         },
    { 0x04f0, "_wcstombs_l"                                                                                                       },
    { 0x04f1, "_wcstombs_s_l"                                                                                                     },
    { 0x04f2, "_wcstoui64"                                                                                                        },
    { 0x04f3, "_wcstoui64_l"                                                                                                      },
    { 0x04f4, "_wcstoul_l"                                                                                                        },
    { 0x04f5, "_wcsupr"                                                                                                           },
    { 0x04f6, "_wcsupr_l"                                                                                                         },
    { 0x04f7, "_wcsupr_s"                                                                                                         },
    { 0x04f8, "_wcsupr_s_l"                                                                                                       },
    { 0x04f9, "_wcsxfrm_l"                                                                                                        },
    { 0x04fa, "_wctime32"                                                                                                         },
    { 0x04fb, "_wctime32_s"                                                                                                       },
    { 0x04fc, "_wctime64"                                                                                                         },
    { 0x04fd, "_wctime64_s"                                                                                                       },
    { 0x04fe, "_wctomb_l"                                                                                                         },
    { 0x04ff, "_wctomb_s_l"                                                                                                       },
    { 0x0500, "_wctype"                                                                                                           },
    { 0x0501, "_wdupenv_s"                                                                                                        },
    { 0x0502, "_wenviron"                                                                                                         },
    { 0x0503, "_wexecl"                                                                                                           },
    { 0x0504, "_wexecle"                                                                                                          },
    { 0x0505, "_wexeclp"                                                                                                          },
    { 0x0506, "_wexeclpe"                                                                                                         },
    { 0x0507, "_wexecv"                                                                                                           },
    { 0x0508, "_wexecve"                                                                                                          },
    { 0x0509, "_wexecvp"                                                                                                          },
    { 0x050a, "_wexecvpe"                                                                                                         },
    { 0x050b, "_wfdopen"                                                                                                          },
    { 0x050c, "_wfindfirst32"                                                                                                     },
    { 0x050d, "_wfindfirst32i64"                                                                                                  },
    { 0x050e, "_wfindfirst64"                                                                                                     },
    { 0x050f, "_wfindfirst64i32"                                                                                                  },
    { 0x0510, "_wfindnext32"                                                                                                      },
    { 0x0511, "_wfindnext32i64"                                                                                                   },
    { 0x0512, "_wfindnext64"                                                                                                      },
    { 0x0513, "_wfindnext64i32"                                                                                                   },
    { 0x0514, "_wfopen"                                                                                                           },
    { 0x0515, "_wfopen_s"                                                                                                         },
    { 0x0516, "_wfreopen"                                                                                                         },
    { 0x0517, "_wfreopen_s"                                                                                                       },
    { 0x0518, "_wfsopen"                                                                                                          },
    { 0x0519, "_wfullpath"                                                                                                        },
    { 0x051a, "_wgetcwd"                                                                                                          },
    { 0x051b, "_wgetdcwd"                                                                                                         },
    { 0x051c, "_wgetdcwd_nolock"                                                                                                  },
    { 0x051d, "_wgetenv"                                                                                                          },
    { 0x051e, "_wgetenv_s"                                                                                                        },
    { 0x051f, "_wmakepath"                                                                                                        },
    { 0x0520, "_wmakepath_s"                                                                                                      },
    { 0x0521, "_wmkdir"                                                                                                           },
    { 0x0522, "_wmktemp"                                                                                                          },
    { 0x0523, "_wmktemp_s"                                                                                                        },
    { 0x0524, "_wopen"                                                                                                            },
    { 0x0525, "_wperror"                                                                                                          },
    { 0x0526, "_wpgmptr"                                                                                                          },
    { 0x0527, "_wpopen"                                                                                                           },
    { 0x0528, "_wprintf_l"                                                                                                        },
    { 0x0529, "_wprintf_p"                                                                                                        },
    { 0x052a, "_wprintf_p_l"                                                                                                      },
    { 0x052b, "_wprintf_s_l"                                                                                                      },
    { 0x052c, "_wputenv"                                                                                                          },
    { 0x052d, "_wputenv_s"                                                                                                        },
    { 0x052e, "_wremove"                                                                                                          },
    { 0x052f, "_wrename"                                                                                                          },
    { 0x0530, "_write"                                                                                                            },
    { 0x0531, "_wrmdir"                                                                                                           },
    { 0x0532, "_wscanf_l"                                                                                                         },
    { 0x0533, "_wscanf_s_l"                                                                                                       },
    { 0x0534, "_wsearchenv"                                                                                                       },
    { 0x0535, "_wsearchenv_s"                                                                                                     },
    { 0x0536, "_wsetlocale"                                                                                                       },
    { 0x0537, "_wsopen"                                                                                                           },
    { 0x0538, "_wsopen_s"                                                                                                         },
    { 0x0539, "_wspawnl"                                                                                                          },
    { 0x053a, "_wspawnle"                                                                                                         },
    { 0x053b, "_wspawnlp"                                                                                                         },
    { 0x053c, "_wspawnlpe"                                                                                                        },
    { 0x053d, "_wspawnv"                                                                                                          },
    { 0x053e, "_wspawnve"                                                                                                         },
    { 0x053f, "_wspawnvp"                                                                                                         },
    { 0x0540, "_wspawnvpe"                                                                                                        },
    { 0x0541, "_wsplitpath"                                                                                                       },
    { 0x0542, "_wsplitpath_s"                                                                                                     },
    { 0x0543, "_wstat32"                                                                                                          },
    { 0x0544, "_wstat32i64"                                                                                                       },
    { 0x0545, "_wstat64"                                                                                                          },
    { 0x0546, "_wstat64i32"                                                                                                       },
    { 0x0547, "_wstrdate"                                                                                                         },
    { 0x0548, "_wstrdate_s"                                                                                                       },
    { 0x0549, "_wstrtime"                                                                                                         },
    { 0x054a, "_wstrtime_s"                                                                                                       },
    { 0x054b, "_wsystem"                                                                                                          },
    { 0x054c, "_wtempnam"                                                                                                         },
    { 0x054d, "_wtmpnam"                                                                                                          },
    { 0x054e, "_wtmpnam_s"                                                                                                        },
    { 0x054f, "_wtof"                                                                                                             },
    { 0x0550, "_wtof_l"                                                                                                           },
    { 0x0551, "_wtoi"                                                                                                             },
    { 0x0552, "_wtoi64"                                                                                                           },
    { 0x0553, "_wtoi64_l"                                                                                                         },
    { 0x0554, "_wtoi_l"                                                                                                           },
    { 0x0555, "_wtol"                                                                                                             },
    { 0x0556, "_wtol_l"                                                                                                           },
    { 0x0557, "_wunlink"                                                                                                          },
    { 0x0558, "_wutime32"                                                                                                         },
    { 0x0559, "_wutime64"                                                                                                         },
    { 0x055a, "_y0"                                                                                                               },
    { 0x055b, "_y1"                                                                                                               },
    { 0x055c, "_yn"                                                                                                               },
    { 0x055d, "abort"                                                                                                             },
    { 0x055e, "abs"                                                                                                               },
    { 0x055f, "acos"                                                                                                              },
    { 0x0560, "asctime"                                                                                                           },
    { 0x0561, "asctime_s"                                                                                                         },
    { 0x0562, "asin"                                                                                                              },
    { 0x0563, "atan"                                                                                                              },
    { 0x0564, "atan2"                                                                                                             },
    { 0x0565, "atexit"                                                                                                            },
    { 0x0566, "atof"                                                                                                              },
    { 0x0567, "atoi"                                                                                                              },
    { 0x0568, "atol"                                                                                                              },
    { 0x0569, "bsearch"                                                                                                           },
    { 0x056a, "bsearch_s"                                                                                                         },
    { 0x056b, "btowc"                                                                                                             },
    { 0x056c, "calloc"                                                                                                            },
    { 0x056d, "ceil"                                                                                                              },
    { 0x056e, "clearerr"                                                                                                          },
    { 0x056f, "clearerr_s"                                                                                                        },
    { 0x0570, "clock"                                                                                                             },
    { 0x0571, "cos"                                                                                                               },
    { 0x0572, "cosh"                                                                                                              },
    { 0x0573, "div"                                                                                                               },
    { 0x0574, "exit"                                                                                                              },
    { 0x0575, "exp"                                                                                                               },
    { 0x0576, "fabs"                                                                                                              },
    { 0x0577, "fclose"                                                                                                            },
    { 0x0578, "feof"                                                                                                              },
    { 0x0579, "ferror"                                                                                                            },
    { 0x057a, "fflush"                                                                                                            },
    { 0x057b, "fgetc"                                                                                                             },
    { 0x057c, "fgetpos"                                                                                                           },
    { 0x057d, "fgets"                                                                                                             },
    { 0x057e, "fgetwc"                                                                                                            },
    { 0x057f, "fgetws"                                                                                                            },
    { 0x0580, "floor"                                                                                                             },
    { 0x0581, "fmod"                                                                                                              },
    { 0x0582, "fopen"                                                                                                             },
    { 0x0583, "fopen_s"                                                                                                           },
    { 0x0584, "fprintf"                                                                                                           },
    { 0x0585, "fprintf_s"                                                                                                         },
    { 0x0586, "fputc"                                                                                                             },
    { 0x0587, "fputs"                                                                                                             },
    { 0x0588, "fputwc"                                                                                                            },
    { 0x0589, "fputws"                                                                                                            },
    { 0x058a, "fread"                                                                                                             },
    { 0x058b, "fread_s"                                                                                                           },
    { 0x058c, "free"                                                                                                              },
    { 0x058d, "freopen"                                                                                                           },
    { 0x058e, "freopen_s"                                                                                                         },
    { 0x058f, "frexp"                                                                                                             },
    { 0x0590, "fscanf"                                                                                                            },
    { 0x0591, "fscanf_s"                                                                                                          },
    { 0x0592, "fseek"                                                                                                             },
    { 0x0593, "fsetpos"                                                                                                           },
    { 0x0594, "ftell"                                                                                                             },
    { 0x0595, "fwprintf"                                                                                                          },
    { 0x0596, "fwprintf_s"                                                                                                        },
    { 0x0597, "fwrite"                                                                                                            },
    { 0x0598, "fwscanf"                                                                                                           },
    { 0x0599, "fwscanf_s"                                                                                                         },
    { 0x059a, "getc"                                                                                                              },
    { 0x059b, "getchar"                                                                                                           },
    { 0x059c, "getenv"                                                                                                            },
    { 0x059d, "getenv_s"                                                                                                          },
    { 0x059e, "gets"                                                                                                              },
    { 0x059f, "gets_s"                                                                                                            },
    { 0x05a0, "getwc"                                                                                                             },
    { 0x05a1, "getwchar"                                                                                                          },
    { 0x05a2, "is_wctype"                                                                                                         },
    { 0x05a3, "isalnum"                                                                                                           },
    { 0x05a4, "isalpha"                                                                                                           },
    { 0x05a5, "iscntrl"                                                                                                           },
    { 0x05a6, "isdigit"                                                                                                           },
    { 0x05a7, "isgraph"                                                                                                           },
    { 0x05a8, "isleadbyte"                                                                                                        },
    { 0x05a9, "islower"                                                                                                           },
    { 0x05aa, "isprint"                                                                                                           },
    { 0x05ab, "ispunct"                                                                                                           },
    { 0x05ac, "isspace"                                                                                                           },
    { 0x05ad, "isupper"                                                                                                           },
    { 0x05ae, "iswalnum"                                                                                                          },
    { 0x05af, "iswalpha"                                                                                                          },
    { 0x05b0, "iswascii"                                                                                                          },
    { 0x05b1, "iswcntrl"                                                                                                          },
    { 0x05b2, "iswctype"                                                                                                          },
    { 0x05b3, "iswdigit"                                                                                                          },
    { 0x05b4, "iswgraph"                                                                                                          },
    { 0x05b5, "iswlower"                                                                                                          },
    { 0x05b6, "iswprint"                                                                                                          },
    { 0x05b7, "iswpunct"                                                                                                          },
    { 0x05b8, "iswspace"                                                                                                          },
    { 0x05b9, "iswupper"                                                                                                          },
    { 0x05ba, "iswxdigit"                                                                                                         },
    { 0x05bb, "isxdigit"                                                                                                          },
    { 0x05bc, "labs"                                                                                                              },
    { 0x05bd, "ldexp"                                                                                                             },
    { 0x05be, "ldiv"                                                                                                              },
    { 0x05bf, "llabs"                                                                                                             },
    { 0x05c0, "lldiv"                                                                                                             },
    { 0x05c1, "localeconv"                                                                                                        },
    { 0x05c2, "log"                                                                                                               },
    { 0x05c3, "log10"                                                                                                             },
    { 0x05c4, "longjmp"                                                                                                           },
    { 0x05c5, "malloc"                                                                                                            },
    { 0x05c6, "mblen"                                                                                                             },
    { 0x05c7, "mbrlen"                                                                                                            },
    { 0x05c8, "mbrtowc"                                                                                                           },
    { 0x05c9, "mbsrtowcs"                                                                                                         },
    { 0x05ca, "mbsrtowcs_s"                                                                                                       },
    { 0x05cb, "mbstowcs"                                                                                                          },
    { 0x05cc, "mbstowcs_s"                                                                                                        },
    { 0x05cd, "mbtowc"                                                                                                            },
    { 0x05ce, "memchr"                                                                                                            },
    { 0x05cf, "memcmp"                                                                                                            },
    { 0x05d0, "memcpy"                                                                                                            },
    { 0x05d1, "memcpy_s"                                                                                                          },
    { 0x05d2, "memmove"                                                                                                           },
    { 0x05d3, "memmove_s"                                                                                                         },
    { 0x05d4, "memset"                                                                                                            },
    { 0x05d5, "modf"                                                                                                              },
    { 0x05d6, "perror"                                                                                                            },
    { 0x05d7, "pow"                                                                                                               },
    { 0x05d8, "printf"                                                                                                            },
    { 0x05d9, "printf_s"                                                                                                          },
    { 0x05da, "putc"                                                                                                              },
    { 0x05db, "putchar"                                                                                                           },
    { 0x05dc, "puts"                                                                                                              },
    { 0x05dd, "putwc"                                                                                                             },
    { 0x05de, "putwchar"                                                                                                          },
    { 0x05df, "qsort"                                                                                                             },
    { 0x05e0, "qsort_s"                                                                                                           },
    { 0x05e1, "raise"                                                                                                             },
    { 0x05e2, "rand"                                                                                                              },
    { 0x05e3, "rand_s"                                                                                                            },
    { 0x05e4, "realloc"                                                                                                           },
    { 0x05e5, "remove"                                                                                                            },
    { 0x05e6, "rename"                                                                                                            },
    { 0x05e7, "rewind"                                                                                                            },
    { 0x05e8, "scanf"                                                                                                             },
    { 0x05e9, "scanf_s"                                                                                                           },
    { 0x05ea, "setbuf"                                                                                                            },
    { 0x05eb, "setlocale"                                                                                                         },
    { 0x05ec, "setvbuf"                                                                                                           },
    { 0x05ed, "signal"                                                                                                            },
    { 0x05ee, "sin"                                                                                                               },
    { 0x05ef, "sinh"                                                                                                              },
    { 0x05f0, "sprintf"                                                                                                           },
    { 0x05f1, "sprintf_s"                                                                                                         },
    { 0x05f2, "sqrt"                                                                                                              },
    { 0x05f3, "srand"                                                                                                             },
    { 0x05f4, "sscanf"                                                                                                            },
    { 0x05f5, "sscanf_s"                                                                                                          },
    { 0x05f6, "strcat"                                                                                                            },
    { 0x05f7, "strcat_s"                                                                                                          },
    { 0x05f8, "strchr"                                                                                                            },
    { 0x05f9, "strcmp"                                                                                                            },
    { 0x05fa, "strcoll"                                                                                                           },
    { 0x05fb, "strcpy"                                                                                                            },
    { 0x05fc, "strcpy_s"                                                                                                          },
    { 0x05fd, "strcspn"                                                                                                           },
    { 0x05fe, "strerror"                                                                                                          },
    { 0x05ff, "strerror_s"                                                                                                        },
    { 0x0600, "strftime"                                                                                                          },
    { 0x0601, "strlen"                                                                                                            },
    { 0x0602, "strncat"                                                                                                           },
    { 0x0603, "strncat_s"                                                                                                         },
    { 0x0604, "strncmp"                                                                                                           },
    { 0x0605, "strncpy"                                                                                                           },
    { 0x0606, "strncpy_s"                                                                                                         },
    { 0x0607, "strnlen"                                                                                                           },
    { 0x0608, "strpbrk"                                                                                                           },
    { 0x0609, "strrchr"                                                                                                           },
    { 0x060a, "strspn"                                                                                                            },
    { 0x060b, "strstr"                                                                                                            },
    { 0x060c, "strtod"                                                                                                            },
    { 0x060d, "strtok"                                                                                                            },
    { 0x060e, "strtok_s"                                                                                                          },
    { 0x060f, "strtol"                                                                                                            },
    { 0x0610, "strtoul"                                                                                                           },
    { 0x0611, "strxfrm"                                                                                                           },
    { 0x0612, "swprintf_s"                                                                                                        },
    { 0x0613, "swscanf"                                                                                                           },
    { 0x0614, "swscanf_s"                                                                                                         },
    { 0x0615, "system"                                                                                                            },
    { 0x0616, "tan"                                                                                                               },
    { 0x0617, "tanh"                                                                                                              },
    { 0x0618, "tmpfile"                                                                                                           },
    { 0x0619, "tmpfile_s"                                                                                                         },
    { 0x061a, "tmpnam"                                                                                                            },
    { 0x061b, "tmpnam_s"                                                                                                          },
    { 0x061c, "tolower"                                                                                                           },
    { 0x061d, "toupper"                                                                                                           },
    { 0x061e, "towlower"                                                                                                          },
    { 0x061f, "towupper"                                                                                                          },
    { 0x0620, "ungetc"                                                                                                            },
    { 0x0621, "ungetwc"                                                                                                           },
    { 0x0622, "vfprintf"                                                                                                          },
    { 0x0623, "vfprintf_s"                                                                                                        },
    { 0x0624, "vfwprintf"                                                                                                         },
    { 0x0625, "vfwprintf_s"                                                                                                       },
    { 0x0626, "vprintf"                                                                                                           },
    { 0x0627, "vprintf_s"                                                                                                         },
    { 0x0628, "vsprintf"                                                                                                          },
    { 0x0629, "vsprintf_s"                                                                                                        },
    { 0x062a, "vswprintf_s"                                                                                                       },
    { 0x062b, "vwprintf"                                                                                                          },
    { 0x062c, "vwprintf_s"                                                                                                        },
    { 0x062d, "wcrtomb"                                                                                                           },
    { 0x062e, "wcrtomb_s"                                                                                                         },
    { 0x062f, "wcscat"                                                                                                            },
    { 0x0630, "wcscat_s"                                                                                                          },
    { 0x0631, "wcschr"                                                                                                            },
    { 0x0632, "wcscmp"                                                                                                            },
    { 0x0633, "wcscoll"                                                                                                           },
    { 0x0634, "wcscpy"                                                                                                            },
    { 0x0635, "wcscpy_s"                                                                                                          },
    { 0x0636, "wcscspn"                                                                                                           },
    { 0x0637, "wcsftime"                                                                                                          },
    { 0x0638, "wcslen"                                                                                                            },
    { 0x0639, "wcsncat"                                                                                                           },
    { 0x063a, "wcsncat_s"                                                                                                         },
    { 0x063b, "wcsncmp"                                                                                                           },
    { 0x063c, "wcsncpy"                                                                                                           },
    { 0x063d, "wcsncpy_s"                                                                                                         },
    { 0x063e, "wcsnlen"                                                                                                           },
    { 0x063f, "wcspbrk"                                                                                                           },
    { 0x0640, "wcsrchr"                                                                                                           },
    { 0x0641, "wcsrtombs"                                                                                                         },
    { 0x0642, "wcsrtombs_s"                                                                                                       },
    { 0x0643, "wcsspn"                                                                                                            },
    { 0x0644, "wcsstr"                                                                                                            },
    { 0x0645, "wcstod"                                                                                                            },
    { 0x0646, "wcstok"                                                                                                            },
    { 0x0647, "wcstok_s"                                                                                                          },
    { 0x0648, "wcstol"                                                                                                            },
    { 0x0649, "wcstombs"                                                                                                          },
    { 0x064a, "wcstombs_s"                                                                                                        },
    { 0x064b, "wcstoul"                                                                                                           },
    { 0x064c, "wcsxfrm"                                                                                                           },
    { 0x064d, "wctob"                                                                                                             },
    { 0x064e, "wctomb"                                                                                                            },
    { 0x064f, "wctomb_s"                                                                                                          },
    { 0x0650, "wmemcpy_s"                                                                                                         },
    { 0x0651, "wmemmove_s"                                                                                                        },
    { 0x0652, "wprintf"                                                                                                           },
    { 0x0653, "wprintf_s"                                                                                                         },
    { 0x0654, "wscanf"                                                                                                            },
    { 0x0655, "wscanf_s"                                                                                                          },
};


}
}

#endif

