
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file DateAxisMethodAttributes.h
    \\brief Definition of DateAxisMethod Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "DateAxisMethodWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


DateAxisMethodWrapper::DateAxisMethodWrapper(): dateaxismethod_(new DateAxisMethod())

{

	
	
	AxisMethodWrapper::object(dateaxismethod_);
	
	
} 
DateAxisMethodWrapper::DateAxisMethodWrapper(DateAxisMethod* dateaxismethod): dateaxismethod_(dateaxismethod)
{
	
	
	AxisMethodWrapper::object(dateaxismethod_);
	
} 

DateAxisMethodWrapper::~DateAxisMethodWrapper()
{
	
}

void DateAxisMethodWrapper::set(const MagRequest& request)
{
	
	
	
	AxisMethodWrapper::set(request);
	

	if  (request.countValues("AXIS_DATE_TYPE") ) {
		string method_value = request("AXIS_DATE_TYPE");
		dateaxismethod_->method_ = method_value;
		}
	if  (request.countValues("AXIS_YEARS_LABEL") ) {
		string years_value = request("AXIS_YEARS_LABEL");
		dateaxismethod_->years_ = MagTranslator<string, bool>()(years_value);
		}
	if  (request.countValues("AXIS_YEARS_LABEL_FONT") ) {
		string year_font_value = request("AXIS_YEARS_LABEL_FONT");
		dateaxismethod_->year_font_ = year_font_value;
		}
	if  (request.countValues("AXIS_YEARS_LABEL_FONT_STYLE") ) {
		string year_font_style_value = request("AXIS_YEARS_LABEL_FONT_STYLE");
		dateaxismethod_->year_font_style_ = year_font_style_value;
		}
	if  (request.countValues("AXIS_YEARS_LABEL_HEIGHT") ) {
		double year_height_value = request("AXIS_YEARS_LABEL_HEIGHT");
		dateaxismethod_->year_height_ = year_height_value;
		}
	if  (request.countValues("AXIS_MONTHS_LABEL") ) {
		string months_value = request("AXIS_MONTHS_LABEL");
		dateaxismethod_->months_ = MagTranslator<string, bool>()(months_value);
		}
	if  (request.countValues("AXIS_MONTHS_LABEL_COMPOSITION") ) {
		string month_composition_value = request("AXIS_MONTHS_LABEL_COMPOSITION");
		dateaxismethod_->month_composition_ = month_composition_value;
		}
	if  (request.countValues("AXIS_MONTHS_LABEL_FONT") ) {
		string month_font_value = request("AXIS_MONTHS_LABEL_FONT");
		dateaxismethod_->month_font_ = month_font_value;
		}
	if  (request.countValues("AXIS_MONTHS_LABEL_FONT_STYLE") ) {
		string month_font_style_value = request("AXIS_MONTHS_LABEL_FONT_STYLE");
		dateaxismethod_->month_font_style_ = month_font_style_value;
		}
	if  (request.countValues("AXIS_MONTHS_LABEL_HEIGHT") ) {
		double month_height_value = request("AXIS_MONTHS_LABEL_HEIGHT");
		dateaxismethod_->month_height_ = month_height_value;
		}
	if  (request.countValues("AXIS_DAYS_LABEL") ) {
		string days_value = request("AXIS_DAYS_LABEL");
		dateaxismethod_->days_ = days_value;
		}
	if  (request.countValues("AXIS_DAYS_LABEL_COMPOSITION") ) {
		string day_composition_value = request("AXIS_DAYS_LABEL_COMPOSITION");
		dateaxismethod_->day_composition_ = day_composition_value;
		}
	if  (request.countValues("AXIS_DAYS_LABEL_POSITION") ) {
		int day_position_value = request("AXIS_DAYS_LABEL_POSITION");
		dateaxismethod_->day_position_ = day_position_value;
		}
	if  (request.countValues("AXIS_DAYS_LABEL_FONT") ) {
		string day_font_value = request("AXIS_DAYS_LABEL_FONT");
		dateaxismethod_->day_font_ = day_font_value;
		}
	if  (request.countValues("AXIS_DAYS_LABEL_FONT_STYLE") ) {
		string day_font_style_value = request("AXIS_DAYS_LABEL_FONT_STYLE");
		dateaxismethod_->day_font_style_ = day_font_style_value;
		}
	if  (request.countValues("AXIS_DAYS_LABEL_HEIGHT") ) {
		double day_height_value = request("AXIS_DAYS_LABEL_HEIGHT");
		dateaxismethod_->day_height_ = day_height_value;
		}
	if  (request.countValues("AXIS_HOURS_LABEL") ) {
		string hours_value = request("AXIS_HOURS_LABEL");
		dateaxismethod_->hours_ = MagTranslator<string, bool>()(hours_value);
		}
	if  (request.countValues("AXIS_HOURS_LABEL_FONT") ) {
		string hour_font_value = request("AXIS_HOURS_LABEL_FONT");
		dateaxismethod_->hour_font_ = hour_font_value;
		}
	if  (request.countValues("AXIS_HOURS_LABEL_FONT_STYLE") ) {
		string hour_font_style_value = request("AXIS_HOURS_LABEL_FONT_STYLE");
		dateaxismethod_->hour_font_style_ = hour_font_style_value;
		}
	if  (request.countValues("AXIS_HOURS_LABEL_HEIGHT") ) {
		double hour_height_value = request("AXIS_HOURS_LABEL_HEIGHT");
		dateaxismethod_->hour_height_ = hour_height_value;
		}
	
	if  (request.countValues("AXIS_YEARS_LABEL_COLOUR") ) {
		string year_colour_value = request("AXIS_YEARS_LABEL_COLOUR");
		dateaxismethod_->year_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(year_colour_value));
	}
		
	if  (request.countValues("AXIS_MONTHS_LABEL_COLOUR") ) {
		string month_colour_value = request("AXIS_MONTHS_LABEL_COLOUR");
		dateaxismethod_->month_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(month_colour_value));
	}
		
	if  (request.countValues("AXIS_DAYS_LABEL_COLOUR") ) {
		string day_colour_value = request("AXIS_DAYS_LABEL_COLOUR");
		dateaxismethod_->day_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(day_colour_value));
	}
		
	if  (request.countValues("AXIS_DAYS_SUNDAY_LABEL_COLOUR") ) {
		string sunday_colour_value = request("AXIS_DAYS_SUNDAY_LABEL_COLOUR");
		dateaxismethod_->sunday_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(sunday_colour_value));
	}
		
	if  (request.countValues("AXIS_HOURS_LABEL_COLOUR") ) {
		string hour_colour_value = request("AXIS_HOURS_LABEL_COLOUR");
		dateaxismethod_->hour_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(hour_colour_value));
	}
		
	
}

void DateAxisMethodWrapper::print(ostream& out)  const
{
	out << "DateAxisMethodWrapper[]";
}


    








