/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.turbine.util.Log;
import org.chefproject.core.UsageSession;
import org.chefproject.core.User;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.service.UserDirectoryService;
import org.chefproject.service.component.BaseUsageSessionService;
import org.chefproject.util.Sql;
import org.chefproject.util.SqlReader;
import org.chefproject.util.Time;

public class ClusterUsageSessionService
extends BaseUsageSessionService {
    protected BaseUsageSessionService.Storage newStorage() {
        return new ClusterStorage();
    }

    protected class ClusterStorage
    implements BaseUsageSessionService.Storage {
        protected Map m_sessions = null;

        protected ClusterStorage() {
        }

        public void open() {
            this.m_sessions = new Hashtable();
        }

        public void close() {
            Vector sessions = new Vector();
            sessions.addAll(this.m_sessions.values());
            Iterator it = sessions.iterator();
            while (it.hasNext()) {
                BaseUsageSessionService.BaseUsageSession session = (BaseUsageSessionService.BaseUsageSession)it.next();
                session.close();
            }
            if (!this.m_sessions.isEmpty()) {
                Log.warn("chef", this + ".close(): sessions remain");
            }
            this.m_sessions.clear();
            this.m_sessions = null;
        }

        public void addSession(UsageSession session) {
            this.m_sessions.put(session.getId(), session);
            String statement = "insert into CHEF_SESSION (SESSION_ID,SESSION_USER,SESSION_IP,SESSION_USER_AGENT,SESSION_START,SESSION_END) values (?, ?, ?, ?, ?, ?)";
            Object[] fields = new Object[]{session.getId(), session.getUser().getId(), session.getIpAddress(), session.getUserAgent(), session.getStart(), session.getEnd()};
            boolean ok = Sql.dbWrite(statement, fields);
            if (!ok) {
                Log.warn("chef", this + ".addSession(): dbWrite failed");
            }
        }

        public UsageSession getSession(String id) {
            UsageSession rv = (UsageSession)this.m_sessions.get(id);
            if (rv == null) {
                String statement = "select * from CHEF_SESSION where SESSION_ID = ?";
                Object[] fields = new Object[]{id};
                List sessions = Sql.dbRead(statement, fields, new SqlReader(this){
                    private final /* synthetic */ ClusterStorage this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object readSqlResultRecord(ResultSet result) {
                        try {
                            String id = result.getString(1);
                            String userId = result.getString(2);
                            User user = null;
                            try {
                                user = UserDirectoryService.getUser(userId);
                            }
                            catch (IdUnusedException e) {
                                user = UserDirectoryService.getAnonymousUser();
                            }
                            String ip = result.getString(3);
                            String agent = result.getString(4);
                            Time start = new Time(result.getTimestamp(5, (Calendar)Sql.M_cal).getTime());
                            Time end = new Time(result.getTimestamp(6, (Calendar)Sql.M_cal).getTime());
                            BaseUsageSessionService.BaseUsageSession session = ClusterStorage.access$000(this.this$1).new BaseUsageSessionService.BaseUsageSession(id, user, ip, agent, start, end);
                            return session;
                        }
                        catch (SQLException ignore) {
                            return null;
                        }
                    }
                });
                if (!sessions.isEmpty()) {
                    rv = (UsageSession)sessions.get(0);
                }
            }
            return rv;
        }

        public UsageSession getLocalSession(String id) {
            UsageSession rv = (UsageSession)this.m_sessions.get(id);
            return rv;
        }

        public void closeSession(UsageSession session) {
            if (this.m_sessions.get(session.getId()) == null) {
                return;
            }
            this.m_sessions.remove(session.getId());
            String statement = "update CHEF_SESSION set SESSION_END = ? where SESSION_ID = ?";
            Object[] fields = new Object[]{session.getEnd(), session.getId()};
            boolean ok = Sql.dbWrite(statement, fields);
            if (!ok) {
                Log.warn("chef", this + ".closeSession(): dbWrite failed");
            }
        }

        static /* synthetic */ ClusterUsageSessionService access$000(ClusterStorage x0) {
            return x0.ClusterUsageSessionService.this;
        }
    }
}

