#include <stdio.h>
#include <string.h>
#include "channels.h"

static struct tv_channels {
	const char	*channel;
	double		video_mhz;
	double		audio_mhz;
} tv_channels[] = {
	{ "1",		41.25,	46.75	},
	{ "2",		48.25,	53.75	},
	{ "3",		55.25,	60.75	},
	{ "4",		62.25,	67.75	},
	{ "S1",		105.25,	110.75	},
	{ "S2",		112.25,	117.75	},
	{ "S3",		118.25,	123.75	},
	{ "S4",		126.25,	131.75	},
	{ "S5",		133.25,	138.75	},
	{ "S6",		140.25,	148.75	},
	{ "S7",		147.25,	152.75	},
	{ "S8",		154.25,	159.75	},
	{ "S9",		161.25,	166.75	},
	{ "S10",	168.25,	173.75	},
	{ "5",		175.25,	180.75	},
	{ "6",		182.25,	187.75	},
	{ "7",		189.25,	194.75	},
	{ "8",		196.25,	201.75	},
	{ "9",		203.25,	208.75	},
	{ "10",		210.25,	215.75	},
	{ "11",		217.25,	222.75	},
	{ "12",		224.25,	229.75	},
	{ "S11",	231.25,	236.75	},
	{ "S12",	238.25,	243.75	},
	{ "S13",	245.25,	250.75	},
	{ "S14",	252.25,	257.75	},
	{ "S15",	259.25,	264.75	},
	{ "S16",	266.25,	271.75	},
	{ "S17",	273.25,	278.75	},
	{ "S18",	280.25,	285.75	},
	{ "S19",	287.25,	292.75	},
	{ "S20",	294.25,	299.75	},
	{ "S21",	303.25,	308.75	},
	{ "S22",	311.25,	316.75	},
	{ "S23",	319.25,	324.75	},
	{ "S24",	327.25,	332.75	},
	{ "S25",	335.25,	340.75	},
	{ "S26",	343.25,	348.75	},
	{ "S27",	351.25,	356.75	},
	{ "S28",	359.25,	364.75	},
	{ "S29",	367.25,	372.75	},
	{ "S30",	375.25,	380.75	},
	{ "S31",	383.25,	388.75	},
	{ "S32",	391.25,	396.75	},
	{ "S33",	399.25,	404.75	},
	{ "S34",	407.25,	412.75	},
	{ "S35",	415.25,	420.75	},
	{ "S36",	423.25,	428.75	},
	{ "S37",	431.25,	436.75	},
	{ "S38",	439.25,	444.75	},
	{ "S39",	447.25,	452.75	},
	{ "S40",	455.25,	460.75	},
	{ "S41",	463.25,	468.75	},
	{ "21",		471.25,	476.75	},
	{ "22",		479.25,	484.75	},
	{ "23",		487.25,	492.75	},
	{ "24",		495.25,	500.75	},
	{ "25",		503.25,	508.75	},
	{ "26",		511.25,	516.75	},
	{ "27",		519.25,	524.75	},
	{ "28",		527.25,	532.75	},
	{ "29",		535.25,	540.75	},
	{ "30",		543.25,	548.75	},
	{ "31",		551.25,	556.75	},
	{ "32",		559.25,	564.75	},
	{ "33",		567.25,	572.75	},
	{ "34",		575.25,	580.75	},
	{ "35",		583.25,	588.75	},
	{ "36",		591.25,	596.75	},
	{ "37",		599.25,	604.75	},
	{ "38",		607.25,	612.75	},
	{ "39",		615.25,	620.75	},
	{ "40",		623.25,	628.75	},
	{ "41",		631.25,	636.75	},
	{ "42",		639.25,	644.75	},
	{ "43",		647.25,	652.75	},
	{ "44",		655.25,	660.75	},
	{ "45",		663.25,	668.75	},
	{ "46",		671.25,	676.75	},
	{ "47",		679.25,	684.75	},
	{ "48",		687.25,	692.75	},
	{ "49",		695.25,	700.75	},
	{ "50",		703.25,	708.75	},
	{ "51",		711.25,	716.75	},
	{ "52",		719.25,	724.75	},
	{ "53",		727.25,	732.75	},
	{ "54",		735.25,	740.75	},
	{ "55",		743.25,	748.75	},
	{ "56",		751.25,	756.75	},
	{ "57",		759.25,	764.75	},
	{ "58",		767.25,	772.75	},
	{ "59",		775.25,	780.75	},
	{ "60",		783.25,	788.75	},
	{ "61",		791.25,	796.75	},
	{ "62",		799.25,	804.75	},
	{ "63",		807.25,	812.75	},
	{ "64",		815.25,	820.75	},
	{ "65",		823.25,	828.75	},
	{ "66",		831.25,	836.75	},
	{ "67",		839.25,	844.75	},
	{ "68",		847.25,	852.75	},
	{ "69",		855.25,	860.75	},
	{ 0,		0,	0,	}
};

double get_tv_frequency(const char *channel, double *audio_offset)
{
	int i;

	for (i = 0; tv_channels[i].channel; i++) {
		if (!strcasecmp(tv_channels[i].channel, channel)) {
			*audio_offset = (tv_channels[i].audio_mhz - tv_channels[i].video_mhz) * 1e6;
			return tv_channels[i].video_mhz * 1e6;
		}
	}

	return 0.0;
}

void list_tv_channels(void)
{
	int i;

	printf("List of TV channels in MHz:\n\n");
	printf("Channel Video   Audio\n");
	printf("------------------------\n");
	for (i = 0; tv_channels[i].channel; i++) {
		printf("%s\t%.2f\t%.2f\n", tv_channels[i].channel, tv_channels[i].video_mhz, tv_channels[i].audio_mhz);
	}
}
