# 2025-04-29 Triage Log

Strange week with lots of noise peeking through the performance runs. The only really significant change was a performance improvement that comes from allowing out of order encoding of the dep graph.

Triage done by **@rylev**.
Revision range: [8f2819b0..25cdf1f6](https://perf.rust-lang.org/?start=8f2819b0e3428d0aee05fa60e91e0211c2aea053&end=25cdf1f67463c9365d8d83778c933ec7480e940b&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.1%, 3.0%]   | 77    |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.1%, 2.4%]   | 77    |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.3%, -0.2%] | 106   |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.2%, -0.2%] | 29    |
| All ❌✅ (primary)                 | -0.2% | [-1.3%, 3.0%]  | 183   |


4 Regressions, 2 Improvements, 4 Mixed; 2 of them in rollups
38 artifact comparisons made in total

#### Regressions

Refactor git change detection in bootstrap [#138591](https://github.com/rust-lang/rust/pull/138591) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1a5bf12f6586d724ed5ff40e58e06c0233560c0e&end=645d0ad2a4f145ae576e442ec5c73c0f8eed829b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.1%, 0.3%]   | 13    |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.6%]   | 42    |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.2%  | [-0.2%, 0.3%]  | 14    |
- Looks like noise.


Properly stall coroutine witnesses in new solver [#138845](https://github.com/rust-lang/rust/pull/138845) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=df35ff6c354f1f1fbf430b84e7dea37dfe997f34&end=fa58ce343ad498196d799a7381869e79938e952a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.1%, 0.4%]   | 25    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.1%, 0.6%]   | 48    |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.2%  | [-0.2%, 0.4%]  | 26    |
- The regressions are small enough that this isn't a huge concern, and the regressions themselves might be due to some underlying perf instability.


Implement a lint for implicit autoref of raw pointer dereference - take 2 [#123239](https://github.com/rust-lang/rust/pull/123239) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0134651fb81314870903e21b1bcbdd993d75b61a&end=a932eb36f8adf6c8cdfc450f063943da3112d621&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.8% | [0.3%, 3.6%] | 6     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.8% | [0.3%, 3.6%] | 6     |
- Perf regression reversed in https://github.com/rust-lang/rust/pull/140406


Async drop codegen [#123948](https://github.com/rust-lang/rust/pull/123948) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a932eb36f8adf6c8cdfc450f063943da3112d621&end=7d65abfe80f9eee93296d1ce08f845c9bf7039f8&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.2%, 0.6%] | 12    |
| Regressions ❌ <br /> (secondary)  | 1.0% | [0.2%, 2.4%] | 28    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.2%, 0.6%] | 12    |
- Ask the author and reviewer whether this is worth pursuing more after their initial perf investigation.


#### Improvements

Remove `token::{Open,Close}Delim` [#139897](https://github.com/rust-lang/rust/pull/139897) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d6c1e454aa8af5e7e59fbf5c4e7d3128d2f99582&end=fae7785b60ea7fe1ad293352c057a5b7be73d245&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.6%, -0.2%] | 14    |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.4% | [-0.6%, -0.2%] | 14    |


Rollup of 8 pull requests [#140165](https://github.com/rust-lang/rust/pull/140165) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6bc57c6bf7d0024ad9ea5a2c112f3fc9c383c8a4&end=1a5bf12f6586d724ed5ff40e58e06c0233560c0e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.1%] | 17    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.6%, -0.2%] | 48    |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, 0.2%]  | 18    |


#### Mixed

Clippy subtree update [#139983](https://github.com/rust-lang/rust/pull/139983) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=553600e0f5f5a7d492de6d95ccb2f057005f5651&end=df35ff6c354f1f1fbf430b84e7dea37dfe997f34&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.1%] | 7     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.6%, -0.2%] | 36    |
| All ❌✅ (primary)                 | -0.1% | [-0.3%, 0.2%]  | 8     |
- The small regression is fine in light of the larger and more numerous improvements.


Rollup of 8 pull requests [#140256](https://github.com/rust-lang/rust/pull/140256) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3c877f6a477380ed61155d3bf816df09c9e05b9e&end=d7ea436a02d5de4033fcf7fd4eb8ed965d0f574c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.6%, -0.2%] | 23    |
| All ❌✅ (primary)                 | 0.2%  | [0.2%, 0.2%]   | 1     |
- The single regression looks to be noise.


set subsections_via_symbols for ld64 helper sections [#139752](https://github.com/rust-lang/rust/pull/139752) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d7ea436a02d5de4033fcf7fd4eb8ed965d0f574c&end=847e3ee6b0e614937eee4e6d8f61094411eadcc0&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.3%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.6%]   | 30    |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.1%  | [-0.2%, 0.3%]  | 3     |
- Not sure where the regressions are coming from since this should only impact macOS.


Allow out of order dep graph node encoding [#139756](https://github.com/rust-lang/rust/pull/139756) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8f43b85954d2f3d8fc00a7504c603e5ca9eb0695&end=e3e432d4d65a55e6db167598e96db2bcb163e316&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.3%]   | 7     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.2%, 0.6%]   | 15    |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.3%, -0.3%] | 115   |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.4%, -0.2%] | 27    |
| All ❌✅ (primary)                 | -0.7% | [-1.3%, 0.3%]  | 122   |
- Perf improvements massively outweigh the regressions.

