tikzquests
==========

A parametric questions' repository.

For more details,  see the documentation,
[tikzquests.pdf](http://mirrors.ctan.org/macros/latex/contrib/tikzquests/doc/tikzquests.pdf)

--------------

## Requirements
* none besides a fairly recent LaTeX distribution as recent as 2022/06/01
(with the new in kernel *\ProcessKeyOptions* and *\NewDocumentCommand*)

## Installation
The stable version is available at [CTAN](https://ctan.org/pkg/tikzquests).

## Usage
### Stable version
Just place
```latex
  \usepackage{tikzquests}
```

in the preamble and compile away.


Be aware that options might change between versions, so you have to check them manually.


## Contacting Author

For bug reports and enhancement suggestions, the preferred way is to use
[the project's issue page](https://github.com/alceu-frigeri/tikzquests/issues).
Please be ready to provide an example code showing the bug, if any.

Please do not use the issue page for generic help on how to use the package.

* git: https://github.com/alceu-frigeri/tikzquests

-------------
Copyright 2024-present by Alceu Frigeri

 This work may be distributed and/or modified under the
 conditions of

 * The [LaTeX Project Public License](http://www.latex-project.org/lppl.txt), version 1.3c (or later), and/or
 * The [GNU Affero General Public License](https://www.gnu.org/licenses/agpl-3.0.html), version 3 (or later)

This work has the LPPL maintenance status *maintained*.

The Current Maintainer of this work is Alceu Frigeri

-------------
## This work consists of the files

* tikzquests.sty
    - The Package itself

* README.md (this file)
    - quick introduction

* tikzquests.tex
    - package documentation

* tikzquests.pdf
    - documentation in PDF format

-------------
## Change log
* Version 2.3 (this)
    - using ```\pkginfograbProvidesExplPackage```
    - removing all kernel scratch variables references.
    - added 'keys prefix' package option. re-factored keys setting with \seq
    - further code clean up

* Version 2.2/2.2a 
    - switching over pkginfograb package's info
    - new package options allowing to change key's set and  definition strategy (local instead of global).
    - "re-inserting" missing optional parameter in \ftikzQuestion (last one)

* Version 2.1
    - documentation typos
    - some code cleanup
    - removing duplicates before processing key`s ID/idx

* Version 2.0a
    - documentation typos
    - issue [#4](https://github.com/alceu-frigeri/tikzquests/issues/4)
    - code cleanup

* Version 2.0
    - re-factoring: fully re-written as expl3 code (and solving [#3](https://github.com/alceu-frigeri/tikzquests/issues/3))
    - re-factoring: some commands renamed (old ones still accessible, but deprecated)
    - new, more flexible, command for listing questions: \QuestionsFmtList
    - documentation.

* Version 1.4 
    - internals: delaying keys expansion
    - re-factoring: pgfkeys partly re-written as expl3 code.
    - re-factoring: some commands renamed (old ones still accessible, but deprecated)
    - removed (deprecated) "old keys"
    - documentation

* Version 1.3
    - Added an optional parameter to \defQuestionAlias allowing to "copy" questions from one repository into another. see documentation.

* Version 1.2
    - Added the concept of 'sub-repositories' (relevant when listing the questions of a repository). see documentation.

* Version 1.1
    - Documentation typos, and issue [#1](https://github.com/alceu-frigeri/tikzquests/issues/1).

* Version 1.0
    - Initial release by CTAN.
