/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.preferences.projection.AbstractProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.CodeSelectionPanel;
import org.openstreetmap.josm.gui.preferences.projection.SubPrefsOptions;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class CodeProjectionChoice
extends AbstractProjectionChoice
implements SubPrefsOptions {
    private String code;

    public CodeProjectionChoice() {
        super(I18n.tr("By Code (EPSG)", new Object[0]), "core:code");
    }

    @Override
    public Projection getProjection() {
        return Projections.getProjectionByCode(this.code);
    }

    @Override
    public String getCurrentCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getProjectionName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPreferences(Collection<String> args) {
        if (!Utils.isEmpty(args)) {
            this.code = args.iterator().next();
        }
    }

    @Override
    public JPanel getPreferencePanel(ActionListener listener) {
        return new CodeSelectionPanel(this.code, listener);
    }

    @Override
    public Collection<String> getPreferences(JPanel panel) {
        if (!(panel instanceof CodeSelectionPanel)) {
            throw new IllegalArgumentException("Unsupported panel: " + panel);
        }
        CodeSelectionPanel csPanel = (CodeSelectionPanel)panel;
        return Collections.singleton(csPanel.getCode());
    }

    @Override
    public String[] allCodes() {
        return new String[0];
    }

    @Override
    public Collection<String> getPreferencesFromCode(String code) {
        return null;
    }

    @Override
    public boolean showProjectionCode() {
        return true;
    }

    @Override
    public boolean showProjectionName() {
        return true;
    }

    public static class CodeComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Pattern codePattern = Pattern.compile("([a-zA-Z]+):(\\d+)");

        @Override
        public int compare(String c1, String c2) {
            Matcher matcher1 = this.codePattern.matcher(c1);
            Matcher matcher2 = this.codePattern.matcher(c2);
            if (matcher1.matches()) {
                if (matcher2.matches()) {
                    int cmp1 = matcher1.group(1).compareTo(matcher2.group(1));
                    if (cmp1 != 0) {
                        return cmp1;
                    }
                    int num1 = Integer.parseInt(matcher1.group(2));
                    int num2 = Integer.parseInt(matcher2.group(2));
                    return Integer.compare(num1, num2);
                }
                return -1;
            }
            if (matcher2.matches()) {
                return 1;
            }
            return c1.compareTo(c2);
        }
    }
}

