/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.knowledge;

import net.adaptivebox.global.RandomGenerator;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.problem.ProblemEncoder;

public class Library {
    private final SearchPoint[] libPoints;
    private int gIndex = -1;

    public Library(int number, ProblemEncoder problemEncoder) {
        this.libPoints = new SearchPoint[number];
        for (int i = 0; i < number; ++i) {
            this.libPoints[i] = problemEncoder.getEncodedSearchPoint();
        }
    }

    public SearchPoint getGbest() {
        return this.getSelectedPoint(this.gIndex);
    }

    public void refreshGbest(IGoodnessCompareEngine qualityComparator) {
        this.gIndex = this.tournamentSelection(qualityComparator, this.getPopSize() - 1, true);
    }

    public int getPopSize() {
        return this.libPoints.length;
    }

    public SearchPoint getSelectedPoint(int index) {
        return this.libPoints[index];
    }

    public SearchPoint getRandomPoint() {
        return this.libPoints[RandomGenerator.intRangeRandom(0, this.libPoints.length - 1)];
    }

    public static boolean replace(IGoodnessCompareEngine comparator, SearchPoint outPoint, SearchPoint tobeReplacedPoint) {
        boolean isBetter = false;
        if (comparator.compare(outPoint.getEncodeInfo(), tobeReplacedPoint.getEncodeInfo()) < 2) {
            tobeReplacedPoint.importPoint(outPoint);
            isBetter = true;
        }
        return isBetter;
    }

    public int tournamentSelection(IGoodnessCompareEngine comparator, int times, boolean isBetter) {
        int[] indices = RandomGenerator.randomSelection(this.getPopSize(), times);
        int currentIndex = indices[0];
        for (int i = 1; i < indices.length; ++i) {
            int compareValue = comparator.compare(this.libPoints[indices[i]].getEncodeInfo(), this.libPoints[currentIndex].getEncodeInfo());
            if (isBetter != compareValue < 2) continue;
            currentIndex = indices[i];
        }
        return currentIndex;
    }

    public double getExtremalVcon(boolean isMAX) {
        double val = -1.0E308;
        for (int i = 0; i < this.libPoints.length; ++i) {
            if (this.libPoints[i].getEncodeInfo()[0] > val != isMAX) continue;
            val = this.libPoints[i].getEncodeInfo()[0];
        }
        return val;
    }

    public int getVconThanNum(double allowedCons) {
        int num = 0;
        for (int i = 0; i < this.libPoints.length; ++i) {
            if (!(this.libPoints[i].getEncodeInfo()[0] <= allowedCons)) continue;
            ++num;
        }
        return num;
    }
}

