/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

// autogenerated file with codegen.pl

#include <cppunit/TestAssert.h>
#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>

#include <basegfx/vector/b2isize.hxx>
#include <basegfx/range/b2ibox.hxx>
#include <basegfx/point/b2ipoint.hxx>
#include <basegfx/polygon/b2dpolygon.hxx>
#include <basegfx/polygon/b2dpolygontools.hxx>
#include <basegfx/polygon/b2dpolypolygon.hxx>
#include <basegfx/polygon/b2dpolypolygontools.hxx>

#include <basebmp/color.hxx>
#include <basebmp/scanlineformats.hxx>
#include <basebmp/bitmapdevice.hxx>
#include "tools.hxx"

using namespace ::basebmp;

namespace
{
class BmpMaskTest : public CppUnit::TestFixture
{
private:
    BitmapDeviceSharedPtr mpDevice1bpp;
    BitmapDeviceSharedPtr mpMaskBmp1bpp;
    BitmapDeviceSharedPtr mpBmp1bpp;
    BitmapDeviceSharedPtr mpDevice32bpp;
    BitmapDeviceSharedPtr mpBmp32bpp;

    void implTestBmpBasics(const BitmapDeviceSharedPtr& rDevice,
                           const BitmapDeviceSharedPtr& rBmp)
    {
        rDevice->clear(Color(0));
        const Color aCol(0xFFFFFFFF);

        const basegfx::B2IBox aSourceRect(0,0,10,10);
        const basegfx::B2IBox aDestAll(0,0,10,10);

        rDevice->drawMaskedBitmap(
            rBmp,
            mpMaskBmp1bpp,
            aSourceRect,
            aDestAll,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 30",
                               countPixel( rDevice, aCol ) == 30);
    }

    void implTestBmpScaledClip(const BitmapDeviceSharedPtr& rDevice,
                               const BitmapDeviceSharedPtr& rBmp)
    {
        rDevice->clear(Color(0));
        const Color aCol(0xFFFFFFFF);

        const basegfx::B2IBox aSourceRect(0,0,10,10);
        const basegfx::B2IBox aDestLeftTop(0,0,6,6);

        rDevice->drawMaskedBitmap(
            rBmp,
            mpMaskBmp1bpp,
            aSourceRect,
            aDestLeftTop,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 12",
                               countPixel( rDevice, aCol ) == 12);
    }

public:
    void setUp() SAL_OVERRIDE
    {
        const basegfx::B2ISize aSize(10,10);
        mpDevice1bpp = createBitmapDevice( aSize,
                                           true,
                                           FORMAT_ONE_BIT_MSB_PAL );
        mpDevice32bpp = createBitmapDevice( aSize,
                                            true,
                                            FORMAT_THIRTYTWO_BIT_TC_MASK_BGRA );

        mpMaskBmp1bpp = createBitmapDevice( aSize,
                                            true,
                                            FORMAT_ONE_BIT_MSB_GREY );

        mpBmp1bpp = createBitmapDevice( aSize,
                                        true,
                                        FORMAT_ONE_BIT_MSB_PAL );
        mpBmp32bpp = createBitmapDevice( aSize,
                                         true,
                                         FORMAT_THIRTYTWO_BIT_TC_MASK_BGRA );

        OUString aSvg( "m 0 0h5v10h5v-5h-10z" );

        basegfx::B2DPolyPolygon aPoly;
        basegfx::tools::importFromSvgD( aPoly, aSvg, false, NULL );
        const Color aColWhite(0xFFFFFFFF);
        const Color aColBlack(0);
        mpBmp1bpp->fillPolyPolygon(
            aPoly,
            aColWhite,
            DrawMode_PAINT );
        mpBmp32bpp->fillPolyPolygon(
            aPoly,
            aColWhite,
            DrawMode_PAINT );

        aSvg = "m 0 0 h6 v10 h-6z" ;

        aPoly.clear();
        basegfx::tools::importFromSvgD( aPoly, aSvg, false, NULL );
        mpMaskBmp1bpp->clear(aColWhite);
        mpMaskBmp1bpp->fillPolyPolygon(
            aPoly,
            aColBlack,
            DrawMode_PAINT );
    }

    void testBmpBasics()
    {
        implTestBmpBasics( mpDevice1bpp, mpBmp1bpp );
        implTestBmpBasics( mpDevice32bpp, mpBmp32bpp );
    }

    void testBmpClip()
    {
        implTestBmpScaledClip( mpDevice1bpp, mpBmp1bpp );
        implTestBmpScaledClip( mpDevice32bpp, mpBmp32bpp );
    }

    // Change the following lines only, if you add, remove or rename
    // member functions of the current class,
    // because these macros are need by auto register mechanism.

    CPPUNIT_TEST_SUITE(BmpMaskTest);
    CPPUNIT_TEST(testBmpBasics);
    CPPUNIT_TEST(testBmpClip);
    CPPUNIT_TEST_SUITE_END();
};

CPPUNIT_TEST_SUITE_REGISTRATION(BmpMaskTest);
}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
