/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */


#include <editeng/measfld.hxx>

SV_IMPL_PERSIST1(SdrMeasureField,SvxFieldData);

SdrMeasureField::~SdrMeasureField()
{
}

SvxFieldData* SdrMeasureField::Clone() const
{
    return new SdrMeasureField(*this);
}

bool SdrMeasureField::operator==(const SvxFieldData& rSrc) const
{
    return eMeasureFieldKind == static_cast<const SdrMeasureField&>(rSrc).GetMeasureFieldKind();
}

void SdrMeasureField::Load(SvPersistStream& rIn)
{
    sal_uInt16 nFieldKind;
    rIn.ReadUInt16( nFieldKind );
    eMeasureFieldKind=(SdrMeasureFieldKind)nFieldKind;
}

void SdrMeasureField::Save(SvPersistStream& rOut)
{
    rOut.WriteUInt16( eMeasureFieldKind );
}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
