# Copyright 2016 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

import unittest

from form_classification_test import FormClassificationTest
"""Unittest class for testing signin forms.

The test methods were generated by the form annotation extension
(components/test/data/password_manager/form_annotation_extension)
"""


class SignInFormsTest(FormClassificationTest):

  def test_i_360_cn(self):
    self.GoTo("http://i.360.cn/login/")
    self.CheckPwdField("INPUT[name='password'][type='password']",
                       is_pwd_creation=False)

  def test_9gag_com(self):
    self.GoTo("http://9gag.com/")
    self.Click("A.btn-mute")
    self.CheckPwdField(
        "INPUT[id='login-email-password'][name='password'][type='password']",
        is_pwd_creation=False)

  def test_login_adf_ly(self):
    self.GoTo("https://login.adf.ly/login")
    self.CheckPwdField("INPUT#loginPassword[name='password'][type='password']",
                       is_pwd_creation=False)

  def test_adobeid_na1_services_adobe_com(self):
    self.GoTo("http://www.adobe.com/")
    self.Click("SPAN.close > A")
    self.Click("LI[class*='signin'] > BUTTON")
    self.CheckPwdField(
        "INPUT[id='adobeid_password'][name='password'][type='password']"
        ".text-center",
        is_pwd_creation=False)

  def test_publishers_adsterra_net(self):
    self.GoTo("http://publishers.adsterra.net/login")
    self.CheckPwdField("INPUT[name='password'][type='password']",
                       is_pwd_creation=False)

  def test_ssl_allegro_pl(self):
    self.GoTo("http://allegro.pl/")
    SignInFormsTest.driver.maximize_window()
    self.Click(
        "DIV.header-namespace > DIV.user-links-wrapper > DIV.wrapper-fluid > "
        "UL.user-nav > LI.login:nth-child(10) > A")
    self.CheckPwdField(
        "INPUT[id='password'][name='password'][type='password'].ng-untouched",
        is_pwd_creation=False)

  def test_www_amazon_com(self):
    self.GoTo("http://www.amazon.com/")
    self.Click("A[id='nav-link-yourAccount']")
    self.CheckPwdField(
        "INPUT[id='ap_password'][name='password'][type='password']"
        ".a-input-text",
        is_pwd_creation=False)

  def test_my_screenname_aol_com(self):
    self.GoTo(
        "https://my.screenname.aol.com/_cqr/login/login.psp?sitedomain="
        "www.aol.com&lang=en&locale=us&authLev=0")
    self.CheckPwdField(
        "INPUT#pwdId1[name='password'][type='password'].inputBox",
        is_pwd_creation=False)

  def test_secure2_store_apple_com(self):
    self.GoTo("http://www.apple.com/")
    self.Click("LI[id='ac-gn-bag'].ac-gn-bag:nth-child(10) > A.ac-gn-link-bag")
    self.Click("A.ac-gn-bagview-nav-link-signIn")
    self.CheckPwdField(
        "INPUT[id='login-password'][name='login-password'][type='password']"
        ".password",
        is_pwd_creation=False)

  def test_www_baidu_com(self):
    self.GoTo("http://www.baidu.com/")
    self.Click("DIV#u1 > A[name='tj_login'].lb")
    self.CheckPwdField(
        "INPUT#TANGRAM__PSP_8__password[name='password'][type='password']"
        ".pass-text-input-password",
        is_pwd_creation=False)

  def test_blogs_forbes_com(self):
    self.GoTo("http://blogs.forbes.com/account/login/")
    self.CheckPwdField(
        "INPUT[id='login_form_password'][name='pass'][type='password']",
        is_pwd_creation=False)

  def test_secure_fly_cnet_com(self):
    self.GoTo("https://secure-fly.cnet.com/uk/user/login/")
    self.CheckPwdField(
        "INPUT#login_password[name='login[password]'][type='password']",
        is_pwd_creation=False)

  def test_passport_csdn_net(self):
    self.GoTo("https://passport.csdn.net/account/login")
    self.CheckPwdField(
        "INPUT#password[name='password'][type='password'].pass-word",
        is_pwd_creation=False)

  def test_signin_ebay_com(self):
    self.GoTo("https://signin.ebay.com/ws/eBayISAPI.dll?SignIn")
    self.CheckPwdField("DIV#pri_signin INPUT[type='password']",
                       is_pwd_creation=False)

  def test_email_163_com(self):
    self.GoTo("http://email.163.com/")
    self.CheckPwdField("INPUT#pwdInput[name='password'][type='password']",
                       is_pwd_creation=False)

  def test_en_softonic_com(self):
    self.GoTo("http://en.softonic.com/")
    self.Click("A#header-login-link.header-site-user-btn")  # Close overlay.
    self.Click("A#header-login-link.header-site-user-btn")
    self.CheckPwdField(
        "INPUT#password[name='password'][type='password'].field-default",
        is_pwd_creation=False)

  def test_id_orange_fr(self):
    self.GoTo("https://id.orange.fr/auth_user/bin/auth_user.cgi")
    self.CheckPwdField(
        "INPUT#default_f_password[name='password'][type='password'].password",
        is_pwd_creation=False)

  def test_feedly_com(self):
    self.GoTo("https://feedly.com/v3/auth/login")
    self.CheckPwdField("INPUT[name='password'][type='password'].input-bottom",
                       is_pwd_creation=False)

  def test_gfycat_com(self):
    self.GoTo("http://gfycat.com/")
    self.Click("BUTTON.login-btn")
    self.CheckPwdField("INPUT[type='password']", is_pwd_creation=False)

  def test_github_com(self):
    self.GoTo("https://github.com/login")
    self.CheckPwdField(
        "INPUT#password[name='password'][type='password'].form-control",
        is_pwd_creation=False)

  def test_login_globo_com(self):
    self.GoTo("https://login.globo.com/login/4728")
    self.CheckPwdField(
        "INPUT[id='password'][name='password'][type='password'].password",
        is_pwd_creation=False)

  def test_www_gmx_net(self):
    self.GoTo("http://www.gmx.net/")
    self.CheckPwdField(
        "INPUT#inpLoginFreemailPassword[name='password'][type='password']",
        is_pwd_creation=False)

  def test_uk_godaddy_com(self):
    self.GoTo("https://uk.godaddy.com/")
    self.Click(
        "DIV[id='sign-in'].pc-menu-item.ux-tray > A.ux-tray-toggle.menu-title")
    self.CheckPwdField("INPUT[id='password'][name='password'][type='password']",
                       is_pwd_creation=False)

  def test_id_ifeng_com(self):
    self.GoTo("https://id.ifeng.com/user/login")
    self.CheckPwdField(
        "INPUT#userLogin_pwd[name='userLogin_pwd'][type='password'].txt_270",
        is_pwd_creation=False)

  def test_secure_imdb_com(self):
    self.GoTo("http://www.imdb.com/")
    self.Click(
        "LI[id='navUserMenu'].css_nav_menu:nth-child(1) > P.singleLine > "
        "A[id='nblogin'].cboxElement")
    self.SwitchTo("IFRAME.cboxIframe")
    self.Click("A[id='imdb-toggle'].oauth-link")
    self.CheckPwdField(
        "INPUT[id='passwordprompt'][name='password'][type='password']",
        is_pwd_creation=False)

  def test_imgur_com(self):
    self.GoTo("https://imgur.com/signin")
    self.CheckPwdField(" INPUT[name='password'][type='password']",
                       is_pwd_creation=False)

  def test_secure_indeed_com(self):
    self.GoTo("https://secure.indeed.com/account/login")
    self.CheckPwdField(
        "INPUT#signin_password[name='password'][type='password']"
        ".input_password",
        is_pwd_creation=False)

  def test_www_instagram_com(self):
    self.GoTo("https://www.instagram.com/")
    self.Click("A._k6cv7")
    self.CheckPwdField("INPUT[name='password'][type='password']._kp5f7",
                       is_pwd_creation=False)

  def test_ssl_kakaku_com(self):
    self.GoTo("https://ssl.kakaku.com/auth/id/login.asp")
    self.CheckPwdField(
        "INPUT#password[name='password'][type='password'].secPwFrm",
        is_pwd_creation=False)

  def test_kat_cr(self):
    self.GoTo("https://kat.cr/")
    self.Click("DIV.land-login > A.ajaxLink")
    self.CheckPwdField(
        "INPUT#field_password[name='password'][type='password'].botmarg5px",
        is_pwd_creation=False)

  def test_www_linkedin_com(self):
    self.GoTo("https://www.linkedin.com/")
    self.CheckPwdField(
        "INPUT#login-password[name='session_password'][type='password']",
        is_pwd_creation=False)

  def test_login_live_com(self):
    self.GoTo("https://login.live.com/login.srf")
    self.CheckPwdField("INPUT[name='passwd'][type='password'].form-control",
                       is_pwd_creation=False)

  def test_mail_ru(self):
    self.GoTo("https://mail.ru/")
    self.CheckPwdField(
        "INPUT#mailbox__password[name='Password'][type='password']"
        ".mailbox__password",
        is_pwd_creation=False)

  def test_mega_nz(self):
    self.GoTo("https://mega.nz/")
    self.Click("A.top-login-button")
    self.CheckPwdField(
        "INPUT#login-password[name='login-password'][type='password']",
        is_pwd_creation=False)

  def test_member_livedoor_com(self):
    self.GoTo("https://member.livedoor.com/login/")
    self.CheckPwdField(
        "INPUT#password[name='password'][type='password'].password",
        is_pwd_creation=False)

  def test_my_outbrain_com(self):
    self.GoTo("https://my.outbrain.com/")
    self.CheckPwdField(
        "INPUT#signin-member-password[name='loginPassword'][type='password']"
        ".input-text",
        is_pwd_creation=False)

  def test_www_naver_com(self):
    self.GoTo("http://www.naver.com/")
    self.CheckPwdField("INPUT#pw[name='pw'][type='password']",
                       is_pwd_creation=False)

  def test_ssl_naver_jp(self):
    self.GoTo("https://ssl.naver.jp/login")
    self.CheckPwdField(
        "INPUT#_passwd[name='password'][type='password'].mdInputTxt03Input",
        is_pwd_creation=False)

  def test_www_netflix_com(self):
    self.GoTo("https://www.netflix.com/gb/")
    self.Click("DIV.nfHeader > A.authLinks")
    self.CheckPwdField("INPUT[name='password'][type='password'].ui-text-input",
                       is_pwd_creation=False)

  def test_passport_bilibili_com(self):
    self.GoTo("https://passport.bilibili.com/login")
    self.CheckPwdField("INPUT#passwdTxt[name='pwd'][type='password'].password",
                       is_pwd_creation=False)

  def test_passport_china_com(self):
    self.GoTo("http://passport.china.com/")
    self.CheckPwdField("INPUT[id='55'][name='password'][type='password']",
                       is_pwd_creation=False)

  def test_www_pinterest_com(self):
    self.GoTo("https://www.pinterest.com/login/")
    self.CheckPwdField("INPUT[name='password'][type='password']",
                       is_pwd_creation=False)

  def test_www_pixnet_net(self):
    self.GoTo("https://www.pixnet.net/")
    self.CheckPwdField(
        "INPUT[id='input-password'][name='password'][type='password']",
        is_pwd_creation=False)

  def test_qq_com(self):
    self.GoTo("http://www.qq.com/")
    self.Click("A[id='loginGrayLayout'].login")
    self.SwitchTo("#login_frame")
    self.CheckPwdField("INPUT[id='p'][name='p'][type='password'].password",
                       is_pwd_creation=False)

  def test_www_rakuten_co_jp(self):
    self.GoTo("https://www.rakuten.co.jp/myrakuten/login.html")
    self.CheckPwdField("INPUT[id='passwd'][name='p'][type='password'].textBox",
                       is_pwd_creation=False)

  def test_www_reddit_com(self):
    self.GoTo("https://www.reddit.com/")
    self.Click("SPAN.user > A.login-required")
    self.CheckPwdField(
        "INPUT[id='passwd_login'][name='passwd'][type='password']"
        ".c-form-control",
        is_pwd_creation=False)

  def test_login_sina_com_cn(self):
    self.GoTo("https://login.sina.com.cn/signup/signin.php")
    self.CheckPwdField("INPUT[id='password'][name='password'][type='password']",
                       is_pwd_creation=False)

  def test_login_skype_com(self):
    self.GoTo("https://login.skype.com/login")
    self.CheckPwdField("INPUT[id='password'][name='password'][type='password']",
                       is_pwd_creation=False)

  def test_www_sohu_com(self):
    self.GoTo("http://www.sohu.com/")
    self.CheckPwdField("INPUT[name='password'][type='password'].simple-pwd",
                       is_pwd_creation=False)

  def test_soundcloud_com(self):
    self.GoTo(
        "https://soundcloud.com/connect?client_id=02gUJC0hH2ct1EGOcYXQIzRFU91c"
        "72Ea&response_type=token&scope=non-expiring%20fast-connect%20purchase"
        "%20upload&display=next&redirect_uri=https%3A//soundcloud.com/"
        "soundcloud-callback.html")
    self.CheckPwdField(
        "INPUT[id='password'][name='password'][type='password'].sc-input",
        is_pwd_creation=False)

  def test_ssl_bbc_com(self):
    self.GoTo("https://ssl.bbc.com/id/signin")
    self.CheckPwdField(
        "INPUT[id='bbcid_password'][name='password'][type='password'].password",
        is_pwd_creation=False)

  def test_openid_stackexchange_com(self):
    self.GoTo("https://stackexchange.com/users/login?#log-in")
    self.SwitchTo("#affiliate-signin-iframe")
    self.CheckPwdField(
        "INPUT[id='password'][name='password'][type='password']"
        ".framed-text-field",
        is_pwd_creation=False)

  def test_stackoverflow_com(self):
    self.GoTo("https://stackoverflow.com/users/login")
    self.CheckPwdField("INPUT[id='password'][name='password'][type='password']",
                       is_pwd_creation=False)

  def test_store_steampowered_com(self):
    self.GoTo("https://store.steampowered.com//login/")
    self.CheckPwdField(
        "INPUT[id='input_password'][name='password'][type='password']"
        ".text_input",
        is_pwd_creation=False)

  def test_profile_theguardian_com(self):
    self.GoTo("https://profile.theguardian.com/signin")
    self.CheckPwdField(
        "INPUT[id='signin_field_password'][name='password'][type='password']"
        ".signin-form__field--password",
        is_pwd_creation=False)

  def test_thepiratebay_se(self):
    self.GoTo("https://thepiratebay.se/login")
    self.CheckPwdField("INPUT[id='password'][name='password'][type='password']",
                       is_pwd_creation=False)

  def test_torrentz_eu(self):
    self.GoTo("http://torrentz.eu/profile")
    self.CheckPwdField("INPUT[id='lpass'][name='pass'][type='password'].i",
                       is_pwd_creation=False)

  def test_login_tudou_com(self):
    self.GoTo("http://login.tudou.com/")
    self.CheckPwdField(
        "INPUT[id='password1'][name='password1'][type='password'].password",
        is_pwd_creation=False)

  def test_twitter_com(self):
    self.GoTo("https://twitter.com/")
    self.CheckPwdField(
        "INPUT[id='signin-password'][name='session[password]'][type='password']"
        ".flex-table-input",
        is_pwd_creation=False)

  def test_member_udn_com(self):
    self.GoTo("https://member.udn.com/member/login.jsp")
    self.CheckPwdField(
        "INPUT[id='password'][name='password'][type='password'].textfield",
        is_pwd_creation=False)

  def test_en_uptodown_com(self):
    SignInFormsTest.driver.maximize_window()
    self.GoTo("http://en.uptodown.com/ubuntu")
    self.Click("A.button > SPAN")
    self.CheckPwdField("INPUT[id='password'][type='password']",
                       is_pwd_creation=False)

  def test_vimeo_com(self):
    self.GoTo("https://vimeo.com/")
    self.Click("A.js-login_toggle")
    self.CheckPwdField(
        "INPUT[id='login_password'][name='password'][type='password']"
        ".js-login_password",
        is_pwd_creation=False)

  def test_web_de(self):
    self.GoTo("http://web.de/")
    self.Click("A.icon-freemail")
    self.CheckPwdField(
        "INPUT[id='inpFreemailLoginPassword'][name='password']"
        "[type='password']",
        is_pwd_creation=False)

  def test_weibo_com(self):
    self.GoTo("http://weibo.com/")
    self.Click("DIV.tab > A:nth-child(2)")
    self.CheckPwdField("INPUT[name='password'][type='password'].W_input",
                       is_pwd_creation=False)

  def test_en_wikipedia_org(self):
    self.GoTo("https://en.wikipedia.org/w/index.php?title=Special:UserLogin")
    self.CheckPwdField(
        "INPUT[id='wpPassword1'][name='wpPassword'][type='password']"
        ".loginPassword",
        is_pwd_creation=False)

  def test_www_avito_ru(self):
    self.GoTo("https://www.avito.ru/profile/login")
    self.CheckPwdField("INPUT[name='password'][type='password'].password-field",
                       is_pwd_creation=False)

  def test_www_babytree_com(self):
    self.GoTo("http://www.babytree.com/reg/login.php")
    self.CheckPwdField(
        "INPUT[name='password'][type='password'].login-input-text",
        is_pwd_creation=False)

  def test_www_booking_com(self):
    self.GoTo("http://www.booking.com/")
    self.Click("li.account_register_option div.sign_in_wrapper")
    self.CheckPwdField("INPUT[name='password'][type='password']",
                       is_pwd_creation=False)

  def test_www_buzzfeed_com(self):
    self.GoTo("http://www.buzzfeed.com/")
    self.Click(
        "DIV.page-nav__utilities > DIV[id='nav-signin'].nav-signin > "
        "DIV[id='usernav-signin'] > A[id='header-signin'].nav-signin-icon")
    self.CheckPwdField(
        "INPUT[name='password'][type='password'].js-user-password",
        is_pwd_creation=False)

  def test_www_dailymail_co_uk(self):
    self.GoTo("http://www.dailymail.co.uk/home/index.html")
    self.Click("A.js-login")
    self.CheckPwdField(
        "INPUT[id='reg-lbx-password-lightbox'][name='j_password']"
        "[type='password']",
        is_pwd_creation=False)

  def test_www_deviantart_com(self):
    self.GoTo("http://www.deviantart.com/")
    self.Click("TD[id='oh-loginbutton'] > A.oh-touch")
    self.CheckPwdField(
        "INPUT[id='login-password'][name='password'][type='password'].itext",
        is_pwd_creation=False)

  def test_www_dmm_com(self):
    self.GoTo("https://www.dmm.com/en/my/-/login/=/path=SgReFg__/")
    self.CheckPwdField("INPUT[id='password'][name='password'][type='password']",
                       is_pwd_creation=False)

  def test_www_douyu_com(self):
    self.GoTo("http://www.douyu.com/")
    SignInFormsTest.driver.maximize_window()
    self.Click("A.u-login")
    self.CheckPwdField("FORM > P > INPUT[name='password'][type='password'].ipt",
                       is_pwd_creation=False)

  def test_www_dropbox_com(self):
    self.GoTo("https://www.dropbox.com/")
    SignInFormsTest.driver.maximize_window()
    self.Click("A[id='sign-in'].sign-in")
    self.CheckPwdField("INPUT[name='login_password'][type='password']",
                       is_pwd_creation=False)

  def test_www_etsy_com(self):
    self.GoTo("https://www.etsy.com/")
    self.Click("A[id='sign-in'].signin-header-action")
    self.CheckPwdField(
        "INPUT[id='password-existing'][name='password'][type='password'].text",
        is_pwd_creation=False)

  def test_www_facebook_com(self):
    self.GoTo("https://www.facebook.com/")
    self.CheckPwdField(
        "INPUT[id='pass'][name='pass'][type='password'].inputtext",
        is_pwd_creation=False)

  def test_www_foxnews_com(self):
    self.GoTo("http://www.foxnews.com/")
    self.Click("A.login")
    self.CheckPwdField(
        "INPUT[id='capture_signIn_traditionalSignIn_password']"
        "[name='traditionalSignIn_password'][type='password']"
        ".capture_traditionalSignIn_password",
        is_pwd_creation=False)

  def test_www_homedepot_com(self):
    self.GoTo("http://www.homedepot.com/")
    self.Click("A[id='headerMyAccount'].headerMyAccount__button")
    self.Click("A.headerMyAccount__authLink")
    self.CheckPwdField(
        "INPUT[id='password'][name='logonPassword'][type='password']"
        ".width_332px",
        is_pwd_creation=False)

  def test_www_livejournal_com(self):
    self.GoTo("http://www.livejournal.com/")
    self.Click("A.s-header-item__link--login")
    self.CheckPwdField(
        "INPUT[id='lj_loginwidget_password'][name='password'][type='password']"
        ".b-input",
        is_pwd_creation=False)

  def test_www_mediafire_com(self):
    self.GoTo(
        "https://www.mediafire.com/templates/login_signup/login_signup.php")
    self.CheckPwdField(
        "INPUT[id='widget_login_pass'][name='login_pass'][type='password']",
        is_pwd_creation=False)

  def test_www_nytimes_com(self):
    self.GoTo("http://www.nytimes.com/")
    self.Click("DIV[id='instl_close'] > A.nytdGrowlNotifyCross"
              )  # Close overlay.
    self.Click("BUTTON.button.login-modal-trigger")
    self.CheckPwdField(
        "INPUT[id='login-password'][name='password'][type='password']"
        ".login-password",
        is_pwd_creation=False)

  def test_www_popads_net(self):
    self.GoTo("https://www.popads.net/")
    self.CheckPwdField(
        "INPUT[id='UserPassword'][name='data[User][password]']"
        "[type='password']",
        is_pwd_creation=False)

  def test_www_quora_com(self):
    self.GoTo("https://www.quora.com/")
    self.CheckPwdField(
        "INPUT[id*='password'][name='password'][type='password']"
        ".header_login_text_box",
        is_pwd_creation=False)

  def test_www_slideshare_net(self):
    self.GoTo("https://www.slideshare.net/login")
    self.CheckPwdField(
        "INPUT[id='user_password'][name='user_password'][type='password']",
        is_pwd_creation=False)

  def test_www_so_com(self):
    self.GoTo("https://www.so.com/")
    self.Click("A[id='user-login']")
    self.CheckPwdField(
        "INPUT[id*='password'][name='password'][type='password']"
        ".quc-input-password",
        is_pwd_creation=False)

  def test_www_sunmaker_com(self):
    self.GoTo("https://www.sunmaker.com/de/")
    self.CheckPwdField("INPUT[name='password'][type='password'].form-control",
                       is_pwd_creation=False)

  def test_www_tianya_cn(self):
    self.GoTo("http://www.tianya.cn/")
    self.CheckPwdField(
        "INPUT[id='password1'][name='vpassword'][type='password'].text-ipt",
        is_pwd_creation=False)

  def test_www_tribunnews_com(self):
    self.GoTo("http://www.tribunnews.com/")
    SignInFormsTest.driver.maximize_window()
    self.Click("A[id='login'].blue")
    self.CheckPwdField(
        "FORM[id='logform'].form  INPUT[name='password']"
        "[type='password'].input",
        is_pwd_creation=False)

  def test_www_tripadvisor_com(self):
    self.GoTo("https://www.tripadvisor.com/")
    self.Click("LI.login:nth-child(4) > SPAN.link.no_cpu")
    self.SwitchTo("#overlayRegFrame")
    self.CheckPwdField("INPUT[id='regSignIn.password'][type='password'].text",
                       is_pwd_creation=False)

  def test_www_walmart_com(self):
    self.GoTo("https://www.walmart.com/account/login")
    self.CheckPwdField(
        "INPUT[id='login-password'][name='login-password'][type='password']"
        ".js-password",
        is_pwd_creation=False)

  def test_www_wittyfeed_com(self):
    self.GoTo("http://www.wittyfeed.com/")
    self.Click("A.express")
    self.CheckPwdField(
        "DIV.signIn_passwordDiv > "
        "INPUT[name='password'][type='password'].form-control",
        is_pwd_creation=False)

  def test_www_yelp_com(self):
    self.GoTo("https://www.yelp.com/login")
    self.CheckPwdField(
        "FORM[id='ajax-login'].yform > "
        "INPUT[id='password'][name='password'][type='password']",
        is_pwd_creation=False)

  def test_www_zillow_com(self):
    self.GoTo("https://www.zillow.com")
    self.Click("A[id='login_opener'].zss-login-link")
    self.SwitchTo("DIV#login_content > IFRAME")
    self.CheckPwdField("INPUT[id='password'][name='password'][type='password']",
                       is_pwd_creation=False)

  def test_yandex_ru(self):
    self.GoTo("https://yandex.ru/")
    self.CheckPwdField("INPUT[name='passwd'][type='password'].input__input",
                       is_pwd_creation=False)

  def test_login_youku_com(self):
    self.GoTo("http://login.youku.com/user/login_win")
    self.CheckPwdField(
        "INPUT[id='password'][name='password'][type='password'].form_input",
        is_pwd_creation=False)

  def test_service_zol_com_cn(self):
    self.GoTo("http://service.zol.com.cn/user/siteLogin.php")
    self.CheckPwdField("INPUT[id='loginPwd'][type='password']",
                       is_pwd_creation=False)


if __name__ == "__main__":
  unittest.main()
