/* SourceHoldingTank.c generated by valac 0.40.4, the Vala compiler
 * generated from SourceHoldingTank.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* A SourceHoldingTank is similar to the holding tank used by ContainerSourceCollection, but for*/
/* non-ContainerSources to be held offline from their natural SourceCollection (i.e. PhotoSources*/
/* being held in a trashcan, for example).  It is *not* a DataCollection (important!), but rather*/
/* a signalled collection that moves DataSources to and from their SourceCollection.*/
/**/
/* DataSources can be shuttled from their SourceCollection to the SourceHoldingTank manually*/
/* (via unlink_and_hold) or can be automatically moved by installing a HoldingPredicate.*/
/* Only one HoldingConditional may be installed.  Because of assertions in the methods, it's unwise*/
/* to use more than one method.  add() and add_many() should ONLY be used for DataSources not*/
/* first installed in their SourceCollection (i.e. they're born in the SourceHoldingTank).*/
/**/
/* NOTE: DataSources should never be in more than one SourceHoldingTank.  No tests are performed*/
/* here to verify this.  This is why a filter/predicate method (which could automatically move*/
/* them in as they're altered) is not offered; there's no easy way to keep DataSources from being*/
/* moved into more than one holding tank, or which should have preference.  The CheckToRemove*/
/* predicate is offered only to know when to release them.*/


#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;
typedef struct _SourceHoldingTankPrivate SourceHoldingTankPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_SET (data_set_get_type ())
#define DATA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SET, DataSet))
#define DATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SET, DataSetClass))
#define IS_DATA_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SET))
#define IS_DATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SET))
#define DATA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SET, DataSetClass))

typedef struct _DataSet DataSet;
typedef struct _DataSetClass DataSetClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _data_set_unref0(var) ((var == NULL) ? NULL : (var = (data_set_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;

#define TYPE_SINGLETON_COLLECTION (singleton_collection_get_type ())
#define SINGLETON_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SINGLETON_COLLECTION, SingletonCollection))
#define SINGLETON_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SINGLETON_COLLECTION, SingletonCollectionClass))
#define IS_SINGLETON_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SINGLETON_COLLECTION))
#define IS_SINGLETON_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SINGLETON_COLLECTION))
#define SINGLETON_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SINGLETON_COLLECTION, SingletonCollectionClass))

typedef struct _SingletonCollection SingletonCollection;
typedef struct _SingletonCollectionClass SingletonCollectionClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecSourceHoldingTank ParamSpecSourceHoldingTank;
enum  {
	SOURCE_HOLDING_TANK_CONTENTS_ALTERED_SIGNAL,
	SOURCE_HOLDING_TANK_NUM_SIGNALS
};
static guint source_holding_tank_signals[SOURCE_HOLDING_TANK_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SourceHoldingTank {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SourceHoldingTankPrivate * priv;
};

struct _SourceHoldingTankClass {
	GTypeClass parent_class;
	void (*finalize) (SourceHoldingTank *self);
	void (*notify_contents_altered) (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
	void (*contents_altered) (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
};

typedef gboolean (*SourceHoldingTankCheckToKeep) (DataSource* source, Alteration* alteration, void* user_data);
struct _SourceHoldingTankPrivate {
	SourceCollection* sources;
	SourceHoldingTankCheckToKeep check_to_keep;
	gpointer check_to_keep_target;
	DataSet* tank;
	GeeHashSet* relinks;
	GeeHashSet* unlinking;
	gint64 ordinal;
};

struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
struct _ParamSpecSourceHoldingTank {
	GParamSpec parent_instance;
};


static gpointer source_holding_tank_parent_class = NULL;

gpointer source_holding_tank_ref (gpointer instance);
void source_holding_tank_unref (gpointer instance);
GParamSpec* param_spec_source_holding_tank (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void value_set_source_holding_tank (GValue* value,
                                    gpointer v_object);
void value_take_source_holding_tank (GValue* value,
                                     gpointer v_object);
gpointer value_get_source_holding_tank (const GValue* value);
GType source_holding_tank_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_data_collection (GValue* value,
                                gpointer v_object);
void value_take_data_collection (GValue* value,
                                 gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_alteration (GValue* value,
                           gpointer v_object);
void value_take_alteration (GValue* value,
                            gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_set_ref (gpointer instance);
void data_set_unref (gpointer instance);
GParamSpec* param_spec_data_set (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void value_set_data_set (GValue* value,
                         gpointer v_object);
void value_take_data_set (GValue* value,
                          gpointer v_object);
gpointer value_get_data_set (const GValue* value);
GType data_set_get_type (void) G_GNUC_CONST;
#define SOURCE_HOLDING_TANK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankPrivate))
static void source_holding_tank_on_source_destroyed (SourceHoldingTank* self,
                                              DataSource* source);
static void _source_holding_tank_on_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                                DataSource* source,
                                                                                gpointer self);
static void source_holding_tank_on_source_collection_thawed (SourceHoldingTank* self);
static void _source_holding_tank_on_source_collection_thawed_data_collection_thawed (DataCollection* _sender,
                                                                              gpointer self);
DataSet* data_set_new (void);
DataSet* data_set_construct (GType object_type);
SourceHoldingTank* source_holding_tank_new (SourceCollection* sources,
                                            SourceHoldingTankCheckToKeep check_to_keep,
                                            void* check_to_keep_target);
SourceHoldingTank* source_holding_tank_construct (GType object_type,
                                                  SourceCollection* sources,
                                                  SourceHoldingTankCheckToKeep check_to_keep,
                                                  void* check_to_keep_target);
void source_holding_tank_notify_contents_altered (SourceHoldingTank* self,
                                                  GeeCollection* added,
                                                  GeeCollection* removed);
static void source_holding_tank_real_notify_contents_altered (SourceHoldingTank* self,
                                                       GeeCollection* added,
                                                       GeeCollection* removed);
void data_source_notify_held_in_tank (DataSource* self,
                                      SourceHoldingTank* holding_tank);
gint source_holding_tank_get_count (SourceHoldingTank* self);
gint data_set_get_count (DataSet* self);
GeeCollection* source_holding_tank_get_all (SourceHoldingTank* self);
GeeList* data_set_get_all (DataSet* self);
gboolean source_holding_tank_contains (SourceHoldingTank* self,
                                       DataSource* source);
gboolean data_set_contains (DataSet* self,
                            DataObject* object);
void source_holding_tank_add_many (SourceHoldingTank* self,
                                   GeeCollection* many);
void data_object_internal_set_ordinal (DataObject* self,
                                       gint64 ordinal);
gboolean data_set_add_many (DataSet* self,
                            GeeCollection* objects);
void source_holding_tank_unlink_and_hold (SourceHoldingTank* self,
                                          GeeCollection* unlink);
GType marker_get_type (void) G_GNUC_CONST;
GeeCollection* source_collection_unlink_marked (SourceCollection* self,
                                                Marker* marker,
                                                ProgressMonitor monitor,
                                                void* monitor_target);
Marker* data_collection_mark_many (DataCollection* self,
                                   GeeCollection* objects);
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_source_backlink (GValue* value,
                                gpointer v_object);
void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
gboolean source_holding_tank_has_backlink (SourceHoldingTank* self,
                                           SourceBacklink* backlink);
DataObject* data_set_get_at (DataSet* self,
                             gint index);
gboolean data_source_has_backlink (DataSource* self,
                                   SourceBacklink* backlink);
void source_holding_tank_remove_backlink (SourceHoldingTank* self,
                                          SourceBacklink* backlink);
gboolean data_source_remove_backlink (DataSource* self,
                                      SourceBacklink* backlink);
void source_holding_tank_destroy_orphans (SourceHoldingTank* self,
                                          GeeList* destroy,
                                          gboolean delete_backing,
                                          ProgressMonitor monitor,
                                          void* monitor_target,
                                          GeeList* not_removed);
gboolean data_set_remove_many (DataSet* self,
                               GeeCollection* objects);
gboolean data_source_destroy_orphan (DataSource* self,
                                     gboolean delete_backing);
gboolean data_set_remove (DataSet* self,
                          DataObject* object);
SingletonCollection* singleton_collection_new (GType g_type,
                                               GBoxedCopyFunc g_dup_func,
                                               GDestroyNotify g_destroy_func,
                                               gconstpointer object);
SingletonCollection* singleton_collection_construct (GType object_type,
                                                     GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func,
                                                     gconstpointer object);
GType singleton_collection_get_type (void) G_GNUC_CONST;
void source_holding_tank_internal_notify_altered (SourceHoldingTank* self,
                                                  DataSource* source,
                                                  Alteration* alteration);
gchar* data_object_to_string (DataObject* self);
gchar* source_holding_tank_to_string (SourceHoldingTank* self);
gboolean data_collection_are_notifications_frozen (DataCollection* self);
void source_collection_relink (SourceCollection* self,
                               DataSource* source);
void source_collection_relink_many (SourceCollection* self,
                                    GeeCollection* relink);
static void source_holding_tank_real_contents_altered (SourceHoldingTank* self,
                                                GeeCollection* added,
                                                GeeCollection* removed);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void source_holding_tank_finalize (SourceHoldingTank * obj);


static void
_source_holding_tank_on_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                           DataSource* source,
                                                                           gpointer self)
{
#line 48 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	source_holding_tank_on_source_destroyed ((SourceHoldingTank*) self, source);
#line 371 "SourceHoldingTank.c"
}


static void
_source_holding_tank_on_source_collection_thawed_data_collection_thawed (DataCollection* _sender,
                                                                         gpointer self)
{
#line 49 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	source_holding_tank_on_source_collection_thawed ((SourceHoldingTank*) self);
#line 381 "SourceHoldingTank.c"
}


static gpointer
_data_collection_ref0 (gpointer self)
{
#line 40 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	return self ? data_collection_ref (self) : NULL;
#line 390 "SourceHoldingTank.c"
}


SourceHoldingTank*
source_holding_tank_construct (GType object_type,
                               SourceCollection* sources,
                               SourceHoldingTankCheckToKeep check_to_keep,
                               void* check_to_keep_target)
{
	SourceHoldingTank* self = NULL;
	SourceCollection* _tmp0_;
	SourceCollection* _tmp1_;
	SourceCollection* _tmp2_;
#line 39 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (sources), NULL);
#line 39 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	self = (SourceHoldingTank*) g_type_create_instance (object_type);
#line 40 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp0_ = _data_collection_ref0 (sources);
#line 40 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_data_collection_unref0 (self->priv->sources);
#line 40 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	self->priv->sources = _tmp0_;
#line 41 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	self->priv->check_to_keep = check_to_keep;
#line 41 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	self->priv->check_to_keep_target = check_to_keep_target;
#line 43 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp1_ = self->priv->sources;
#line 43 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_signal_connect (_tmp1_, "item-destroyed", (GCallback) _source_holding_tank_on_source_destroyed_source_collection_item_destroyed, self);
#line 44 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp2_ = self->priv->sources;
#line 44 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_COLLECTION, DataCollection), "thawed", (GCallback) _source_holding_tank_on_source_collection_thawed_data_collection_thawed, self);
#line 39 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	return self;
#line 428 "SourceHoldingTank.c"
}


SourceHoldingTank*
source_holding_tank_new (SourceCollection* sources,
                         SourceHoldingTankCheckToKeep check_to_keep,
                         void* check_to_keep_target)
{
#line 39 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	return source_holding_tank_construct (TYPE_SOURCE_HOLDING_TANK, sources, check_to_keep, check_to_keep_target);
#line 439 "SourceHoldingTank.c"
}


static void
source_holding_tank_real_notify_contents_altered (SourceHoldingTank* self,
                                                  GeeCollection* added,
                                                  GeeCollection* removed)
{
#line 52 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_COLLECTION (added));
#line 52 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_COLLECTION (removed));
#line 54 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (added != NULL) {
#line 454 "SourceHoldingTank.c"
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp0_;
#line 55 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_ITERABLE, GeeIterable));
#line 55 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_source_it = _tmp0_;
#line 55 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			while (TRUE) {
#line 464 "SourceHoldingTank.c"
				GeeIterator* _tmp1_;
				DataSource* source = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				DataSource* _tmp4_;
#line 55 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp1_ = _source_it;
#line 55 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				if (!gee_iterator_next (_tmp1_)) {
#line 55 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
					break;
#line 476 "SourceHoldingTank.c"
				}
#line 55 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp2_ = _source_it;
#line 55 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp3_ = gee_iterator_get (_tmp2_);
#line 55 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				source = (DataSource*) _tmp3_;
#line 56 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp4_ = source;
#line 56 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				data_source_notify_held_in_tank (_tmp4_, self);
#line 55 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_g_object_unref0 (source);
#line 490 "SourceHoldingTank.c"
			}
#line 55 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_g_object_unref0 (_source_it);
#line 494 "SourceHoldingTank.c"
		}
	}
#line 59 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (removed != NULL) {
#line 499 "SourceHoldingTank.c"
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp5_;
#line 60 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_ITERABLE, GeeIterable));
#line 60 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_source_it = _tmp5_;
#line 60 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			while (TRUE) {
#line 509 "SourceHoldingTank.c"
				GeeIterator* _tmp6_;
				DataSource* source = NULL;
				GeeIterator* _tmp7_;
				gpointer _tmp8_;
				DataSource* _tmp9_;
#line 60 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp6_ = _source_it;
#line 60 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				if (!gee_iterator_next (_tmp6_)) {
#line 60 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
					break;
#line 521 "SourceHoldingTank.c"
				}
#line 60 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp7_ = _source_it;
#line 60 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp8_ = gee_iterator_get (_tmp7_);
#line 60 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				source = (DataSource*) _tmp8_;
#line 61 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp9_ = source;
#line 61 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				data_source_notify_held_in_tank (_tmp9_, NULL);
#line 60 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_g_object_unref0 (source);
#line 535 "SourceHoldingTank.c"
			}
#line 60 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_g_object_unref0 (_source_it);
#line 539 "SourceHoldingTank.c"
		}
	}
#line 64 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_signal_emit (self, source_holding_tank_signals[SOURCE_HOLDING_TANK_CONTENTS_ALTERED_SIGNAL], 0, added, removed);
#line 544 "SourceHoldingTank.c"
}


void
source_holding_tank_notify_contents_altered (SourceHoldingTank* self,
                                             GeeCollection* added,
                                             GeeCollection* removed)
{
#line 52 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail (IS_SOURCE_HOLDING_TANK (self));
#line 52 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	SOURCE_HOLDING_TANK_GET_CLASS (self)->notify_contents_altered (self, added, removed);
#line 557 "SourceHoldingTank.c"
}


gint
source_holding_tank_get_count (SourceHoldingTank* self)
{
	gint result = 0;
	DataSet* _tmp0_;
#line 67 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_val_if_fail (IS_SOURCE_HOLDING_TANK (self), 0);
#line 68 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp0_ = self->priv->tank;
#line 68 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	result = data_set_get_count (_tmp0_);
#line 68 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	return result;
#line 574 "SourceHoldingTank.c"
}


GeeCollection*
source_holding_tank_get_all (SourceHoldingTank* self)
{
	GeeCollection* result = NULL;
	DataSet* _tmp0_;
	GeeList* _tmp1_;
#line 71 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_val_if_fail (IS_SOURCE_HOLDING_TANK (self), NULL);
#line 72 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp0_ = self->priv->tank;
#line 72 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp1_ = data_set_get_all (_tmp0_);
#line 72 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection);
#line 72 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	return result;
#line 594 "SourceHoldingTank.c"
}


gboolean
source_holding_tank_contains (SourceHoldingTank* self,
                              DataSource* source)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	DataSet* _tmp1_;
#line 75 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_val_if_fail (IS_SOURCE_HOLDING_TANK (self), FALSE);
#line 75 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
#line 76 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp1_ = self->priv->tank;
#line 76 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (data_set_contains (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject))) {
#line 76 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		_tmp0_ = TRUE;
#line 615 "SourceHoldingTank.c"
	} else {
		GeeHashSet* _tmp2_;
#line 76 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		_tmp2_ = self->priv->unlinking;
#line 76 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		_tmp0_ = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), source);
#line 622 "SourceHoldingTank.c"
	}
#line 76 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	result = _tmp0_;
#line 76 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	return result;
#line 628 "SourceHoldingTank.c"
}


void
source_holding_tank_add_many (SourceHoldingTank* self,
                              GeeCollection* many)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean added = FALSE;
	DataSet* _tmp8_;
	gboolean _tmp9_;
#line 80 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail (IS_SOURCE_HOLDING_TANK (self));
#line 80 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail (GEE_IS_COLLECTION (many));
#line 81 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp0_ = gee_collection_get_size (many);
#line 81 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp1_ = _tmp0_;
#line 81 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (_tmp1_ == 0) {
#line 82 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		return;
#line 653 "SourceHoldingTank.c"
	}
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp2_;
#line 84 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (many, GEE_TYPE_ITERABLE, GeeIterable));
#line 84 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		_source_it = _tmp2_;
#line 84 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		while (TRUE) {
#line 664 "SourceHoldingTank.c"
			GeeIterator* _tmp3_;
			DataSource* source = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			DataSource* _tmp6_;
			gint64 _tmp7_;
#line 84 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_tmp3_ = _source_it;
#line 84 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			if (!gee_iterator_next (_tmp3_)) {
#line 84 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				break;
#line 677 "SourceHoldingTank.c"
			}
#line 84 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_tmp4_ = _source_it;
#line 84 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 84 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			source = (DataSource*) _tmp5_;
#line 85 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_tmp6_ = source;
#line 85 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_tmp7_ = self->priv->ordinal;
#line 85 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			self->priv->ordinal = _tmp7_ + 1;
#line 85 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			data_object_internal_set_ordinal (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_OBJECT, DataObject), _tmp7_);
#line 84 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_g_object_unref0 (source);
#line 695 "SourceHoldingTank.c"
		}
#line 84 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		_g_object_unref0 (_source_it);
#line 699 "SourceHoldingTank.c"
	}
#line 87 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp8_ = self->priv->tank;
#line 87 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	added = data_set_add_many (_tmp8_, many);
#line 88 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp9_ = added;
#line 88 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_vala_assert (_tmp9_, "added");
#line 90 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	source_holding_tank_notify_contents_altered (self, many, NULL);
#line 711 "SourceHoldingTank.c"
}


void
source_holding_tank_unlink_and_hold (SourceHoldingTank* self,
                                     GeeCollection* unlink)
{
	gint _tmp0_;
	gint _tmp1_;
	GeeHashSet* _tmp2_;
	SourceCollection* _tmp3_;
	SourceCollection* _tmp4_;
	Marker* _tmp5_;
	Marker* _tmp6_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	gboolean added = FALSE;
	DataSet* _tmp15_;
	gboolean _tmp16_;
	GeeHashSet* _tmp17_;
#line 95 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail (IS_SOURCE_HOLDING_TANK (self));
#line 95 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail (GEE_IS_COLLECTION (unlink));
#line 96 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp0_ = gee_collection_get_size (unlink);
#line 96 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp1_ = _tmp0_;
#line 96 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (_tmp1_ == 0) {
#line 97 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		return;
#line 744 "SourceHoldingTank.c"
	}
#line 100 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp2_ = self->priv->unlinking;
#line 100 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection), unlink);
#line 102 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp3_ = self->priv->sources;
#line 102 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp4_ = self->priv->sources;
#line 102 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp5_ = data_collection_mark_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_COLLECTION, DataCollection), unlink);
#line 102 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp6_ = _tmp5_;
#line 102 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp7_ = source_collection_unlink_marked (_tmp3_, _tmp6_, NULL, NULL);
#line 102 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp8_ = _tmp7_;
#line 102 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_g_object_unref0 (_tmp8_);
#line 102 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_g_object_unref0 (_tmp6_);
#line 766 "SourceHoldingTank.c"
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp9_;
#line 104 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (unlink, GEE_TYPE_ITERABLE, GeeIterable));
#line 104 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		_source_it = _tmp9_;
#line 104 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		while (TRUE) {
#line 776 "SourceHoldingTank.c"
			GeeIterator* _tmp10_;
			DataSource* source = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			DataSource* _tmp13_;
			gint64 _tmp14_;
#line 104 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_tmp10_ = _source_it;
#line 104 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			if (!gee_iterator_next (_tmp10_)) {
#line 104 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				break;
#line 789 "SourceHoldingTank.c"
			}
#line 104 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_tmp11_ = _source_it;
#line 104 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_tmp12_ = gee_iterator_get (_tmp11_);
#line 104 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			source = (DataSource*) _tmp12_;
#line 105 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_tmp13_ = source;
#line 105 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_tmp14_ = self->priv->ordinal;
#line 105 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			self->priv->ordinal = _tmp14_ + 1;
#line 105 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			data_object_internal_set_ordinal (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_OBJECT, DataObject), _tmp14_);
#line 104 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_g_object_unref0 (source);
#line 807 "SourceHoldingTank.c"
		}
#line 104 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		_g_object_unref0 (_source_it);
#line 811 "SourceHoldingTank.c"
	}
#line 107 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp15_ = self->priv->tank;
#line 107 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	added = data_set_add_many (_tmp15_, unlink);
#line 108 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp16_ = added;
#line 108 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_vala_assert (_tmp16_, "added");
#line 111 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp17_ = self->priv->unlinking;
#line 111 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	gee_collection_remove_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection), unlink);
#line 113 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	source_holding_tank_notify_contents_altered (self, unlink, NULL);
#line 827 "SourceHoldingTank.c"
}


gboolean
source_holding_tank_has_backlink (SourceHoldingTank* self,
                                  SourceBacklink* backlink)
{
	gboolean result = FALSE;
	gint count = 0;
	DataSet* _tmp0_;
#line 116 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_val_if_fail (IS_SOURCE_HOLDING_TANK (self), FALSE);
#line 116 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_val_if_fail (IS_SOURCE_BACKLINK (backlink), FALSE);
#line 117 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp0_ = self->priv->tank;
#line 117 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	count = data_set_get_count (_tmp0_);
#line 846 "SourceHoldingTank.c"
	{
		gint ctr = 0;
#line 118 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		ctr = 0;
#line 851 "SourceHoldingTank.c"
		{
			gboolean _tmp1_ = FALSE;
#line 118 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_tmp1_ = TRUE;
#line 118 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			while (TRUE) {
#line 858 "SourceHoldingTank.c"
				gint _tmp3_;
				gint _tmp4_;
				DataSet* _tmp5_;
				gint _tmp6_;
				DataObject* _tmp7_;
				DataSource* _tmp8_;
				gboolean _tmp9_;
#line 118 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				if (!_tmp1_) {
#line 868 "SourceHoldingTank.c"
					gint _tmp2_;
#line 118 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
					_tmp2_ = ctr;
#line 118 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
					ctr = _tmp2_ + 1;
#line 874 "SourceHoldingTank.c"
				}
#line 118 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp1_ = FALSE;
#line 118 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp3_ = ctr;
#line 118 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp4_ = count;
#line 118 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				if (!(_tmp3_ < _tmp4_)) {
#line 118 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
					break;
#line 886 "SourceHoldingTank.c"
				}
#line 119 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp5_ = self->priv->tank;
#line 119 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp6_ = ctr;
#line 119 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp7_ = data_set_get_at (_tmp5_, _tmp6_);
#line 119 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_SOURCE, DataSource);
#line 119 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp9_ = data_source_has_backlink (_tmp8_, backlink);
#line 119 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_g_object_unref0 (_tmp8_);
#line 119 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				if (_tmp9_) {
#line 120 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
					result = TRUE;
#line 120 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
					return result;
#line 906 "SourceHoldingTank.c"
				}
			}
		}
	}
#line 123 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	result = FALSE;
#line 123 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	return result;
#line 915 "SourceHoldingTank.c"
}


void
source_holding_tank_remove_backlink (SourceHoldingTank* self,
                                     SourceBacklink* backlink)
{
	gint count = 0;
	DataSet* _tmp0_;
#line 126 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail (IS_SOURCE_HOLDING_TANK (self));
#line 126 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
#line 127 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp0_ = self->priv->tank;
#line 127 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	count = data_set_get_count (_tmp0_);
#line 933 "SourceHoldingTank.c"
	{
		gint ctr = 0;
#line 128 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		ctr = 0;
#line 938 "SourceHoldingTank.c"
		{
			gboolean _tmp1_ = FALSE;
#line 128 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_tmp1_ = TRUE;
#line 128 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			while (TRUE) {
#line 945 "SourceHoldingTank.c"
				gint _tmp3_;
				gint _tmp4_;
				DataSet* _tmp5_;
				gint _tmp6_;
				DataObject* _tmp7_;
				DataSource* _tmp8_;
#line 128 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				if (!_tmp1_) {
#line 954 "SourceHoldingTank.c"
					gint _tmp2_;
#line 128 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
					_tmp2_ = ctr;
#line 128 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
					ctr = _tmp2_ + 1;
#line 960 "SourceHoldingTank.c"
				}
#line 128 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp1_ = FALSE;
#line 128 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp3_ = ctr;
#line 128 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp4_ = count;
#line 128 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				if (!(_tmp3_ < _tmp4_)) {
#line 128 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
					break;
#line 972 "SourceHoldingTank.c"
				}
#line 129 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp5_ = self->priv->tank;
#line 129 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp6_ = ctr;
#line 129 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp7_ = data_set_get_at (_tmp5_, _tmp6_);
#line 129 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_SOURCE, DataSource);
#line 129 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				data_source_remove_backlink (_tmp8_, backlink);
#line 129 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_g_object_unref0 (_tmp8_);
#line 986 "SourceHoldingTank.c"
			}
		}
	}
}


void
source_holding_tank_destroy_orphans (SourceHoldingTank* self,
                                     GeeList* destroy,
                                     gboolean delete_backing,
                                     ProgressMonitor monitor,
                                     void* monitor_target,
                                     GeeList* not_removed)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean removed = FALSE;
	DataSet* _tmp2_;
	gboolean _tmp3_;
	gint count = 0;
	gint _tmp4_;
	gint _tmp5_;
#line 132 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail (IS_SOURCE_HOLDING_TANK (self));
#line 132 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail (GEE_IS_LIST (destroy));
#line 132 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail ((not_removed == NULL) || GEE_IS_LIST (not_removed));
#line 134 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp0_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (destroy, GEE_TYPE_COLLECTION, GeeCollection));
#line 134 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp1_ = _tmp0_;
#line 134 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (_tmp1_ == 0) {
#line 135 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		return;
#line 1023 "SourceHoldingTank.c"
	}
#line 137 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp2_ = self->priv->tank;
#line 137 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	removed = data_set_remove_many (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (destroy, GEE_TYPE_COLLECTION, GeeCollection));
#line 138 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp3_ = removed;
#line 138 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_vala_assert (_tmp3_, "removed");
#line 140 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	source_holding_tank_notify_contents_altered (self, NULL, G_TYPE_CHECK_INSTANCE_CAST (destroy, GEE_TYPE_COLLECTION, GeeCollection));
#line 142 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (destroy, GEE_TYPE_COLLECTION, GeeCollection));
#line 142 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp5_ = _tmp4_;
#line 142 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	count = _tmp5_;
#line 1041 "SourceHoldingTank.c"
	{
		gint ctr = 0;
#line 143 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		ctr = 0;
#line 1046 "SourceHoldingTank.c"
		{
			gboolean _tmp6_ = FALSE;
#line 143 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			_tmp6_ = TRUE;
#line 143 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			while (TRUE) {
#line 1053 "SourceHoldingTank.c"
				gint _tmp8_;
				gint _tmp9_;
				DataSource* source = NULL;
				gint _tmp10_;
				gpointer _tmp11_;
				DataSource* _tmp12_;
#line 143 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				if (!_tmp6_) {
#line 1062 "SourceHoldingTank.c"
					gint _tmp7_;
#line 143 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
					_tmp7_ = ctr;
#line 143 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
					ctr = _tmp7_ + 1;
#line 1068 "SourceHoldingTank.c"
				}
#line 143 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp6_ = FALSE;
#line 143 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp8_ = ctr;
#line 143 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp9_ = count;
#line 143 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				if (!(_tmp8_ < _tmp9_)) {
#line 143 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
					break;
#line 1080 "SourceHoldingTank.c"
				}
#line 144 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp10_ = ctr;
#line 144 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp11_ = gee_list_get (destroy, _tmp10_);
#line 144 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				source = (DataSource*) _tmp11_;
#line 145 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_tmp12_ = source;
#line 145 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				if (!data_source_destroy_orphan (_tmp12_, delete_backing)) {
#line 146 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
					if (NULL != not_removed) {
#line 1094 "SourceHoldingTank.c"
						DataSource* _tmp13_;
#line 147 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
						_tmp13_ = source;
#line 147 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
						gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (not_removed, GEE_TYPE_COLLECTION, GeeCollection), _tmp13_);
#line 1100 "SourceHoldingTank.c"
					}
				}
#line 150 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				if (monitor != NULL) {
#line 1105 "SourceHoldingTank.c"
					gint _tmp14_;
					gint _tmp15_;
#line 151 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
					_tmp14_ = ctr;
#line 151 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
					_tmp15_ = count;
#line 151 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
					monitor ((guint64) (_tmp14_ + 1), (guint64) _tmp15_, TRUE, monitor_target);
#line 1114 "SourceHoldingTank.c"
				}
#line 143 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
				_g_object_unref0 (source);
#line 1118 "SourceHoldingTank.c"
			}
		}
	}
}


static void
source_holding_tank_on_source_destroyed (SourceHoldingTank* self,
                                         DataSource* source)
{
	DataSet* _tmp0_;
	gboolean removed = FALSE;
	DataSet* _tmp1_;
	gboolean _tmp2_;
	SingletonCollection* _tmp3_;
	SingletonCollection* _tmp4_;
#line 155 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail (IS_SOURCE_HOLDING_TANK (self));
#line 155 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 156 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp0_ = self->priv->tank;
#line 156 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (!data_set_contains (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject))) {
#line 157 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		return;
#line 1145 "SourceHoldingTank.c"
	}
#line 159 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp1_ = self->priv->tank;
#line 159 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	removed = data_set_remove (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject));
#line 160 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp2_ = removed;
#line 160 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_vala_assert (_tmp2_, "removed");
#line 162 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp3_ = singleton_collection_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, source);
#line 162 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp4_ = _tmp3_;
#line 162 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	source_holding_tank_notify_contents_altered (self, NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
#line 162 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_g_object_unref0 (_tmp4_);
#line 1163 "SourceHoldingTank.c"
}


void
source_holding_tank_internal_notify_altered (SourceHoldingTank* self,
                                             DataSource* source,
                                             Alteration* alteration)
{
	DataSet* _tmp0_;
	SourceHoldingTankCheckToKeep _tmp5_;
	void* _tmp5__target;
	gboolean removed = FALSE;
	DataSet* _tmp6_;
	gboolean _tmp7_;
	SourceCollection* _tmp8_;
	SingletonCollection* _tmp10_;
	SingletonCollection* _tmp11_;
	SourceCollection* _tmp12_;
#line 166 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail (IS_SOURCE_HOLDING_TANK (self));
#line 166 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 166 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail (IS_ALTERATION (alteration));
#line 167 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp0_ = self->priv->tank;
#line 167 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (!data_set_contains (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject))) {
#line 1192 "SourceHoldingTank.c"
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 168 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		_tmp1_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject));
#line 168 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		_tmp2_ = _tmp1_;
#line 168 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		_tmp3_ = source_holding_tank_to_string (self);
#line 168 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		_tmp4_ = _tmp3_;
#line 168 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		g_debug ("SourceHoldingTank.vala:168: SourceHoldingTank.internal_notify_altered " \
"called for %s not stored in %s", _tmp2_, _tmp4_);
#line 168 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		_g_free0 (_tmp4_);
#line 168 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		_g_free0 (_tmp2_);
#line 171 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		return;
#line 1213 "SourceHoldingTank.c"
	}
#line 175 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp5_ = self->priv->check_to_keep;
#line 175 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp5__target = self->priv->check_to_keep_target;
#line 175 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (_tmp5_ (source, alteration, _tmp5__target)) {
#line 176 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		return;
#line 1223 "SourceHoldingTank.c"
	}
#line 178 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp6_ = self->priv->tank;
#line 178 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	removed = data_set_remove (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject));
#line 179 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp7_ = removed;
#line 179 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_vala_assert (_tmp7_, "removed");
#line 181 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp8_ = self->priv->sources;
#line 181 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (data_collection_are_notifications_frozen (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection))) {
#line 1237 "SourceHoldingTank.c"
		GeeHashSet* _tmp9_;
#line 182 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		_tmp9_ = self->priv->relinks;
#line 182 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), source);
#line 184 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		return;
#line 1245 "SourceHoldingTank.c"
	}
#line 187 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp10_ = singleton_collection_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, source);
#line 187 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp11_ = _tmp10_;
#line 187 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	source_holding_tank_notify_contents_altered (self, NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection));
#line 187 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_g_object_unref0 (_tmp11_);
#line 189 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp12_ = self->priv->sources;
#line 189 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	source_collection_relink (_tmp12_, source);
#line 1259 "SourceHoldingTank.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 197 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	return self ? g_object_ref (self) : NULL;
#line 1268 "SourceHoldingTank.c"
}


static void
source_holding_tank_on_source_collection_thawed (SourceHoldingTank* self)
{
	GeeHashSet* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeHashSet* copy = NULL;
	GeeHashSet* _tmp3_;
	GeeHashSet* _tmp4_;
	GeeHashSet* _tmp5_;
	GeeHashSet* _tmp6_;
	SourceCollection* _tmp7_;
	GeeHashSet* _tmp8_;
#line 192 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail (IS_SOURCE_HOLDING_TANK (self));
#line 193 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp0_ = self->priv->relinks;
#line 193 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 193 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp2_ = _tmp1_;
#line 193 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (_tmp2_ == 0) {
#line 194 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		return;
#line 1297 "SourceHoldingTank.c"
	}
#line 197 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp3_ = self->priv->relinks;
#line 197 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 197 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	copy = _tmp4_;
#line 198 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp5_ = gee_hash_set_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 198 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_g_object_unref0 (self->priv->relinks);
#line 198 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	self->priv->relinks = _tmp5_;
#line 200 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp6_ = copy;
#line 200 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	source_holding_tank_notify_contents_altered (self, NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
#line 202 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp7_ = self->priv->sources;
#line 202 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp8_ = copy;
#line 202 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	source_collection_relink_many (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
#line 192 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_g_object_unref0 (copy);
#line 1323 "SourceHoldingTank.c"
}


gchar*
source_holding_tank_to_string (SourceHoldingTank* self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 205 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_val_if_fail (IS_SOURCE_HOLDING_TANK (self), NULL);
#line 206 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp0_ = g_strdup_printf ("SourceHoldingTank @ 0x%p", self);
#line 206 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	result = _tmp0_;
#line 206 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	return result;
#line 1340 "SourceHoldingTank.c"
}


static void
source_holding_tank_real_contents_altered (SourceHoldingTank* self,
                                           GeeCollection* added,
                                           GeeCollection* removed)
{
#line 35 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_COLLECTION (added));
#line 35 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_COLLECTION (removed));
#line 1353 "SourceHoldingTank.c"
}


static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail (n_param_values == 3);
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		data1 = closure->data;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		data2 = param_values->data[0].v_pointer;
#line 1379 "SourceHoldingTank.c"
	} else {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		data1 = param_values->data[0].v_pointer;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		data2 = closure->data;
#line 1385 "SourceHoldingTank.c"
	}
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
#line 1391 "SourceHoldingTank.c"
}


static void
value_source_holding_tank_init (GValue* value)
{
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	value->data[0].v_pointer = NULL;
#line 1400 "SourceHoldingTank.c"
}


static void
value_source_holding_tank_free_value (GValue* value)
{
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (value->data[0].v_pointer) {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		source_holding_tank_unref (value->data[0].v_pointer);
#line 1411 "SourceHoldingTank.c"
	}
}


static void
value_source_holding_tank_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (src_value->data[0].v_pointer) {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		dest_value->data[0].v_pointer = source_holding_tank_ref (src_value->data[0].v_pointer);
#line 1424 "SourceHoldingTank.c"
	} else {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1428 "SourceHoldingTank.c"
	}
}


static gpointer
value_source_holding_tank_peek_pointer (const GValue* value)
{
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	return value->data[0].v_pointer;
#line 1438 "SourceHoldingTank.c"
}


static gchar*
value_source_holding_tank_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (collect_values[0].v_pointer) {
#line 1450 "SourceHoldingTank.c"
		SourceHoldingTank * object;
		object = collect_values[0].v_pointer;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		if (object->parent_instance.g_class == NULL) {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1457 "SourceHoldingTank.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1461 "SourceHoldingTank.c"
		}
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		value->data[0].v_pointer = source_holding_tank_ref (object);
#line 1465 "SourceHoldingTank.c"
	} else {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		value->data[0].v_pointer = NULL;
#line 1469 "SourceHoldingTank.c"
	}
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	return NULL;
#line 1473 "SourceHoldingTank.c"
}


static gchar*
value_source_holding_tank_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	SourceHoldingTank ** object_p;
	object_p = collect_values[0].v_pointer;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (!object_p) {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1489 "SourceHoldingTank.c"
	}
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (!value->data[0].v_pointer) {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		*object_p = NULL;
#line 1495 "SourceHoldingTank.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		*object_p = value->data[0].v_pointer;
#line 1499 "SourceHoldingTank.c"
	} else {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		*object_p = source_holding_tank_ref (value->data[0].v_pointer);
#line 1503 "SourceHoldingTank.c"
	}
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	return NULL;
#line 1507 "SourceHoldingTank.c"
}


GParamSpec*
param_spec_source_holding_tank (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecSourceHoldingTank* spec;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SOURCE_HOLDING_TANK), NULL);
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	return G_PARAM_SPEC (spec);
#line 1527 "SourceHoldingTank.c"
}


gpointer
value_get_source_holding_tank (const GValue* value)
{
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_HOLDING_TANK), NULL);
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	return value->data[0].v_pointer;
#line 1538 "SourceHoldingTank.c"
}


void
value_set_source_holding_tank (GValue* value,
                               gpointer v_object)
{
	SourceHoldingTank * old;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_HOLDING_TANK));
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	old = value->data[0].v_pointer;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (v_object) {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_HOLDING_TANK));
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		value->data[0].v_pointer = v_object;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		source_holding_tank_ref (value->data[0].v_pointer);
#line 1561 "SourceHoldingTank.c"
	} else {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		value->data[0].v_pointer = NULL;
#line 1565 "SourceHoldingTank.c"
	}
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (old) {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		source_holding_tank_unref (old);
#line 1571 "SourceHoldingTank.c"
	}
}


void
value_take_source_holding_tank (GValue* value,
                                gpointer v_object)
{
	SourceHoldingTank * old;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_HOLDING_TANK));
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	old = value->data[0].v_pointer;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (v_object) {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_HOLDING_TANK));
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		value->data[0].v_pointer = v_object;
#line 1593 "SourceHoldingTank.c"
	} else {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		value->data[0].v_pointer = NULL;
#line 1597 "SourceHoldingTank.c"
	}
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (old) {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		source_holding_tank_unref (old);
#line 1603 "SourceHoldingTank.c"
	}
}


static void
source_holding_tank_class_init (SourceHoldingTankClass * klass)
{
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	source_holding_tank_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	((SourceHoldingTankClass *) klass)->finalize = source_holding_tank_finalize;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_type_class_add_private (klass, sizeof (SourceHoldingTankPrivate));
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	((SourceHoldingTankClass *) klass)->notify_contents_altered = (void (*) (SourceHoldingTank *, GeeCollection*, GeeCollection*)) source_holding_tank_real_notify_contents_altered;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	((SourceHoldingTankClass *) klass)->contents_altered = source_holding_tank_real_contents_altered;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	source_holding_tank_signals[SOURCE_HOLDING_TANK_CONTENTS_ALTERED_SIGNAL] = g_signal_new ("contents-altered", TYPE_SOURCE_HOLDING_TANK, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceHoldingTankClass, contents_altered), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEE_TYPE_COLLECTION, GEE_TYPE_COLLECTION);
#line 1623 "SourceHoldingTank.c"
}


static void
source_holding_tank_instance_init (SourceHoldingTank * self)
{
	DataSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp2_;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	self->priv = SOURCE_HOLDING_TANK_GET_PRIVATE (self);
#line 30 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp0_ = data_set_new ();
#line 30 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	self->priv->tank = _tmp0_;
#line 31 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp1_ = gee_hash_set_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 31 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	self->priv->relinks = _tmp1_;
#line 32 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp2_ = gee_hash_set_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 32 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	self->priv->unlinking = _tmp2_;
#line 33 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	self->priv->ordinal = (gint64) 0;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	self->ref_count = 1;
#line 1651 "SourceHoldingTank.c"
}


static void
source_holding_tank_finalize (SourceHoldingTank * obj)
{
	SourceHoldingTank * self;
	SourceCollection* _tmp0_;
	guint _tmp1_;
	SourceCollection* _tmp2_;
	guint _tmp3_;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank);
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_signal_handlers_destroy (self);
#line 48 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp0_ = self->priv->sources;
#line 48 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp1_, NULL, FALSE);
#line 48 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _source_holding_tank_on_source_destroyed_source_collection_item_destroyed, self);
#line 49 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_tmp2_ = self->priv->sources;
#line 49 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_signal_parse_name ("thawed", TYPE_DATA_COLLECTION, &_tmp3_, NULL, FALSE);
#line 49 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _source_holding_tank_on_source_collection_thawed_data_collection_thawed, self);
#line 28 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_data_collection_unref0 (self->priv->sources);
#line 30 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_data_set_unref0 (self->priv->tank);
#line 31 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_g_object_unref0 (self->priv->relinks);
#line 32 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	_g_object_unref0 (self->priv->unlinking);
#line 1687 "SourceHoldingTank.c"
}


GType
source_holding_tank_get_type (void)
{
	static volatile gsize source_holding_tank_type_id__volatile = 0;
	if (g_once_init_enter (&source_holding_tank_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_source_holding_tank_init, value_source_holding_tank_free_value, value_source_holding_tank_copy_value, value_source_holding_tank_peek_pointer, "p", value_source_holding_tank_collect_value, "p", value_source_holding_tank_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SourceHoldingTankClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_holding_tank_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceHoldingTank), 0, (GInstanceInitFunc) source_holding_tank_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType source_holding_tank_type_id;
		source_holding_tank_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SourceHoldingTank", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&source_holding_tank_type_id__volatile, source_holding_tank_type_id);
	}
	return source_holding_tank_type_id__volatile;
}


gpointer
source_holding_tank_ref (gpointer instance)
{
	SourceHoldingTank * self;
	self = instance;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	g_atomic_int_inc (&self->ref_count);
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	return instance;
#line 1716 "SourceHoldingTank.c"
}


void
source_holding_tank_unref (gpointer instance)
{
	SourceHoldingTank * self;
	self = instance;
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		SOURCE_HOLDING_TANK_GET_CLASS (self)->finalize (self);
#line 24 "/home/jens/Source/shotwell/src/core/SourceHoldingTank.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1731 "SourceHoldingTank.c"
	}
}



