/* file.c generated by valac 0.40.4, the Vala compiler
 * generated from file.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* Returns true if the file is claimed, false if it exists, and throws an Error otherwise.  The file*/
/* will be created when the function exits and should be overwritten.  Note that the file is not*/
/* held open; claiming a file is merely based on its existence.*/
/**/
/* This function is thread-safe.*/


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <time.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);


gboolean claim_file (GFile* file,
                     GError** error);
GFile* generate_unique_file (GFile* dir,
                             const gchar* basename,
                             gboolean* collision,
                             GError** error);
void disassemble_filename (const gchar* basename,
                           gchar* * name,
                           gchar* * ext);
glong find_last_offset (const gchar* str,
                        gchar c);
guint64 query_total_file_size (GFile* file_or_dir,
                               GCancellable* cancellable,
                               GError** error);
void delete_all_files (GFile* dir,
                       GeeSet* exceptions,
                       ProgressMonitor monitor,
                       void* monitor_target,
                       guint64 file_count,
                       GCancellable* cancellable,
                       GError** error);
time_t query_file_modified (GFile* file,
                            GError** error);
gboolean query_is_directory (GFile* file);
gboolean query_is_directory_empty (GFile* dir,
                                   GError** error);
gchar* get_display_pathname (GFile* file);
gchar* strip_pretty_path (const gchar* path);
gchar* get_file_info_id (GFileInfo* info);
void skip_uint64 (GInputStream* input,
                  guint64 skip_amount,
                  GError** error);
guint64 count_files_in_directory (GFile* dir,
                                  GError** error);
gboolean file_equal (GFile* a,
                     GFile* b);
guint file_hash (GFile* file);


static gpointer
_g_error_copy0 (gpointer self)
{
#line 23 "/home/jens/Source/shotwell/src/util/file.vala"
	return self ? g_error_copy (self) : NULL;
#line 76 "file.c"
}


gboolean
claim_file (GFile* file,
            GError** error)
{
	gboolean result = FALSE;
	gboolean _tmp9_ = FALSE;
	GError * _inner_error_ = NULL;
#line 12 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 89 "file.c"
	{
		GFileOutputStream* _tmp0_;
		GFileOutputStream* _tmp1_;
#line 14 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp0_ = g_file_create (file, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 14 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp1_ = _tmp0_;
#line 14 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (_tmp1_);
#line 14 "/home/jens/Source/shotwell/src/util/file.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 101 "file.c"
			goto __catch0_g_error;
		}
#line 17 "/home/jens/Source/shotwell/src/util/file.vala"
		result = TRUE;
#line 17 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 108 "file.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
#line 13 "/home/jens/Source/shotwell/src/util/file.vala"
		err = _inner_error_;
#line 13 "/home/jens/Source/shotwell/src/util/file.vala"
		_inner_error_ = NULL;
#line 20 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp2_ = err;
#line 20 "/home/jens/Source/shotwell/src/util/file.vala"
		if (!g_error_matches (_tmp2_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
#line 123 "file.c"
			gchar* _tmp3_;
			gchar* _tmp4_;
			GError* _tmp5_;
			const gchar* _tmp6_;
			GError* _tmp7_;
			GError* _tmp8_;
#line 21 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp3_ = g_file_get_path (file);
#line 21 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp4_ = _tmp3_;
#line 21 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp5_ = err;
#line 21 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp6_ = _tmp5_->message;
#line 21 "/home/jens/Source/shotwell/src/util/file.vala"
			g_warning ("file.vala:21: claim_file %s: %s", _tmp4_, _tmp6_);
#line 21 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_free0 (_tmp4_);
#line 23 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp7_ = err;
#line 23 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp8_ = _g_error_copy0 (_tmp7_);
#line 23 "/home/jens/Source/shotwell/src/util/file.vala"
			_inner_error_ = _tmp8_;
#line 23 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_error_free0 (err);
#line 150 "file.c"
			goto __finally0;
		}
#line 26 "/home/jens/Source/shotwell/src/util/file.vala"
		result = FALSE;
#line 26 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_error_free0 (err);
#line 26 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 159 "file.c"
	}
	__finally0:
#line 13 "/home/jens/Source/shotwell/src/util/file.vala"
	g_propagate_error (error, _inner_error_);
#line 13 "/home/jens/Source/shotwell/src/util/file.vala"
	return _tmp9_;
#line 166 "file.c"
}


GFile*
generate_unique_file (GFile* dir,
                      const gchar* basename,
                      gboolean* collision,
                      GError** error)
{
	gboolean _vala_collision = FALSE;
	GFile* result = NULL;
	GFile* file = NULL;
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GFile* _tmp2_;
	gchar* name = NULL;
	gchar* ext = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GError * _inner_error_ = NULL;
#line 36 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (G_IS_FILE (dir), NULL);
#line 36 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (basename != NULL, NULL);
#line 38 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = g_file_get_child (dir, basename);
#line 38 "/home/jens/Source/shotwell/src/util/file.vala"
	file = _tmp0_;
#line 39 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp2_ = file;
#line 39 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp1_ = claim_file (_tmp2_, &_inner_error_);
#line 39 "/home/jens/Source/shotwell/src/util/file.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 39 "/home/jens/Source/shotwell/src/util/file.vala"
		g_propagate_error (error, _inner_error_);
#line 39 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (file);
#line 39 "/home/jens/Source/shotwell/src/util/file.vala"
		return NULL;
#line 209 "file.c"
	}
#line 39 "/home/jens/Source/shotwell/src/util/file.vala"
	if (_tmp1_) {
#line 40 "/home/jens/Source/shotwell/src/util/file.vala"
		_vala_collision = FALSE;
#line 42 "/home/jens/Source/shotwell/src/util/file.vala"
		result = file;
#line 42 "/home/jens/Source/shotwell/src/util/file.vala"
		if (collision) {
#line 42 "/home/jens/Source/shotwell/src/util/file.vala"
			*collision = _vala_collision;
#line 221 "file.c"
		}
#line 42 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 225 "file.c"
	}
#line 46 "/home/jens/Source/shotwell/src/util/file.vala"
	_vala_collision = TRUE;
#line 49 "/home/jens/Source/shotwell/src/util/file.vala"
	disassemble_filename (basename, &_tmp3_, &_tmp4_);
#line 49 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_free0 (name);
#line 49 "/home/jens/Source/shotwell/src/util/file.vala"
	name = _tmp3_;
#line 49 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_free0 (ext);
#line 49 "/home/jens/Source/shotwell/src/util/file.vala"
	ext = _tmp4_;
#line 239 "file.c"
	{
		gint ctr = 0;
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
		ctr = 1;
#line 244 "file.c"
		{
			gboolean _tmp5_ = FALSE;
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp5_ = TRUE;
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
			while (TRUE) {
#line 251 "file.c"
				gint _tmp7_;
				gchar* _tmp8_ = NULL;
				const gchar* _tmp9_;
				gchar* new_name = NULL;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				GFile* _tmp19_;
				gboolean _tmp20_ = FALSE;
				GFile* _tmp21_;
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
				if (!_tmp5_) {
#line 263 "file.c"
					gint _tmp6_;
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp6_ = ctr;
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
					ctr = _tmp6_ + 1;
#line 269 "file.c"
				}
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp5_ = FALSE;
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp7_ = ctr;
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
				if (!(_tmp7_ < G_MAXINT)) {
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
					break;
#line 279 "file.c"
				}
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp9_ = ext;
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
				if (_tmp9_ != NULL) {
#line 285 "file.c"
					const gchar* _tmp10_;
					gint _tmp11_;
					const gchar* _tmp12_;
					gchar* _tmp13_;
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp10_ = name;
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp11_ = ctr;
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp12_ = ext;
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp13_ = g_strdup_printf ("%s_%d.%s", _tmp10_, _tmp11_, _tmp12_);
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (_tmp8_);
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp8_ = _tmp13_;
#line 302 "file.c"
				} else {
					const gchar* _tmp14_;
					gint _tmp15_;
					gchar* _tmp16_;
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp14_ = name;
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp15_ = ctr;
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp16_ = g_strdup_printf ("%s_%d", _tmp14_, _tmp15_);
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (_tmp8_);
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp8_ = _tmp16_;
#line 317 "file.c"
				}
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp17_ = g_strdup (_tmp8_);
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
				new_name = _tmp17_;
#line 55 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp18_ = new_name;
#line 55 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp19_ = g_file_get_child (dir, _tmp18_);
#line 55 "/home/jens/Source/shotwell/src/util/file.vala"
				_g_object_unref0 (file);
#line 55 "/home/jens/Source/shotwell/src/util/file.vala"
				file = _tmp19_;
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp21_ = file;
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp20_ = claim_file (_tmp21_, &_inner_error_);
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
					g_propagate_error (error, _inner_error_);
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (new_name);
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (_tmp8_);
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (ext);
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (name);
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_object_unref0 (file);
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
					return NULL;
#line 351 "file.c"
				}
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
				if (_tmp20_) {
#line 57 "/home/jens/Source/shotwell/src/util/file.vala"
					result = file;
#line 57 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (new_name);
#line 57 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (_tmp8_);
#line 57 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (ext);
#line 57 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (name);
#line 57 "/home/jens/Source/shotwell/src/util/file.vala"
					if (collision) {
#line 57 "/home/jens/Source/shotwell/src/util/file.vala"
						*collision = _vala_collision;
#line 369 "file.c"
					}
#line 57 "/home/jens/Source/shotwell/src/util/file.vala"
					return result;
#line 373 "file.c"
				}
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
				_g_free0 (new_name);
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
				_g_free0 (_tmp8_);
#line 379 "file.c"
			}
		}
	}
#line 60 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp22_ = g_file_get_path (dir);
#line 60 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp23_ = _tmp22_;
#line 60 "/home/jens/Source/shotwell/src/util/file.vala"
	g_warning ("file.vala:60: generate_unique_filename %s for %s: unable to claim file", _tmp23_, basename);
#line 60 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_free0 (_tmp23_);
#line 62 "/home/jens/Source/shotwell/src/util/file.vala"
	result = NULL;
#line 62 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_free0 (ext);
#line 62 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_free0 (name);
#line 62 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (file);
#line 62 "/home/jens/Source/shotwell/src/util/file.vala"
	if (collision) {
#line 62 "/home/jens/Source/shotwell/src/util/file.vala"
		*collision = _vala_collision;
#line 403 "file.c"
	}
#line 62 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 407 "file.c"
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	end = _tmp0_;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = end;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = maxlen;
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 431 "file.c"
	} else {
		gchar* _tmp2_;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = end;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 440 "file.c"
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
#line 1347 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 461 "file.c"
	} else {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 465 "file.c"
	}
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1351 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 471 "file.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 481 "file.c"
	}
#line 1356 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 485 "file.c"
		glong _tmp3_;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		offset = _tmp3_ + offset;
#line 1358 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 493 "file.c"
	} else {
		glong _tmp4_;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = string_length;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset <= _tmp4_, NULL);
#line 500 "file.c"
	}
#line 1362 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 504 "file.c"
		glong _tmp5_;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		len = _tmp5_ - offset;
#line 510 "file.c"
	}
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp6_ = string_length;
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 522 "file.c"
}


void
disassemble_filename (const gchar* basename,
                      gchar* * name,
                      gchar* * ext)
{
	gchar* _vala_name = NULL;
	gchar* _vala_ext = NULL;
	glong offset = 0L;
	glong _tmp0_;
#line 65 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_if_fail (basename != NULL);
#line 66 "/home/jens/Source/shotwell/src/util/file.vala"
	offset = find_last_offset (basename, '.');
#line 67 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = offset;
#line 67 "/home/jens/Source/shotwell/src/util/file.vala"
	if (_tmp0_ <= ((glong) 0)) {
#line 543 "file.c"
		gchar* _tmp1_;
#line 68 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp1_ = g_strdup (basename);
#line 68 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (_vala_name);
#line 68 "/home/jens/Source/shotwell/src/util/file.vala"
		_vala_name = _tmp1_;
#line 69 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (_vala_ext);
#line 69 "/home/jens/Source/shotwell/src/util/file.vala"
		_vala_ext = NULL;
#line 555 "file.c"
	} else {
		glong _tmp2_;
		gchar* _tmp3_;
		glong _tmp4_;
		gchar* _tmp5_;
#line 71 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp2_ = offset;
#line 71 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp3_ = string_substring (basename, (glong) 0, _tmp2_);
#line 71 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (_vala_name);
#line 71 "/home/jens/Source/shotwell/src/util/file.vala"
		_vala_name = _tmp3_;
#line 72 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp4_ = offset;
#line 72 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp5_ = string_substring (basename, _tmp4_ + 1, (glong) -1);
#line 72 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (_vala_ext);
#line 72 "/home/jens/Source/shotwell/src/util/file.vala"
		_vala_ext = _tmp5_;
#line 577 "file.c"
	}
#line 65 "/home/jens/Source/shotwell/src/util/file.vala"
	if (name) {
#line 65 "/home/jens/Source/shotwell/src/util/file.vala"
		*name = _vala_name;
#line 583 "file.c"
	} else {
#line 65 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (_vala_name);
#line 587 "file.c"
	}
#line 65 "/home/jens/Source/shotwell/src/util/file.vala"
	if (ext) {
#line 65 "/home/jens/Source/shotwell/src/util/file.vala"
		*ext = _vala_ext;
#line 593 "file.c"
	} else {
#line 65 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (_vala_ext);
#line 597 "file.c"
	}
}


guint64
query_total_file_size (GFile* file_or_dir,
                       GCancellable* cancellable,
                       GError** error)
{
	guint64 result = 0ULL;
	GFileType type = 0;
	GFileType _tmp0_;
	GFileEnumerator* enumerator = NULL;
	guint64 total_bytes = 0ULL;
	GFileInfo* info = NULL;
	GError * _inner_error_ = NULL;
#line 77 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (G_IS_FILE (file_or_dir), 0ULL);
#line 77 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable), 0ULL);
#line 78 "/home/jens/Source/shotwell/src/util/file.vala"
	type = g_file_query_file_type (file_or_dir, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL);
#line 79 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = type;
#line 79 "/home/jens/Source/shotwell/src/util/file.vala"
	if (_tmp0_ == G_FILE_TYPE_REGULAR) {
#line 624 "file.c"
		GFileInfo* info = NULL;
		GFileInfo* _tmp12_;
#line 80 "/home/jens/Source/shotwell/src/util/file.vala"
		info = NULL;
#line 629 "file.c"
		{
			GFileInfo* _tmp1_ = NULL;
			GFileInfo* _tmp2_;
			GFileInfo* _tmp3_;
#line 82 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp2_ = g_file_query_info (file_or_dir, G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, cancellable, &_inner_error_);
#line 82 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp1_ = _tmp2_;
#line 82 "/home/jens/Source/shotwell/src/util/file.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 640 "file.c"
				goto __catch1_g_error;
			}
#line 82 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp3_ = _tmp1_;
#line 82 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp1_ = NULL;
#line 82 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (info);
#line 82 "/home/jens/Source/shotwell/src/util/file.vala"
			info = _tmp3_;
#line 81 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (_tmp1_);
#line 653 "file.c"
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			GError* _tmp4_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			GError* _tmp9_;
			const gchar* _tmp10_;
#line 81 "/home/jens/Source/shotwell/src/util/file.vala"
			err = _inner_error_;
#line 81 "/home/jens/Source/shotwell/src/util/file.vala"
			_inner_error_ = NULL;
#line 85 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp4_ = err;
#line 85 "/home/jens/Source/shotwell/src/util/file.vala"
			if (g_error_matches (_tmp4_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
#line 672 "file.c"
				GError* _tmp5_;
				GError* _tmp6_;
#line 86 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp5_ = err;
#line 86 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp6_ = _g_error_copy0 (_tmp5_);
#line 86 "/home/jens/Source/shotwell/src/util/file.vala"
				_inner_error_ = _tmp6_;
#line 86 "/home/jens/Source/shotwell/src/util/file.vala"
				_g_error_free0 (err);
#line 683 "file.c"
				goto __finally1;
			}
#line 88 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp7_ = g_file_get_path (file_or_dir);
#line 88 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp8_ = _tmp7_;
#line 88 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp9_ = err;
#line 88 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp10_ = _tmp9_->message;
#line 88 "/home/jens/Source/shotwell/src/util/file.vala"
			g_debug ("file.vala:88: Unable to query filesize for %s: %s", _tmp8_, _tmp10_);
#line 88 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_free0 (_tmp8_);
#line 90 "/home/jens/Source/shotwell/src/util/file.vala"
			result = (guint64) 0;
#line 90 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_error_free0 (err);
#line 90 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (info);
#line 90 "/home/jens/Source/shotwell/src/util/file.vala"
			return result;
#line 706 "file.c"
		}
		__finally1:
#line 81 "/home/jens/Source/shotwell/src/util/file.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 711 "file.c"
			guint64 _tmp11_ = 0ULL;
#line 81 "/home/jens/Source/shotwell/src/util/file.vala"
			g_propagate_error (error, _inner_error_);
#line 81 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (info);
#line 81 "/home/jens/Source/shotwell/src/util/file.vala"
			return _tmp11_;
#line 719 "file.c"
		}
#line 93 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp12_ = info;
#line 93 "/home/jens/Source/shotwell/src/util/file.vala"
		result = (guint64) g_file_info_get_size (_tmp12_);
#line 93 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (info);
#line 93 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 729 "file.c"
	} else {
		GFileType _tmp13_;
#line 94 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp13_ = type;
#line 94 "/home/jens/Source/shotwell/src/util/file.vala"
		if (_tmp13_ != G_FILE_TYPE_DIRECTORY) {
#line 95 "/home/jens/Source/shotwell/src/util/file.vala"
			result = (guint64) 0;
#line 95 "/home/jens/Source/shotwell/src/util/file.vala"
			return result;
#line 740 "file.c"
		}
	}
	{
		GFileEnumerator* _tmp14_ = NULL;
		GFileEnumerator* _tmp15_;
		GFileEnumerator* _tmp16_;
		GFileEnumerator* _tmp17_;
#line 100 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp15_ = g_file_enumerate_children (file_or_dir, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, cancellable, &_inner_error_);
#line 100 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp14_ = _tmp15_;
#line 100 "/home/jens/Source/shotwell/src/util/file.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 754 "file.c"
			goto __catch2_g_error;
		}
#line 100 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp16_ = _tmp14_;
#line 100 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp14_ = NULL;
#line 100 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (enumerator);
#line 100 "/home/jens/Source/shotwell/src/util/file.vala"
		enumerator = _tmp16_;
#line 102 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp17_ = enumerator;
#line 102 "/home/jens/Source/shotwell/src/util/file.vala"
		if (_tmp17_ == NULL) {
#line 103 "/home/jens/Source/shotwell/src/util/file.vala"
			result = (guint64) 0;
#line 103 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (_tmp14_);
#line 103 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (enumerator);
#line 103 "/home/jens/Source/shotwell/src/util/file.vala"
			return result;
#line 777 "file.c"
		}
#line 99 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (_tmp14_);
#line 781 "file.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		gboolean _tmp18_ = FALSE;
		GError* _tmp19_;
		GError* _tmp21_;
		GError* _tmp22_;
#line 99 "/home/jens/Source/shotwell/src/util/file.vala"
		err = _inner_error_;
#line 99 "/home/jens/Source/shotwell/src/util/file.vala"
		_inner_error_ = NULL;
#line 106 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp19_ = err;
#line 106 "/home/jens/Source/shotwell/src/util/file.vala"
		if (g_error_matches (_tmp19_, G_FILE_ERROR, G_FILE_ERROR_PERM)) {
#line 106 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp18_ = TRUE;
#line 801 "file.c"
		} else {
			GError* _tmp20_;
#line 106 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp20_ = err;
#line 106 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp18_ = g_error_matches (_tmp20_, G_IO_ERROR, G_IO_ERROR_PERMISSION_DENIED);
#line 808 "file.c"
		}
#line 106 "/home/jens/Source/shotwell/src/util/file.vala"
		if (_tmp18_) {
#line 107 "/home/jens/Source/shotwell/src/util/file.vala"
			result = (guint64) 0;
#line 107 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_error_free0 (err);
#line 107 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (enumerator);
#line 107 "/home/jens/Source/shotwell/src/util/file.vala"
			return result;
#line 820 "file.c"
		}
#line 109 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp21_ = err;
#line 109 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp22_ = _g_error_copy0 (_tmp21_);
#line 109 "/home/jens/Source/shotwell/src/util/file.vala"
		_inner_error_ = _tmp22_;
#line 109 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_error_free0 (err);
#line 830 "file.c"
		goto __finally2;
	}
	__finally2:
#line 99 "/home/jens/Source/shotwell/src/util/file.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 836 "file.c"
		guint64 _tmp23_ = 0ULL;
#line 99 "/home/jens/Source/shotwell/src/util/file.vala"
		g_propagate_error (error, _inner_error_);
#line 99 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (enumerator);
#line 99 "/home/jens/Source/shotwell/src/util/file.vala"
		return _tmp23_;
#line 844 "file.c"
	}
#line 112 "/home/jens/Source/shotwell/src/util/file.vala"
	total_bytes = (guint64) 0;
#line 114 "/home/jens/Source/shotwell/src/util/file.vala"
	info = NULL;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
	while (TRUE) {
#line 852 "file.c"
		GFileInfo* _tmp24_ = NULL;
		GFileEnumerator* _tmp25_;
		GFileInfo* _tmp26_;
		GFileInfo* _tmp28_;
		GFileInfo* _tmp29_;
		guint64 _tmp30_ = 0ULL;
		GFileInfo* _tmp31_;
		const gchar* _tmp32_;
		GFile* _tmp33_;
		GFile* _tmp34_;
		guint64 _tmp35_;
		guint64 _tmp37_;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp25_ = enumerator;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp26_ = g_file_enumerator_next_file (_tmp25_, cancellable, &_inner_error_);
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp24_ = _tmp26_;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 873 "file.c"
			guint64 _tmp27_ = 0ULL;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
			g_propagate_error (error, _inner_error_);
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (info);
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (enumerator);
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
			return _tmp27_;
#line 883 "file.c"
		}
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp28_ = _tmp24_;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp24_ = NULL;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (info);
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		info = _tmp28_;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp29_ = info;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		if (!(_tmp29_ != NULL)) {
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (_tmp24_);
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
			break;
#line 901 "file.c"
		}
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp31_ = info;
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp32_ = g_file_info_get_name (_tmp31_);
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp33_ = g_file_get_child (file_or_dir, _tmp32_);
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp34_ = _tmp33_;
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp35_ = query_total_file_size (_tmp34_, cancellable, &_inner_error_);
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (_tmp34_);
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp30_ = _tmp35_;
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 919 "file.c"
			guint64 _tmp36_ = 0ULL;
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
			g_propagate_error (error, _inner_error_);
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (_tmp24_);
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (info);
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (enumerator);
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
			return _tmp36_;
#line 931 "file.c"
		}
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp37_ = total_bytes;
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		total_bytes = _tmp37_ + _tmp30_;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (_tmp24_);
#line 939 "file.c"
	}
#line 118 "/home/jens/Source/shotwell/src/util/file.vala"
	result = total_bytes;
#line 118 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (info);
#line 118 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (enumerator);
#line 118 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 949 "file.c"
}


void
delete_all_files (GFile* dir,
                  GeeSet* exceptions,
                  ProgressMonitor monitor,
                  void* monitor_target,
                  guint64 file_count,
                  GCancellable* cancellable,
                  GError** error)
{
	GFileType type = 0;
	GFileType _tmp0_;
	GFileEnumerator* enumerator = NULL;
	GFileEnumerator* _tmp7_;
	GFileInfo* info = NULL;
	guint64 i = 0ULL;
	GError * _inner_error_ = NULL;
#line 125 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 125 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_if_fail ((exceptions == NULL) || GEE_IS_SET (exceptions));
#line 125 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable));
#line 127 "/home/jens/Source/shotwell/src/util/file.vala"
	type = g_file_query_file_type (dir, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL);
#line 128 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = type;
#line 128 "/home/jens/Source/shotwell/src/util/file.vala"
	if (_tmp0_ != G_FILE_TYPE_DIRECTORY) {
#line 981 "file.c"
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		GError* _tmp6_;
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp1_ = g_file_get_path (dir);
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp2_ = _tmp1_;
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp3_ = g_strdup_printf ("%s is not a directory", _tmp2_);
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp4_ = _tmp3_;
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp5_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_DIRECTORY, _tmp4_);
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp6_ = _tmp5_;
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (_tmp4_);
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (_tmp2_);
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_inner_error_ = _tmp6_;
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		g_propagate_error (error, _inner_error_);
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		return;
#line 1010 "file.c"
	}
#line 131 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp7_ = g_file_enumerate_children (dir, "standard::name,standard::type", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, cancellable, &_inner_error_);
#line 131 "/home/jens/Source/shotwell/src/util/file.vala"
	enumerator = _tmp7_;
#line 131 "/home/jens/Source/shotwell/src/util/file.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 131 "/home/jens/Source/shotwell/src/util/file.vala"
		g_propagate_error (error, _inner_error_);
#line 131 "/home/jens/Source/shotwell/src/util/file.vala"
		return;
#line 1022 "file.c"
	}
#line 133 "/home/jens/Source/shotwell/src/util/file.vala"
	info = NULL;
#line 134 "/home/jens/Source/shotwell/src/util/file.vala"
	i = (guint64) 0;
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
	while (TRUE) {
#line 1030 "file.c"
		GFileInfo* _tmp8_ = NULL;
		GFileEnumerator* _tmp9_;
		GFileInfo* _tmp10_;
		GFileInfo* _tmp11_;
		GFileInfo* _tmp12_;
		GFileInfo* _tmp13_;
		gboolean _tmp14_ = FALSE;
		GFile* file = NULL;
		GFileInfo* _tmp17_;
		const gchar* _tmp18_;
		GFile* _tmp19_;
		gboolean _tmp26_ = FALSE;
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp9_ = enumerator;
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp10_ = g_file_enumerator_next_file (_tmp9_, cancellable, &_inner_error_);
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp8_ = _tmp10_;
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
			g_propagate_error (error, _inner_error_);
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (info);
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (enumerator);
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
			return;
#line 1059 "file.c"
		}
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp11_ = _tmp8_;
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp8_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (info);
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		info = _tmp11_;
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp12_ = info;
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		if (!(_tmp12_ != NULL)) {
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (_tmp8_);
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
			break;
#line 1077 "file.c"
		}
#line 136 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp13_ = info;
#line 136 "/home/jens/Source/shotwell/src/util/file.vala"
		if (g_file_info_get_file_type (_tmp13_) != G_FILE_TYPE_REGULAR) {
#line 137 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (_tmp8_);
#line 137 "/home/jens/Source/shotwell/src/util/file.vala"
			continue;
#line 1087 "file.c"
		}
#line 139 "/home/jens/Source/shotwell/src/util/file.vala"
		if (exceptions != NULL) {
#line 1091 "file.c"
			GFileInfo* _tmp15_;
			const gchar* _tmp16_;
#line 139 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp15_ = info;
#line 139 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp16_ = g_file_info_get_name (_tmp15_);
#line 139 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp14_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (exceptions, GEE_TYPE_COLLECTION, GeeCollection), _tmp16_);
#line 1100 "file.c"
		} else {
#line 139 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp14_ = FALSE;
#line 1104 "file.c"
		}
#line 139 "/home/jens/Source/shotwell/src/util/file.vala"
		if (_tmp14_) {
#line 140 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (_tmp8_);
#line 140 "/home/jens/Source/shotwell/src/util/file.vala"
			continue;
#line 1112 "file.c"
		}
#line 142 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp17_ = info;
#line 142 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp18_ = g_file_info_get_name (_tmp17_);
#line 142 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp19_ = g_file_get_child (dir, _tmp18_);
#line 142 "/home/jens/Source/shotwell/src/util/file.vala"
		file = _tmp19_;
#line 1122 "file.c"
		{
			GFile* _tmp20_;
#line 144 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp20_ = file;
#line 144 "/home/jens/Source/shotwell/src/util/file.vala"
			g_file_delete (_tmp20_, cancellable, &_inner_error_);
#line 144 "/home/jens/Source/shotwell/src/util/file.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1131 "file.c"
				goto __catch3_g_error;
			}
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* err = NULL;
			GFile* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			GError* _tmp24_;
			const gchar* _tmp25_;
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
			err = _inner_error_;
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
			_inner_error_ = NULL;
#line 146 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp21_ = file;
#line 146 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp22_ = g_file_get_path (_tmp21_);
#line 146 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp23_ = _tmp22_;
#line 146 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp24_ = err;
#line 146 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp25_ = _tmp24_->message;
#line 146 "/home/jens/Source/shotwell/src/util/file.vala"
			g_warning ("file.vala:146: Unable to delete file %s: %s", _tmp23_, _tmp25_);
#line 146 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_free0 (_tmp23_);
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_error_free0 (err);
#line 1164 "file.c"
		}
		__finally3:
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
			g_propagate_error (error, _inner_error_);
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (file);
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (_tmp8_);
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (info);
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (enumerator);
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
			return;
#line 1181 "file.c"
		}
#line 149 "/home/jens/Source/shotwell/src/util/file.vala"
		if (monitor != NULL) {
#line 149 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp26_ = file_count > ((guint64) 0);
#line 1187 "file.c"
		} else {
#line 149 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp26_ = FALSE;
#line 1191 "file.c"
		}
#line 149 "/home/jens/Source/shotwell/src/util/file.vala"
		if (_tmp26_) {
#line 1195 "file.c"
			guint64 _tmp27_;
			guint64 _tmp28_;
#line 150 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp27_ = i;
#line 150 "/home/jens/Source/shotwell/src/util/file.vala"
			i = _tmp27_ + 1;
#line 150 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp28_ = i;
#line 150 "/home/jens/Source/shotwell/src/util/file.vala"
			monitor (file_count, _tmp28_, TRUE, monitor_target);
#line 1206 "file.c"
		}
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (file);
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (_tmp8_);
#line 1212 "file.c"
	}
#line 125 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (info);
#line 125 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (enumerator);
#line 1218 "file.c"
}


time_t
query_file_modified (GFile* file,
                     GError** error)
{
	time_t result = 0;
	GFileInfo* info = NULL;
	GFileInfo* _tmp0_;
	GTimeVal _tmp2_ = {0};
	glong _tmp3_;
	GError * _inner_error_ = NULL;
#line 154 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (G_IS_FILE (file), 0);
#line 155 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = g_file_query_info (file, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 155 "/home/jens/Source/shotwell/src/util/file.vala"
	info = _tmp0_;
#line 155 "/home/jens/Source/shotwell/src/util/file.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1240 "file.c"
		time_t _tmp1_ = 0;
#line 155 "/home/jens/Source/shotwell/src/util/file.vala"
		g_propagate_error (error, _inner_error_);
#line 155 "/home/jens/Source/shotwell/src/util/file.vala"
		return _tmp1_;
#line 1246 "file.c"
	}
#line 158 "/home/jens/Source/shotwell/src/util/file.vala"
	g_file_info_get_modification_time (info, &_tmp2_);
#line 158 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp3_ = _tmp2_.tv_sec;
#line 158 "/home/jens/Source/shotwell/src/util/file.vala"
	result = (time_t) _tmp3_;
#line 158 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (info);
#line 158 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1258 "file.c"
}


gboolean
query_is_directory (GFile* file)
{
	gboolean result = FALSE;
#line 161 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 162 "/home/jens/Source/shotwell/src/util/file.vala"
	result = g_file_query_file_type (file, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL) == G_FILE_TYPE_DIRECTORY;
#line 162 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1272 "file.c"
}


gboolean
query_is_directory_empty (GFile* dir,
                          GError** error)
{
	gboolean result = FALSE;
	GFileEnumerator* enumerator = NULL;
	GFileEnumerator* _tmp0_;
	GFileEnumerator* _tmp2_;
	GFileInfo* _tmp3_ = NULL;
	GFileEnumerator* _tmp4_;
	GFileInfo* _tmp5_;
	GError * _inner_error_ = NULL;
#line 165 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (G_IS_FILE (dir), FALSE);
#line 166 "/home/jens/Source/shotwell/src/util/file.vala"
	if (g_file_query_file_type (dir, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL) != G_FILE_TYPE_DIRECTORY) {
#line 167 "/home/jens/Source/shotwell/src/util/file.vala"
		result = FALSE;
#line 167 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 1296 "file.c"
	}
#line 169 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = g_file_enumerate_children (dir, "standard::name", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 169 "/home/jens/Source/shotwell/src/util/file.vala"
	enumerator = _tmp0_;
#line 169 "/home/jens/Source/shotwell/src/util/file.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1304 "file.c"
		gboolean _tmp1_ = FALSE;
#line 169 "/home/jens/Source/shotwell/src/util/file.vala"
		g_propagate_error (error, _inner_error_);
#line 169 "/home/jens/Source/shotwell/src/util/file.vala"
		return _tmp1_;
#line 1310 "file.c"
	}
#line 171 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp2_ = enumerator;
#line 171 "/home/jens/Source/shotwell/src/util/file.vala"
	if (_tmp2_ == NULL) {
#line 172 "/home/jens/Source/shotwell/src/util/file.vala"
		result = FALSE;
#line 172 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (enumerator);
#line 172 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 1322 "file.c"
	}
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp4_ = enumerator;
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp5_ = g_file_enumerator_next_file (_tmp4_, NULL, &_inner_error_);
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp3_ = _tmp5_;
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1332 "file.c"
		gboolean _tmp6_ = FALSE;
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
		g_propagate_error (error, _inner_error_);
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (enumerator);
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
		return _tmp6_;
#line 1340 "file.c"
	}
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	result = _tmp3_ == NULL;
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (_tmp3_);
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (enumerator);
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1350 "file.c"
}


gchar*
get_display_pathname (GFile* file)
{
	gchar* result = NULL;
	gchar* path = NULL;
	gchar* _tmp0_;
	gchar* home = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
#line 177 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 179 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = g_file_get_parse_name (file);
#line 179 "/home/jens/Source/shotwell/src/util/file.vala"
	path = _tmp0_;
#line 180 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp1_ = g_get_home_dir ();
#line 180 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 180 "/home/jens/Source/shotwell/src/util/file.vala"
	home = _tmp2_;
#line 182 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp3_ = path;
#line 182 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp4_ = home;
#line 182 "/home/jens/Source/shotwell/src/util/file.vala"
	if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
#line 1385 "file.c"
		gchar* _tmp5_;
#line 183 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp5_ = g_strdup ("~");
#line 183 "/home/jens/Source/shotwell/src/util/file.vala"
		result = _tmp5_;
#line 183 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (home);
#line 183 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (path);
#line 183 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 1397 "file.c"
	}
#line 185 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp6_ = path;
#line 185 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp7_ = home;
#line 185 "/home/jens/Source/shotwell/src/util/file.vala"
	if (g_str_has_prefix (_tmp6_, _tmp7_)) {
#line 1405 "file.c"
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp8_ = path;
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp9_ = home;
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp10_ = strlen (_tmp9_);
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp11_ = _tmp10_;
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp12_ = string_substring (_tmp8_, (glong) _tmp11_, (glong) -1);
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp13_ = _tmp12_;
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp14_ = g_strdup_printf ("~%s", _tmp13_);
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp15_ = _tmp14_;
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (_tmp13_);
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		result = _tmp15_;
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (home);
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (path);
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 1440 "file.c"
	}
#line 188 "/home/jens/Source/shotwell/src/util/file.vala"
	result = path;
#line 188 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_free0 (home);
#line 188 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1448 "file.c"
}


gchar*
strip_pretty_path (const gchar* path)
{
	gchar* result = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
#line 191 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 192 "/home/jens/Source/shotwell/src/util/file.vala"
	if (!g_str_has_prefix (path, "~")) {
#line 1465 "file.c"
		gchar* _tmp0_;
#line 193 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp0_ = g_strdup (path);
#line 193 "/home/jens/Source/shotwell/src/util/file.vala"
		result = _tmp0_;
#line 193 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 1473 "file.c"
	}
#line 195 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp1_ = g_get_home_dir ();
#line 195 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp2_ = string_substring (path, (glong) 1, (glong) -1);
#line 195 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp3_ = _tmp2_;
#line 195 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
#line 195 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp5_ = _tmp4_;
#line 195 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_free0 (_tmp3_);
#line 195 "/home/jens/Source/shotwell/src/util/file.vala"
	result = _tmp5_;
#line 195 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1491 "file.c"
}


gchar*
get_file_info_id (GFileInfo* info)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 198 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), NULL);
#line 199 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = g_file_info_get_attribute_string (info, G_FILE_ATTRIBUTE_ID_FILE);
#line 199 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 199 "/home/jens/Source/shotwell/src/util/file.vala"
	result = _tmp1_;
#line 199 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1511 "file.c"
}


void
skip_uint64 (GInputStream* input,
             guint64 skip_amount,
             GError** error)
{
	GError * _inner_error_ = NULL;
#line 203 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_if_fail (G_IS_INPUT_STREAM (input));
#line 204 "/home/jens/Source/shotwell/src/util/file.vala"
	while (TRUE) {
#line 204 "/home/jens/Source/shotwell/src/util/file.vala"
		if (!(skip_amount > ((guint64) 0))) {
#line 204 "/home/jens/Source/shotwell/src/util/file.vala"
			break;
#line 1529 "file.c"
		}
#line 206 "/home/jens/Source/shotwell/src/util/file.vala"
		if (skip_amount >= ((guint64) G_MAXSSIZE)) {
#line 207 "/home/jens/Source/shotwell/src/util/file.vala"
			g_input_stream_skip (input, (gsize) G_MAXSSIZE, NULL, &_inner_error_);
#line 207 "/home/jens/Source/shotwell/src/util/file.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 207 "/home/jens/Source/shotwell/src/util/file.vala"
				g_propagate_error (error, _inner_error_);
#line 207 "/home/jens/Source/shotwell/src/util/file.vala"
				return;
#line 1541 "file.c"
			}
#line 208 "/home/jens/Source/shotwell/src/util/file.vala"
			skip_amount = skip_amount - G_MAXSSIZE;
#line 1545 "file.c"
		} else {
#line 210 "/home/jens/Source/shotwell/src/util/file.vala"
			g_input_stream_skip (input, (gsize) skip_amount, NULL, &_inner_error_);
#line 210 "/home/jens/Source/shotwell/src/util/file.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 210 "/home/jens/Source/shotwell/src/util/file.vala"
				g_propagate_error (error, _inner_error_);
#line 210 "/home/jens/Source/shotwell/src/util/file.vala"
				return;
#line 1555 "file.c"
			}
#line 211 "/home/jens/Source/shotwell/src/util/file.vala"
			skip_amount = (guint64) 0;
#line 1559 "file.c"
		}
	}
}


guint64
count_files_in_directory (GFile* dir,
                          GError** error)
{
	guint64 result = 0ULL;
	guint64 count = 0ULL;
	GFileEnumerator* enumerator = NULL;
	GFileEnumerator* _tmp0_;
	GFileInfo* info = NULL;
	GError * _inner_error_ = NULL;
#line 217 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (G_IS_FILE (dir), 0ULL);
#line 218 "/home/jens/Source/shotwell/src/util/file.vala"
	if (!query_is_directory (dir)) {
#line 219 "/home/jens/Source/shotwell/src/util/file.vala"
		result = (guint64) 0;
#line 219 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 1583 "file.c"
	}
#line 221 "/home/jens/Source/shotwell/src/util/file.vala"
	count = (guint64) 0;
#line 222 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = g_file_enumerate_children (dir, "standard::*", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 222 "/home/jens/Source/shotwell/src/util/file.vala"
	enumerator = _tmp0_;
#line 222 "/home/jens/Source/shotwell/src/util/file.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1593 "file.c"
		guint64 _tmp1_ = 0ULL;
#line 222 "/home/jens/Source/shotwell/src/util/file.vala"
		g_propagate_error (error, _inner_error_);
#line 222 "/home/jens/Source/shotwell/src/util/file.vala"
		return _tmp1_;
#line 1599 "file.c"
	}
#line 225 "/home/jens/Source/shotwell/src/util/file.vala"
	info = NULL;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
	while (TRUE) {
#line 1605 "file.c"
		GFileInfo* _tmp2_ = NULL;
		GFileEnumerator* _tmp3_;
		GFileInfo* _tmp4_;
		GFileInfo* _tmp6_;
		GFileInfo* _tmp7_;
		guint64 _tmp8_;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp3_ = enumerator;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp4_ = g_file_enumerator_next_file (_tmp3_, NULL, &_inner_error_);
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp2_ = _tmp4_;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1620 "file.c"
			guint64 _tmp5_ = 0ULL;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
			g_propagate_error (error, _inner_error_);
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (info);
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (enumerator);
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
			return _tmp5_;
#line 1630 "file.c"
		}
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp6_ = _tmp2_;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp2_ = NULL;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (info);
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		info = _tmp6_;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp7_ = info;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		if (!(_tmp7_ != NULL)) {
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (_tmp2_);
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
			break;
#line 1648 "file.c"
		}
#line 227 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp8_ = count;
#line 227 "/home/jens/Source/shotwell/src/util/file.vala"
		count = _tmp8_ + 1;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (_tmp2_);
#line 1656 "file.c"
	}
#line 229 "/home/jens/Source/shotwell/src/util/file.vala"
	result = count;
#line 229 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (info);
#line 229 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (enumerator);
#line 229 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1666 "file.c"
}


gboolean
file_equal (GFile* a,
            GFile* b)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 233 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail ((a == NULL) || G_IS_FILE (a), FALSE);
#line 233 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail ((b == NULL) || G_IS_FILE (b), FALSE);
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
	if (a != NULL) {
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp1_ = b != NULL;
#line 1685 "file.c"
	} else {
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp1_ = FALSE;
#line 1689 "file.c"
	}
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
	if (_tmp1_) {
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp0_ = g_file_equal (a, b);
#line 1695 "file.c"
	} else {
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp0_ = FALSE;
#line 1699 "file.c"
	}
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
	result = _tmp0_;
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1705 "file.c"
}


guint
file_hash (GFile* file)
{
	guint result = 0U;
	guint _tmp0_ = 0U;
#line 238 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), 0U);
#line 239 "/home/jens/Source/shotwell/src/util/file.vala"
	if (file != NULL) {
#line 239 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp0_ = g_file_hash (file);
#line 1720 "file.c"
	} else {
#line 239 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp0_ = (guint) 0;
#line 1724 "file.c"
	}
#line 239 "/home/jens/Source/shotwell/src/util/file.vala"
	result = _tmp0_;
#line 239 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1730 "file.c"
}



