/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ContCodestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.FragmentInputStream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.FragmentListBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;

public class FragmentTableBox
extends JP2Box {
    public FragmentTableBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        boolean bl = true;
        this.initBytesRead();
        this.hasBoxes = true;
        JP2Box jP2Box = (JP2Box)this.next();
        if (jP2Box == null) {
            return false;
        }
        if (jP2Box instanceof FragmentListBox) {
            FragmentListBox fragmentListBox = (FragmentListBox)jP2Box;
            if (!fragmentListBox.readBox()) {
                return false;
            }
            List list = fragmentListBox.getFragmentList();
            if (list != null) {
                JhoveBase jhoveBase = this._module.getBase();
                int n = jhoveBase.getBufferSize();
                FragmentInputStream fragmentInputStream = new FragmentInputStream(list, this._raf, n);
                DataInputStream dataInputStream = new DataInputStream(fragmentInputStream);
                int n2 = this._module.getNCodestreams() + 1;
                this._module.setNCodestreams(n2);
                Codestream codestream = this._module.getCodestream(n2);
                long l = this._boxHeader.getLength() == 0L ? 0L : this._boxHeader.getDataLength();
                ContCodestream contCodestream = new ContCodestream(this._module, dataInputStream, l);
                bl = contCodestream.readCodestream(codestream, this._repInfo);
            }
        } else {
            this._repInfo.setMessage((Message)new ErrorMessage("Invalid fragment table", this._module.getFilePos()));
            this._repInfo.setWellFormed(false);
            return false;
        }
        this.finalizeBytesRead();
        return bl;
    }

    @Override
    protected String getSelfPropName() {
        return "Fragment Table Box";
    }
}

