/*###############################################################################
# Linux Management Providers (LMP), Sensors provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_RegisteredSensorsProfileAccess.h"

const string InstanceID="OpenDRIM:Sensors:1.0.2";

int Sensors_OpenDRIM_RegisteredSensorsProfile_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int Sensors_OpenDRIM_RegisteredSensorsProfile_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int Sensors_OpenDRIM_RegisteredSensorsProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RegisteredSensorsProfile>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_RegisteredSensorsProfile instance;
	instance.setInstanceID(InstanceID);
	
	if(discriminant=="ei")
		CF_assert(Sensors_OpenDRIM_RegisteredSensorsProfile_populate(instance,errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int Sensors_OpenDRIM_RegisteredSensorsProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RegisteredSensorsProfile& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.InstanceID!=InstanceID)
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}
	
	CF_assert(Sensors_OpenDRIM_RegisteredSensorsProfile_populate(instance,errorMessage));
	_L_;
	return OK;
}

int Sensors_OpenDRIM_RegisteredSensorsProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSensorsProfile& newInstance, const OpenDRIM_RegisteredSensorsProfile& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_RegisteredSensorsProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSensorsProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_RegisteredSensorsProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSensorsProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_RegisteredSensorsProfile_populate(OpenDRIM_RegisteredSensorsProfile& instance, string& errorMessage) {
	_E_;
	vector<unsigned short> AdvertiseTypes;

	instance.setRegisteredName("Sensors");
	instance.setRegisteredVersion("1.0.2");
	instance.setRegisteredOrganization(2);	// DMTF

	AdvertiseTypes.push_back(2);			// Not Advertised
	instance.setAdvertiseTypes(AdvertiseTypes);
	_L_;
	return OK;
}

