# Copyright 2014 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

# This file is meant to be included into an action to provide a rule that
# inserts a chromium version string into native libraries.
#
# To use this, create a gyp target with the following form:
#  {
#    'action_name': 'insert_chromium_version',
#    'actions': [
#      'variables': {
#        'ordered_libraries_file': 'file generated by write_ordered_libraries'
#        'stripped_libraries_dir': 'the directory contains native libraries'
#        'input_paths': 'files to be added to the list of inputs'
#        'stamp': 'file to touch when the action is complete'
#        'version_string': 'chromium version string to be inserted'
#      'includes': [ '../../build/android/insert_chromium_version.gypi' ],
#    ],
#  },
#

{
  'message': 'Inserting chromium version string into native libraries',
  'variables': {
    'input_paths': [],
  },
  'inputs': [
    '<(DEPTH)/build/android/gyp/util/build_utils.py',
    '<(DEPTH)/build/android/gyp/insert_chromium_version.py',
    '<(ordered_libraries_file)',
    '>@(input_paths)',
  ],
  'outputs': [
    '<(stamp)',
  ],
  'action': [
    'python', '<(DEPTH)/build/android/gyp/insert_chromium_version.py',
    '--android-objcopy=<(android_objcopy)',
    '--stripped-libraries-dir=<(stripped_libraries_dir)',
    '--libraries=@FileArg(<(ordered_libraries_file):libraries)',
    '--version-string=<(version_string)',
    '--stamp=<(stamp)',
  ],
  'conditions': [
    ['component == "shared_library"', {
      # Add a fake output to force the build to always re-run this step. This
      # is required because the real inputs are not known at gyp-time and
      # changing base.so may not trigger changes to dependent libraries.
      'outputs': [ '<(stamp).fake' ]
    }],
  ],
}
