#ifndef _KIFU_ANALIZER_H
#define _KIFU_ANALIZER_H
#include "osl/game_playing/alphaBetaPlayer.h"
#include "osl/game_playing/gameState.h"

#include "osl/state/simpleState.h"
#include "osl/stl/vector.h"
#include <qdialog.h>
#include <Q3ListView>
#include <boost/scoped_ptr.hpp>

class AnalyzeThread;
class EvaluationGraph;
class QLabel;

struct Result
{
  Result(osl::Move move, osl::Move computed_move,
         int value, int depth, const osl::container::MoveVector moves)
    : move(move), computed_move(computed_move),
      value(value), depth(depth), pvs(moves) {
  }
  osl::Move move;
  osl::Move computed_move;
  int value;
  int depth;
  osl::container::MoveVector pvs;
};

class KifuAnalyzer : public QDialog
{
public:
  KifuAnalyzer(const osl::state::SimpleState &state,
	       const osl::stl::vector<osl::Move> &moves,
	       QWidget *parent = 0);
  virtual ~KifuAnalyzer();
private:
  friend class AnalyzeThread;
  bool shouldSearch() const {
    return search;
  }
  void addResult(const osl::Move move,
		 const osl::game_playing::SearchPlayer& player,
		 const osl::game_playing::GameState& state);
  boost::scoped_ptr<AnalyzeThread> thread;
  EvaluationGraph *graph;
  Q3ListView *list;
  QLabel *currentStatus;
  osl::stl::vector<Result> result;
  bool search;
  int pawnValue;
};

#endif // _KIFU_ANALIZER_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
