/*
 * OMAP44xx EMIF registers and bitfields
 *
 * Copyright (C) 2009-2010 Texas Instruments, Inc.
 *
 * Benoit Cousson (b-cousson@ti.com)
 * Santosh Shilimkar (santosh.shilimkar@ti.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __ARCH_ARM_MACH_OMAP2_EMIF_44XX_H
#define __ARCH_ARM_MACH_OMAP2_EMIF_44XX_H


/* Base address */
#define OMAP44XX_EMIF1				0x4c000000
#define OMAP44XX_EMIF2				0x4d000000

/* Registers offset */
#define OMAP44XX_EMIF_MOD_ID_REV		0x0000
#define OMAP44XX_EMIF_STATUS			0x0004
#define OMAP44XX_EMIF_SDRAM_CONFIG		0x0008
#define OMAP44XX_EMIF_SDRAM_CONFIG_2		0x000c
#define OMAP44XX_EMIF_SDRAM_REF_CTRL		0x0010
#define OMAP44XX_EMIF_SDRAM_REF_CTRL_SHDW	0x0014
#define OMAP44XX_EMIF_SDRAM_TIM_1		0x0018
#define OMAP44XX_EMIF_SDRAM_TIM_1_SHDW		0x001c
#define OMAP44XX_EMIF_SDRAM_TIM_2		0x0020
#define OMAP44XX_EMIF_SDRAM_TIM_2_SHDW		0x0024
#define OMAP44XX_EMIF_SDRAM_TIM_3		0x0028
#define OMAP44XX_EMIF_SDRAM_TIM_3_SHDW		0x002c
#define OMAP44XX_EMIF_LPDDR2_NVM_TIM		0x0030
#define OMAP44XX_EMIF_LPDDR2_NVM_TIM_SHDW	0x0034
#define OMAP44XX_EMIF_PWR_MGMT_CTRL		0x0038
#define OMAP44XX_EMIF_PWR_MGMT_CTRL_SHDW	0x003c
#define OMAP44XX_EMIF_LPDDR2_MODE_REG_DATA	0x0040
#define OMAP44XX_EMIF_LPDDR2_MODE_REG_CFG	0x0050
#define OMAP44XX_EMIF_OCP_CONFIG		0x0054
#define OMAP44XX_EMIF_OCP_CFG_VAL_1		0x0058
#define OMAP44XX_EMIF_OCP_CFG_VAL_2		0x005c
#define OMAP44XX_EMIF_IODFT_TLGC		0x0060
#define OMAP44XX_EMIF_IODFT_CTRL_MISR_RSLT	0x0064
#define OMAP44XX_EMIF_IODFT_ADDR_MISR_RSLT	0x0068
#define OMAP44XX_EMIF_IODFT_DATA_MISR_RSLT_1	0x006c
#define OMAP44XX_EMIF_IODFT_DATA_MISR_RSLT_2	0x0070
#define OMAP44XX_EMIF_IODFT_DATA_MISR_RSLT_3	0x0074
#define OMAP44XX_EMIF_PERF_CNT_1		0x0080
#define OMAP44XX_EMIF_PERF_CNT_2		0x0084
#define OMAP44XX_EMIF_PERF_CNT_CFG		0x0088
#define OMAP44XX_EMIF_PERF_CNT_SEL		0x008c
#define OMAP44XX_EMIF_PERF_CNT_TIM		0x0090
#define OMAP44XX_EMIF_READ_IDLE_CTRL		0x0098
#define OMAP44XX_EMIF_READ_IDLE_CTRL_SHDW	0x009c
#define OMAP44XX_EMIF_IRQ_EOI			0x00a0
#define OMAP44XX_EMIF_IRQSTATUS_RAW_SYS		0x00a4
#define OMAP44XX_EMIF_IRQSTATUS_RAW_LL		0x00a8
#define OMAP44XX_EMIF_IRQSTATUS_SYS		0x00ac
#define OMAP44XX_EMIF_IRQSTATUS_LL		0x00b0
#define OMAP44XX_EMIF_IRQENABLE_SET_SYS		0x00b4
#define OMAP44XX_EMIF_IRQENABLE_SET_LL		0x00b8
#define OMAP44XX_EMIF_IRQENABLE_CLR_SYS		0x00bc
#define OMAP44XX_EMIF_IRQENABLE_CLR_LL		0x00c0
#define OMAP44XX_EMIF_ZQ_CONFIG			0x00c8
#define OMAP44XX_EMIF_TEMP_ALERT_CONFIG		0x00cc
#define OMAP44XX_EMIF_OCP_ERR_LOG		0x00d0
#define OMAP44XX_EMIF_DDR_PHY_CTRL_1		0x00e4
#define OMAP44XX_EMIF_DDR_PHY_CTRL_1_SHDW	0x00e8
#define OMAP44XX_EMIF_DDR_PHY_CTRL_2		0x00ec

/* Registers shifts and masks */

/* EMIF_MOD_ID_REV */
#define OMAP44XX_REG_SCHEME_SHIFT			30
#define OMAP44XX_REG_SCHEME_MASK			(0x3 << 30)
#define OMAP44XX_REG_MODULE_ID_SHIFT			16
#define OMAP44XX_REG_MODULE_ID_MASK			(0xfff << 16)
#define OMAP44XX_REG_RTL_VERSION_SHIFT			11
#define OMAP44XX_REG_RTL_VERSION_MASK			(0x1f << 11)
#define OMAP44XX_REG_MAJOR_REVISION_SHIFT		8
#define OMAP44XX_REG_MAJOR_REVISION_MASK		(0x7 << 8)
#define OMAP44XX_REG_MINOR_REVISION_SHIFT		0
#define OMAP44XX_REG_MINOR_REVISION_MASK		(0x3f << 0)

/* STATUS */
#define OMAP44XX_REG_BE_SHIFT				31
#define OMAP44XX_REG_BE_MASK				(1 << 31)
#define OMAP44XX_REG_DUAL_CLK_MODE_SHIFT		30
#define OMAP44XX_REG_DUAL_CLK_MODE_MASK			(1 << 30)
#define OMAP44XX_REG_FAST_INIT_SHIFT			29
#define OMAP44XX_REG_FAST_INIT_MASK			(1 << 29)
#define OMAP44XX_REG_PHY_DLL_READY_SHIFT		2
#define OMAP44XX_REG_PHY_DLL_READY_MASK			(1 << 2)

/* SDRAM_CONFIG */
#define OMAP44XX_REG_SDRAM_TYPE_SHIFT			29
#define OMAP44XX_REG_SDRAM_TYPE_MASK			(0x7 << 29)
#define OMAP44XX_REG_IBANK_POS_SHIFT			27
#define OMAP44XX_REG_IBANK_POS_MASK			(0x3 << 27)
#define OMAP44XX_REG_DDR_TERM_SHIFT			24
#define OMAP44XX_REG_DDR_TERM_MASK			(0x7 << 24)
#define OMAP44XX_REG_DDR2_DDQS_SHIFT			23
#define OMAP44XX_REG_DDR2_DDQS_MASK			(1 << 23)
#define OMAP44XX_REG_DYN_ODT_SHIFT			21
#define OMAP44XX_REG_DYN_ODT_MASK			(0x3 << 21)
#define OMAP44XX_REG_DDR_DISABLE_DLL_SHIFT		20
#define OMAP44XX_REG_DDR_DISABLE_DLL_MASK		(1 << 20)
#define OMAP44XX_REG_SDRAM_DRIVE_SHIFT			18
#define OMAP44XX_REG_SDRAM_DRIVE_MASK			(0x3 << 18)
#define OMAP44XX_REG_CWL_SHIFT				16
#define OMAP44XX_REG_CWL_MASK				(0x3 << 16)
#define OMAP44XX_REG_NARROW_MODE_SHIFT			14
#define OMAP44XX_REG_NARROW_MODE_MASK			(0x3 << 14)
#define OMAP44XX_REG_CL_SHIFT				10
#define OMAP44XX_REG_CL_MASK				(0xf << 10)
#define OMAP44XX_REG_ROWSIZE_SHIFT			7
#define OMAP44XX_REG_ROWSIZE_MASK			(0x7 << 7)
#define OMAP44XX_REG_IBANK_SHIFT			4
#define OMAP44XX_REG_IBANK_MASK				(0x7 << 4)
#define OMAP44XX_REG_EBANK_SHIFT			3
#define OMAP44XX_REG_EBANK_MASK				(1 << 3)
#define OMAP44XX_REG_PAGESIZE_SHIFT			0
#define OMAP44XX_REG_PAGESIZE_MASK			(0x7 << 0)

/* SDRAM_CONFIG_2 */
#define OMAP44XX_REG_CS1NVMEN_SHIFT			30
#define OMAP44XX_REG_CS1NVMEN_MASK			(1 << 30)
#define OMAP44XX_REG_EBANK_POS_SHIFT			27
#define OMAP44XX_REG_EBANK_POS_MASK			(1 << 27)
#define OMAP44XX_REG_RDBNUM_SHIFT			4
#define OMAP44XX_REG_RDBNUM_MASK			(0x3 << 4)
#define OMAP44XX_REG_RDBSIZE_SHIFT			0
#define OMAP44XX_REG_RDBSIZE_MASK			(0x7 << 0)

/* SDRAM_REF_CTRL */
#define OMAP44XX_REG_INITREF_DIS_SHIFT			31
#define OMAP44XX_REG_INITREF_DIS_MASK			(1 << 31)
#define OMAP44XX_REG_SRT_SHIFT				29
#define OMAP44XX_REG_SRT_MASK				(1 << 29)
#define OMAP44XX_REG_ASR_SHIFT				28
#define OMAP44XX_REG_ASR_MASK				(1 << 28)
#define OMAP44XX_REG_PASR_SHIFT				24
#define OMAP44XX_REG_PASR_MASK				(0x7 << 24)
#define OMAP44XX_REG_REFRESH_RATE_SHIFT			0
#define OMAP44XX_REG_REFRESH_RATE_MASK			(0xffff << 0)

/* SDRAM_REF_CTRL_SHDW */
#define OMAP44XX_REG_REFRESH_RATE_SHDW_SHIFT		0
#define OMAP44XX_REG_REFRESH_RATE_SHDW_MASK		(0xffff << 0)

/* SDRAM_TIM_1 */
#define OMAP44XX_REG_T_RP_SHIFT				25
#define OMAP44XX_REG_T_RP_MASK				(0xf << 25)
#define OMAP44XX_REG_T_RCD_SHIFT			21
#define OMAP44XX_REG_T_RCD_MASK				(0xf << 21)
#define OMAP44XX_REG_T_WR_SHIFT				17
#define OMAP44XX_REG_T_WR_MASK				(0xf << 17)
#define OMAP44XX_REG_T_RAS_SHIFT			12
#define OMAP44XX_REG_T_RAS_MASK				(0x1f << 12)
#define OMAP44XX_REG_T_RC_SHIFT				6
#define OMAP44XX_REG_T_RC_MASK				(0x3f << 6)
#define OMAP44XX_REG_T_RRD_SHIFT			3
#define OMAP44XX_REG_T_RRD_MASK				(0x7 << 3)
#define OMAP44XX_REG_T_WTR_SHIFT			0
#define OMAP44XX_REG_T_WTR_MASK				(0x7 << 0)

/* SDRAM_TIM_1_SHDW */
#define OMAP44XX_REG_T_RP_SHDW_SHIFT			25
#define OMAP44XX_REG_T_RP_SHDW_MASK			(0xf << 25)
#define OMAP44XX_REG_T_RCD_SHDW_SHIFT			21
#define OMAP44XX_REG_T_RCD_SHDW_MASK			(0xf << 21)
#define OMAP44XX_REG_T_WR_SHDW_SHIFT			17
#define OMAP44XX_REG_T_WR_SHDW_MASK			(0xf << 17)
#define OMAP44XX_REG_T_RAS_SHDW_SHIFT			12
#define OMAP44XX_REG_T_RAS_SHDW_MASK			(0x1f << 12)
#define OMAP44XX_REG_T_RC_SHDW_SHIFT			6
#define OMAP44XX_REG_T_RC_SHDW_MASK			(0x3f << 6)
#define OMAP44XX_REG_T_RRD_SHDW_SHIFT			3
#define OMAP44XX_REG_T_RRD_SHDW_MASK			(0x7 << 3)
#define OMAP44XX_REG_T_WTR_SHDW_SHIFT			0
#define OMAP44XX_REG_T_WTR_SHDW_MASK			(0x7 << 0)

/* SDRAM_TIM_2 */
#define OMAP44XX_REG_T_XP_SHIFT				28
#define OMAP44XX_REG_T_XP_MASK				(0x7 << 28)
#define OMAP44XX_REG_T_ODT_SHIFT			25
#define OMAP44XX_REG_T_ODT_MASK				(0x7 << 25)
#define OMAP44XX_REG_T_XSNR_SHIFT			16
#define OMAP44XX_REG_T_XSNR_MASK			(0x1ff << 16)
#define OMAP44XX_REG_T_XSRD_SHIFT			6
#define OMAP44XX_REG_T_XSRD_MASK			(0x3ff << 6)
#define OMAP44XX_REG_T_RTP_SHIFT			3
#define OMAP44XX_REG_T_RTP_MASK				(0x7 << 3)
#define OMAP44XX_REG_T_CKE_SHIFT			0
#define OMAP44XX_REG_T_CKE_MASK				(0x7 << 0)

/* SDRAM_TIM_2_SHDW */
#define OMAP44XX_REG_T_XP_SHDW_SHIFT			28
#define OMAP44XX_REG_T_XP_SHDW_MASK			(0x7 << 28)
#define OMAP44XX_REG_T_ODT_SHDW_SHIFT			25
#define OMAP44XX_REG_T_ODT_SHDW_MASK			(0x7 << 25)
#define OMAP44XX_REG_T_XSNR_SHDW_SHIFT			16
#define OMAP44XX_REG_T_XSNR_SHDW_MASK			(0x1ff << 16)
#define OMAP44XX_REG_T_XSRD_SHDW_SHIFT			6
#define OMAP44XX_REG_T_XSRD_SHDW_MASK			(0x3ff << 6)
#define OMAP44XX_REG_T_RTP_SHDW_SHIFT			3
#define OMAP44XX_REG_T_RTP_SHDW_MASK			(0x7 << 3)
#define OMAP44XX_REG_T_CKE_SHDW_SHIFT			0
#define OMAP44XX_REG_T_CKE_SHDW_MASK			(0x7 << 0)

/* SDRAM_TIM_3 */
#define OMAP44XX_REG_T_CKESR_SHIFT			21
#define OMAP44XX_REG_T_CKESR_MASK			(0x7 << 21)
#define OMAP44XX_REG_ZQ_ZQCS_SHIFT			15
#define OMAP44XX_REG_ZQ_ZQCS_MASK			(0x3f << 15)
#define OMAP44XX_REG_T_TDQSCKMAX_SHIFT			13
#define OMAP44XX_REG_T_TDQSCKMAX_MASK			(0x3 << 13)
#define OMAP44XX_REG_T_RFC_SHIFT			4
#define OMAP44XX_REG_T_RFC_MASK				(0x1ff << 4)
#define OMAP44XX_REG_T_RAS_MAX_SHIFT			0
#define OMAP44XX_REG_T_RAS_MAX_MASK			(0xf << 0)

/* SDRAM_TIM_3_SHDW */
#define OMAP44XX_REG_T_CKESR_SHDW_SHIFT			21
#define OMAP44XX_REG_T_CKESR_SHDW_MASK			(0x7 << 21)
#define OMAP44XX_REG_ZQ_ZQCS_SHDW_SHIFT			15
#define OMAP44XX_REG_ZQ_ZQCS_SHDW_MASK			(0x3f << 15)
#define OMAP44XX_REG_T_TDQSCKMAX_SHDW_SHIFT		13
#define OMAP44XX_REG_T_TDQSCKMAX_SHDW_MASK		(0x3 << 13)
#define OMAP44XX_REG_T_RFC_SHDW_SHIFT			4
#define OMAP44XX_REG_T_RFC_SHDW_MASK			(0x1ff << 4)
#define OMAP44XX_REG_T_RAS_MAX_SHDW_SHIFT		0
#define OMAP44XX_REG_T_RAS_MAX_SHDW_MASK		(0xf << 0)

/* LPDDR2_NVM_TIM */
#define OMAP44XX_REG_NVM_T_XP_SHIFT			28
#define OMAP44XX_REG_NVM_T_XP_MASK			(0x7 << 28)
#define OMAP44XX_REG_NVM_T_WTR_SHIFT			24
#define OMAP44XX_REG_NVM_T_WTR_MASK			(0x7 << 24)
#define OMAP44XX_REG_NVM_T_RP_SHIFT			20
#define OMAP44XX_REG_NVM_T_RP_MASK			(0xf << 20)
#define OMAP44XX_REG_NVM_T_WRA_SHIFT			16
#define OMAP44XX_REG_NVM_T_WRA_MASK			(0xf << 16)
#define OMAP44XX_REG_NVM_T_RRD_SHIFT			8
#define OMAP44XX_REG_NVM_T_RRD_MASK			(0xff << 8)
#define OMAP44XX_REG_NVM_T_RCDMIN_SHIFT			0
#define OMAP44XX_REG_NVM_T_RCDMIN_MASK			(0xff << 0)

/* LPDDR2_NVM_TIM_SHDW */
#define OMAP44XX_REG_NVM_T_XP_SHDW_SHIFT		28
#define OMAP44XX_REG_NVM_T_XP_SHDW_MASK			(0x7 << 28)
#define OMAP44XX_REG_NVM_T_WTR_SHDW_SHIFT		24
#define OMAP44XX_REG_NVM_T_WTR_SHDW_MASK		(0x7 << 24)
#define OMAP44XX_REG_NVM_T_RP_SHDW_SHIFT		20
#define OMAP44XX_REG_NVM_T_RP_SHDW_MASK			(0xf << 20)
#define OMAP44XX_REG_NVM_T_WRA_SHDW_SHIFT		16
#define OMAP44XX_REG_NVM_T_WRA_SHDW_MASK		(0xf << 16)
#define OMAP44XX_REG_NVM_T_RRD_SHDW_SHIFT		8
#define OMAP44XX_REG_NVM_T_RRD_SHDW_MASK		(0xff << 8)
#define OMAP44XX_REG_NVM_T_RCDMIN_SHDW_SHIFT		0
#define OMAP44XX_REG_NVM_T_RCDMIN_SHDW_MASK		(0xff << 0)

/* PWR_MGMT_CTRL */
#define OMAP44XX_REG_PD_TIM_SHIFT			12
#define OMAP44XX_REG_PD_TIM_MASK			(0xf << 12)
#define OMAP44XX_REG_DPD_EN_SHIFT			11
#define OMAP44XX_REG_DPD_EN_MASK			(1 << 11)
#define OMAP44XX_REG_LP_MODE_SHIFT			8
#define OMAP44XX_REG_LP_MODE_MASK			(0x7 << 8)
#define OMAP44XX_REG_SR_TIM_SHIFT			4
#define OMAP44XX_REG_SR_TIM_MASK			(0xf << 4)
#define OMAP44XX_REG_CS_TIM_SHIFT			0
#define OMAP44XX_REG_CS_TIM_MASK			(0xf << 0)

/* PWR_MGMT_CTRL_SHDW */
#define OMAP44XX_REG_PD_TIM_SHDW_SHIFT			12
#define OMAP44XX_REG_PD_TIM_SHDW_MASK			(0xf << 12)
#define OMAP44XX_REG_SR_TIM_SHDW_SHIFT			4
#define OMAP44XX_REG_SR_TIM_SHDW_MASK			(0xf << 4)
#define OMAP44XX_REG_CS_TIM_SHDW_SHIFT			0
#define OMAP44XX_REG_CS_TIM_SHDW_MASK			(0xf << 0)

/* LPDDR2_MODE_REG_DATA */
#define OMAP44XX_REG_VALUE_0_SHIFT			0
#define OMAP44XX_REG_VALUE_0_MASK			(0x7f << 0)

/* LPDDR2_MODE_REG_CFG */
#define OMAP44XX_REG_CS_SHIFT				31
#define OMAP44XX_REG_CS_MASK				(1 << 31)
#define OMAP44XX_REG_REFRESH_EN_SHIFT			30
#define OMAP44XX_REG_REFRESH_EN_MASK			(1 << 30)
#define OMAP44XX_REG_ADDRESS_SHIFT			0
#define OMAP44XX_REG_ADDRESS_MASK			(0xff << 0)

/* OCP_CONFIG */
#define OMAP44XX_REG_SYS_THRESH_MAX_SHIFT		24
#define OMAP44XX_REG_SYS_THRESH_MAX_MASK		(0xf << 24)
#define OMAP44XX_REG_LL_THRESH_MAX_SHIFT		16
#define OMAP44XX_REG_LL_THRESH_MAX_MASK			(0xf << 16)
#define OMAP44XX_REG_PR_OLD_COUNT_SHIFT			0
#define OMAP44XX_REG_PR_OLD_COUNT_MASK			(0xff << 0)

/* OCP_CFG_VAL_1 */
#define OMAP44XX_REG_SYS_BUS_WIDTH_SHIFT		30
#define OMAP44XX_REG_SYS_BUS_WIDTH_MASK			(0x3 << 30)
#define OMAP44XX_REG_LL_BUS_WIDTH_SHIFT			28
#define OMAP44XX_REG_LL_BUS_WIDTH_MASK			(0x3 << 28)
#define OMAP44XX_REG_WR_FIFO_DEPTH_SHIFT		8
#define OMAP44XX_REG_WR_FIFO_DEPTH_MASK			(0xff << 8)
#define OMAP44XX_REG_CMD_FIFO_DEPTH_SHIFT		0
#define OMAP44XX_REG_CMD_FIFO_DEPTH_MASK		(0xff << 0)

/* OCP_CFG_VAL_2 */
#define OMAP44XX_REG_RREG_FIFO_DEPTH_SHIFT		16
#define OMAP44XX_REG_RREG_FIFO_DEPTH_MASK		(0xff << 16)
#define OMAP44XX_REG_RSD_FIFO_DEPTH_SHIFT		8
#define OMAP44XX_REG_RSD_FIFO_DEPTH_MASK		(0xff << 8)
#define OMAP44XX_REG_RCMD_FIFO_DEPTH_SHIFT		0
#define OMAP44XX_REG_RCMD_FIFO_DEPTH_MASK		(0xff << 0)

/* IODFT_TLGC */
#define OMAP44XX_REG_TLEC_SHIFT				16
#define OMAP44XX_REG_TLEC_MASK				(0xffff << 16)
#define OMAP44XX_REG_MT_SHIFT				14
#define OMAP44XX_REG_MT_MASK				(1 << 14)
#define OMAP44XX_REG_ACT_CAP_EN_SHIFT			13
#define OMAP44XX_REG_ACT_CAP_EN_MASK			(1 << 13)
#define OMAP44XX_REG_OPG_LD_SHIFT			12
#define OMAP44XX_REG_OPG_LD_MASK			(1 << 12)
#define OMAP44XX_REG_RESET_PHY_SHIFT			10
#define OMAP44XX_REG_RESET_PHY_MASK			(1 << 10)
#define OMAP44XX_REG_MMS_SHIFT				8
#define OMAP44XX_REG_MMS_MASK				(1 << 8)
#define OMAP44XX_REG_MC_SHIFT				4
#define OMAP44XX_REG_MC_MASK				(0x3 << 4)
#define OMAP44XX_REG_PC_SHIFT				1
#define OMAP44XX_REG_PC_MASK				(0x7 << 1)
#define OMAP44XX_REG_TM_SHIFT				0
#define OMAP44XX_REG_TM_MASK				(1 << 0)

/* IODFT_CTRL_MISR_RSLT */
#define OMAP44XX_REG_DQM_TLMR_SHIFT			16
#define OMAP44XX_REG_DQM_TLMR_MASK			(0x3ff << 16)
#define OMAP44XX_REG_CTL_TLMR_SHIFT			0
#define OMAP44XX_REG_CTL_TLMR_MASK			(0x7ff << 0)

/* IODFT_ADDR_MISR_RSLT */
#define OMAP44XX_REG_ADDR_TLMR_SHIFT			0
#define OMAP44XX_REG_ADDR_TLMR_MASK			(0x1fffff << 0)

/* IODFT_DATA_MISR_RSLT_1 */
#define OMAP44XX_REG_DATA_TLMR_31_0_SHIFT		0
#define OMAP44XX_REG_DATA_TLMR_31_0_MASK		(0xffffffff << 0)

/* IODFT_DATA_MISR_RSLT_2 */
#define OMAP44XX_REG_DATA_TLMR_63_32_SHIFT		0
#define OMAP44XX_REG_DATA_TLMR_63_32_MASK		(0xffffffff << 0)

/* IODFT_DATA_MISR_RSLT_3 */
#define OMAP44XX_REG_DATA_TLMR_66_64_SHIFT		0
#define OMAP44XX_REG_DATA_TLMR_66_64_MASK		(0x7 << 0)

/* PERF_CNT_1 */
#define OMAP44XX_REG_COUNTER1_SHIFT			0
#define OMAP44XX_REG_COUNTER1_MASK			(0xffffffff << 0)

/* PERF_CNT_2 */
#define OMAP44XX_REG_COUNTER2_SHIFT			0
#define OMAP44XX_REG_COUNTER2_MASK			(0xffffffff << 0)

/* PERF_CNT_CFG */
#define OMAP44XX_REG_CNTR2_MCONNID_EN_SHIFT		31
#define OMAP44XX_REG_CNTR2_MCONNID_EN_MASK		(1 << 31)
#define OMAP44XX_REG_CNTR2_REGION_EN_SHIFT		30
#define OMAP44XX_REG_CNTR2_REGION_EN_MASK		(1 << 30)
#define OMAP44XX_REG_CNTR2_CFG_SHIFT			16
#define OMAP44XX_REG_CNTR2_CFG_MASK			(0xf << 16)
#define OMAP44XX_REG_CNTR1_MCONNID_EN_SHIFT		15
#define OMAP44XX_REG_CNTR1_MCONNID_EN_MASK		(1 << 15)
#define OMAP44XX_REG_CNTR1_REGION_EN_SHIFT		14
#define OMAP44XX_REG_CNTR1_REGION_EN_MASK		(1 << 14)
#define OMAP44XX_REG_CNTR1_CFG_SHIFT			0
#define OMAP44XX_REG_CNTR1_CFG_MASK			(0xf << 0)

/* PERF_CNT_SEL */
#define OMAP44XX_REG_MCONNID2_SHIFT			24
#define OMAP44XX_REG_MCONNID2_MASK			(0xff << 24)
#define OMAP44XX_REG_REGION_SEL2_SHIFT			16
#define OMAP44XX_REG_REGION_SEL2_MASK			(0x3 << 16)
#define OMAP44XX_REG_MCONNID1_SHIFT			8
#define OMAP44XX_REG_MCONNID1_MASK			(0xff << 8)
#define OMAP44XX_REG_REGION_SEL1_SHIFT			0
#define OMAP44XX_REG_REGION_SEL1_MASK			(0x3 << 0)

/* PERF_CNT_TIM */
#define OMAP44XX_REG_TOTAL_TIME_SHIFT			0
#define OMAP44XX_REG_TOTAL_TIME_MASK			(0xffffffff << 0)

/* READ_IDLE_CTRL */
#define OMAP44XX_REG_READ_IDLE_LEN_SHIFT		16
#define OMAP44XX_REG_READ_IDLE_LEN_MASK			(0xf << 16)
#define OMAP44XX_REG_READ_IDLE_INTERVAL_SHIFT		0
#define OMAP44XX_REG_READ_IDLE_INTERVAL_MASK		(0x1ff << 0)

/* READ_IDLE_CTRL_SHDW */
#define OMAP44XX_REG_READ_IDLE_LEN_SHDW_SHIFT		16
#define OMAP44XX_REG_READ_IDLE_LEN_SHDW_MASK		(0xf << 16)
#define OMAP44XX_REG_READ_IDLE_INTERVAL_SHDW_SHIFT	0
#define OMAP44XX_REG_READ_IDLE_INTERVAL_SHDW_MASK	(0x1ff << 0)

/* IRQ_EOI */
#define OMAP44XX_REG_EOI_SHIFT				0
#define OMAP44XX_REG_EOI_MASK				(1 << 0)

/* IRQSTATUS_RAW_SYS */
#define OMAP44XX_REG_DNV_SYS_SHIFT			2
#define OMAP44XX_REG_DNV_SYS_MASK			(1 << 2)
#define OMAP44XX_REG_TA_SYS_SHIFT			1
#define OMAP44XX_REG_TA_SYS_MASK			(1 << 1)
#define OMAP44XX_REG_ERR_SYS_SHIFT			0
#define OMAP44XX_REG_ERR_SYS_MASK			(1 << 0)

/* IRQSTATUS_RAW_LL */
#define OMAP44XX_REG_DNV_LL_SHIFT			2
#define OMAP44XX_REG_DNV_LL_MASK			(1 << 2)
#define OMAP44XX_REG_TA_LL_SHIFT			1
#define OMAP44XX_REG_TA_LL_MASK				(1 << 1)
#define OMAP44XX_REG_ERR_LL_SHIFT			0
#define OMAP44XX_REG_ERR_LL_MASK			(1 << 0)

/* IRQSTATUS_SYS */

/* IRQSTATUS_LL */

/* IRQENABLE_SET_SYS */
#define OMAP44XX_REG_EN_DNV_SYS_SHIFT			2
#define OMAP44XX_REG_EN_DNV_SYS_MASK			(1 << 2)
#define OMAP44XX_REG_EN_TA_SYS_SHIFT			1
#define OMAP44XX_REG_EN_TA_SYS_MASK			(1 << 1)
#define OMAP44XX_REG_EN_ERR_SYS_SHIFT			0
#define OMAP44XX_REG_EN_ERR_SYS_MASK			(1 << 0)

/* IRQENABLE_SET_LL */
#define OMAP44XX_REG_EN_DNV_LL_SHIFT			2
#define OMAP44XX_REG_EN_DNV_LL_MASK			(1 << 2)
#define OMAP44XX_REG_EN_TA_LL_SHIFT			1
#define OMAP44XX_REG_EN_TA_LL_MASK			(1 << 1)
#define OMAP44XX_REG_EN_ERR_LL_SHIFT			0
#define OMAP44XX_REG_EN_ERR_LL_MASK			(1 << 0)

/* IRQENABLE_CLR_SYS */

/* IRQENABLE_CLR_LL */

/* ZQ_CONFIG */
#define OMAP44XX_REG_ZQ_CS1EN_SHIFT			31
#define OMAP44XX_REG_ZQ_CS1EN_MASK			(1 << 31)
#define OMAP44XX_REG_ZQ_CS0EN_SHIFT			30
#define OMAP44XX_REG_ZQ_CS0EN_MASK			(1 << 30)
#define OMAP44XX_REG_ZQ_DUALCALEN_SHIFT			29
#define OMAP44XX_REG_ZQ_DUALCALEN_MASK			(1 << 29)
#define OMAP44XX_REG_ZQ_SFEXITEN_SHIFT			28
#define OMAP44XX_REG_ZQ_SFEXITEN_MASK			(1 << 28)
#define OMAP44XX_REG_ZQ_ZQINIT_MULT_SHIFT		18
#define OMAP44XX_REG_ZQ_ZQINIT_MULT_MASK		(0x3 << 18)
#define OMAP44XX_REG_ZQ_ZQCL_MULT_SHIFT			16
#define OMAP44XX_REG_ZQ_ZQCL_MULT_MASK			(0x3 << 16)
#define OMAP44XX_REG_ZQ_REFINTERVAL_SHIFT		0
#define OMAP44XX_REG_ZQ_REFINTERVAL_MASK		(0xffff << 0)

/* TEMP_ALERT_CONFIG */
#define OMAP44XX_REG_TA_CS1EN_SHIFT			31
#define OMAP44XX_REG_TA_CS1EN_MASK			(1 << 31)
#define OMAP44XX_REG_TA_CS0EN_SHIFT			30
#define OMAP44XX_REG_TA_CS0EN_MASK			(1 << 30)
#define OMAP44XX_REG_TA_SFEXITEN_SHIFT			28
#define OMAP44XX_REG_TA_SFEXITEN_MASK			(1 << 28)
#define OMAP44XX_REG_TA_DEVWDT_SHIFT			26
#define OMAP44XX_REG_TA_DEVWDT_MASK			(0x3 << 26)
#define OMAP44XX_REG_TA_DEVCNT_SHIFT			24
#define OMAP44XX_REG_TA_DEVCNT_MASK			(0x3 << 24)
#define OMAP44XX_REG_TA_REFINTERVAL_SHIFT		0
#define OMAP44XX_REG_TA_REFINTERVAL_MASK		(0x3fffff << 0)

/* OCP_ERR_LOG */
#define OMAP44XX_REG_MADDRSPACE_SHIFT			14
#define OMAP44XX_REG_MADDRSPACE_MASK			(0x3 << 14)
#define OMAP44XX_REG_MBURSTSEQ_SHIFT			11
#define OMAP44XX_REG_MBURSTSEQ_MASK			(0x7 << 11)
#define OMAP44XX_REG_MCMD_SHIFT				8
#define OMAP44XX_REG_MCMD_MASK				(0x7 << 8)
#define OMAP44XX_REG_MCONNID_SHIFT			0
#define OMAP44XX_REG_MCONNID_MASK			(0xff << 0)

/* DDR_PHY_CTRL_1 */
#define OMAP44XX_REG_DDR_PHY_CTRL_1_SHIFT		4
#define OMAP44XX_REG_DDR_PHY_CTRL_1_MASK		(0xfffffff << 4)
#define OMAP44XX_REG_READ_LATENCY_SHIFT			0
#define OMAP44XX_REG_READ_LATENCY_MASK			(0xf << 0)
#define OMAP44XX_REG_DLL_SLAVE_DLY_CTRL_SHIFT		4
#define OMAP44XX_REG_DLL_SLAVE_DLY_CTRL_MASK		(0xFF << 4)
#define OMAP44XX_EMIF_DDR_PHY_CTRL_1_BASE_VAL_SHIFT	12
#define OMAP44XX_EMIF_DDR_PHY_CTRL_1_BASE_VAL_MASK	(0xFFFFF << 12)

/* DDR_PHY_CTRL_1_SHDW */
#define OMAP44XX_REG_DDR_PHY_CTRL_1_SHDW_SHIFT		4
#define OMAP44XX_REG_DDR_PHY_CTRL_1_SHDW_MASK		(0xfffffff << 4)
#define OMAP44XX_REG_READ_LATENCY_SHDW_SHIFT		0
#define OMAP44XX_REG_READ_LATENCY_SHDW_MASK		(0xf << 0)
#define OMAP44XX_REG_DLL_SLAVE_DLY_CTRL_SHDW_SHIFT	4
#define OMAP44XX_REG_DLL_SLAVE_DLY_CTRL_SHDW_MASK	(0xFF << 4)
#define OMAP44XX_EMIF_DDR_PHY_CTRL_1_BASE_VAL_SHDW_SHIFT 12
#define OMAP44XX_EMIF_DDR_PHY_CTRL_1_BASE_VAL_SHDW_MASK	(0xFFFFF << 12)

/* DDR_PHY_CTRL_2 */
#define OMAP44XX_REG_DDR_PHY_CTRL_2_SHIFT		0
#define OMAP44XX_REG_DDR_PHY_CTRL_2_MASK		(0xffffffff << 0)
#endif
