/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */

#include "include/support.h"
#include "include/command.h"
#include "include/message.h"

class LWCommandConcat: public LWCommand {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	(void) context;
	
	g_return_val_if_fail (argc == 2, NULL);

	LWValue *v = new LWValue (args[0]);
	v->concat (args[1]);
	return v;
}

const gchar *getName ()
{
	return "concat";
}	

gchar *getHint ()
{
	return _("Concatenate");
}

guint getPriority ()
{
	return 12;
}

LWLink getLinkType ()
{
	return LW_LINK_LEFT;
}

gboolean hasReturn()
{
	return TRUE;
}

void checkArgc (guint n)
{
	if (n != 2) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}	

};

LWSymbol *new_LWCommandConcat()
{
	return new LWCommandConcat();
}
