/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */

#include "include/support.h"
#include "include/command.h"
#include "include/message.h"

class LWCommandGo: public LWCommand {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	g_return_val_if_fail (argc == 0 || argc == 1, NULL);

	gint steps = (argc == 1) ? args[0]->toInt() : 1;
	
	if (steps == 0)
		return NULL;
	
	if (ABS(steps) > 1) {
		LWValue *value = new LWValue (steps  + (steps > 0 ? -1 : 1));
		g_queue_push_head (context->stack, (gpointer) value);
		context->resume = TRUE;
	}
	
	if (steps > 0) {
		context->wizard->stepForward();	
	} else
		context->wizard->stepBack();	

	context->wait_time = context->wizard->getPauseTime();
	context->wait_for = (context->wait_time > 0) ? LW_RESUME_TIMEOUT : LW_RESUME_IDLE;
	
	return NULL;
}	

LWValue *resume1 (LWContext *context, guint argc, LWValue *args[])
{
	g_return_val_if_fail (argc == 0 || argc == 1, NULL);

	(void) args;

	LWValue *value = (LWValue *) g_queue_pop_head (context->stack);
	gint steps = value->toInt();
    delete value;
	
	if (ABS(steps) > 1) {
	    value = new LWValue (steps + (steps > 0 ? -1 : 1));	
		g_queue_push_head (context->stack, (gpointer) value);
		context->resume = TRUE;
	}
	
	if (steps > 0) {
		context->wizard->stepForward();	
	} else
		context->wizard->stepBack();	
	
	context->wait_time = context->wizard->getPauseTime();
	context->wait_for = (context->wait_time > 0) ? LW_RESUME_TIMEOUT : LW_RESUME_IDLE;

	return NULL;
}	

const gchar *getName (void) 
{
	return "go";
}	

gchar *getHint ()
{
	return _("Go one or more steps");
}

void checkArgument (guint n, LWValue *value)
{
	(void) n;
	
	if (FALSE == value->isVariable() && FALSE == value->checkRange())
			throw new LWMessage (LW_ERROR_NumberOutOfRange);
}

void checkArgc (guint n)
{
	if (n > 1) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}

};

LWSymbol *new_LWCommandGo()
{
	return new LWCommandGo();
}
