/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__BANNERCOMPONENT_HPP)
#include <BannerComponent.hpp>
#endif

using namespace corelinux;

//
// Default constructor not allowed
//

BannerComponent::BannerComponent( void )
   throw(Exception)
{
   throw Exception("Requires a Banner!",LOCATION);
}

//
// Constructor with a Banner
//

BannerComponent::BannerComponent( const string &aBanner )
   :
   theBanner( aBanner )
{
   ;  // do nothing
}

//
// Copy constructor
//

BannerComponent::BannerComponent( BannerComponentCref aRef )
   :
   theBanner( aRef.getBanner() )
{
   ;  // do nothing
}

//
// Destructor
//

BannerComponent::~BannerComponent( void )
{
   ;  // do nothing
}

//
// Assignment operator
//

BannerComponentRef   BannerComponent::operator=( BannerComponentCref aBanner )
{
   if( *this == aBanner )
   {
      ;  // do nothing
   }
   else
   {
      this->setBanner( aBanner.getBanner() );
   }
   return (*this);
}

//
// Equality operator
//

bool  BannerComponent::operator==( BannerComponentCref aBanner ) const
{
   return (this == &aBanner &&
           ( this->getBanner() == aBanner.getBanner() ) );
}

//
// Retrieve theBanner
//

string   BannerComponent::getBanner( void ) const
{
   return theBanner;
}

//
// Draw the banner
//

void     BannerComponent::drawBanner( ostream &aStream, bool doEndl ) const
{
   aStream << this->getBanner();

   if( doEndl == true )
   {
      aStream << endl;
   }
   else
   {
      ;  // do nothing
   }
}

//
// Set a new banner
//

void  BannerComponent::setBanner( const string &aBanner )
{
   theBanner = aBanner;
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/01/22 19:28:31 $
   $Locker:  $
*/

