MARTINI bilayer formation
===============================
This example of the formation of a coarse-grained DPPC lipid-bilayer uses the Martini force-field v2.0 (2013-10).  In this example, the initial coordinates are generated by PACKMOL.  If you prefer, there is also an example of a Martini DPPC bilayer which has been preassembled using moltemplate commands [here](../DPPC_bilayer_preformed/README.md).  (That example does not require PACKMOL.)

### Images
<img src="images/DPPC_martini_LR.jpg" height=110> <img src="images/plus.svg" height=80> <img src="images/water_martini_LR.jpg" width=70> <img src="images/rightarrow.svg" height=80> <img src="images/t=0_after_minimization_LR.jpg" width=170> <img src="images/rightarrow.svg" height=80> <img src="images/t=6ns_300K_NPT_LR.jpg" width=170> <img src="images/rightarrow.svg" height=80> <img src="images/t=13ns_450K_NVT_LR.jpg" width=170> <img src="images/rightarrow.svg" height=80> <img src="images/t=26ns_300K_NPT_LR.jpg" width=170>

#### Video

https://www.youtube.com/watch?v=vi5mYiWJRzc

### Details

The simulation size and number of lipids and water molecules is specified in the [mix_lipids+water.inp](./packmol_files/mix_lipids+water.inp) and [system.lt](./moltemplate_files/system.lt) files.  (The numbers in these files must agree.)  The simulation contitions can be controlled by editing the [run.in.anneal](run.in.anneal) and [run.in.nvt](run.in.nvt) files.


### Instructions

More detailed instructions on how to build LAMMPS input files and run a short simulation are provided in other README files.

1) To build the files which LAMMPS needs, follow the instructions in:
[README_setup.sh](README_setup.sh)

2) To run LAMMPS with these files, follow these instructions:
[README_run.sh](README_run.sh)


### WARNING: A flat membrane may fail to form

There is at least a 77% chance it will get "stuck" in a conformation from which it cannot easily escape.  Whenever simulating the process of self-assembly or nucleation and growth, it is common for the assembly process to begin in two or more different places simultaneously.  When this happens, the two or more partially assembled membranes may fail to fuse into a single flat membrane.

If the membrane fails to form for any reason, change the random seed and restart the simulation.  (See below for instructions.)

The membrane can fail to form for other reasons as well.  For the the simulation to succeed in forming a flat planar membrane, the membrane membrane must form parallel to either the XY plane, YZ plane, or XY plane.  (Recall that we are using periodic boundary conditions.)  If it the lipids begin to form a membrane along any of the other "diagonal" crystallographic directions, such as the (110 direction ↔ x+y=constant direction), then they will never be able to form a closed flat surface.  This is because there are not enough lipids in the box to stretch accross the simulation box along the 110 direction.  Since there are 10 such planar directions with similarly surface area, there is only a 3/(10+3)=23% chance that the membrane will end up avoiding those and end up pointing in one of the the 3 "correct" directions (parallel to the the XY, YZ, or XZ planes).


### How to restart the simulation

If the membrane forms incorrectly, you will have to restart the simulation using a different random seed.  To change the outcome of the simulation change the "seed" variable set at the beginning of the "mix_lipids+water.inp" file (in the "packmol_files" directory).  Then run PACKMOL and moltemplate.sh again to rebuild the LAMMPS input files (with new starting geometry), by following the instructions in the README_setup.sh file.  Then run the simulation again.

### Simulation details

To get the membrane to form in a reasonable amount of time, this example uses simulated annealing.  (The simulation begins at a high temperature, followed by gradual cooling).  See the "run.in.anneal" file for details.
