# pascalcase [![Donate](https://img.shields.io/badge/Donate-PayPal-green.svg)](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=W8YFZ425KND68) [![NPM version](https://img.shields.io/npm/v/pascalcase.svg?style=flat)](https://www.npmjs.com/package/pascalcase) [![NPM monthly downloads](https://img.shields.io/npm/dm/pascalcase.svg?style=flat)](https://npmjs.org/package/pascalcase) [![NPM total downloads](https://img.shields.io/npm/dt/pascalcase.svg?style=flat)](https://npmjs.org/package/pascalcase) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/pascalcase.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/pascalcase)

> Convert a string to pascal-case.

Please consider following this project's author, [Jon Schlinkert](https://github.com/jonschlinkert), and consider starring the project to show your :heart: and support.

## Install

Install with [npm](https://www.npmjs.com/) (requires [Node.js](https://nodejs.org/en/) >=8):

```sh
$ npm install --save pascalcase
```

## Usage

```js
const pascalcase = require('pascalcase');

console.log(pascalcase('a')); //=> 'A'
console.log(pascalcase('foo bar baz')); //=> 'FooBarBaz'
console.log(pascalcase('  foo bar baz  ')); //=> 'FooBarBaz'
console.log(pascalcase('foo_bar-baz')); //=> 'FooBarBaz'
console.log(pascalcase('foo.bar.baz')); //=> 'FooBarBaz'
console.log(pascalcase('foo/bar/baz')); //=> 'FooBarBaz'
console.log(pascalcase('foo[bar)baz')); //=> 'FooBarBaz'
console.log(pascalcase('#foo+bar*baz')); //=> 'FooBarBaz'
console.log(pascalcase('$foo~bar`baz')); //=> 'FooBarBaz'
console.log(pascalcase('_foo_bar-baz-')); //=> 'FooBarBaz'
console.log(pascalcase('foo 2 bar 5 baz')); //=> 'Foo2Bar5Baz'
console.log(pascalcase('foo2bar5baz')); //=> 'Foo2bar5baz'
```

## About

<details>
<summary><strong>Contributing</strong></summary>

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

</details>

<details>
<summary><strong>Running Tests</strong></summary>

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

</details>

<details>
<summary><strong>Building docs</strong></summary>

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

</details>

### Related projects

You might also be interested in these projects:

* [ansi-colors](https://www.npmjs.com/package/ansi-colors): Easily add ANSI colors to your text and symbols in the terminal. A faster drop-in… [more](https://github.com/doowb/ansi-colors) | [homepage](https://github.com/doowb/ansi-colors "Easily add ANSI colors to your text and symbols in the terminal. A faster drop-in replacement for chalk, kleur and turbocolor (without the dependencies and rendering bugs).")
* [justified](https://www.npmjs.com/package/justified): Wraps words to a specified length and justifies the text in each line. | [homepage](https://github.com/jonschlinkert/justified "Wraps words to a specified length and justifies the text in each line.")
* [randomatic](https://www.npmjs.com/package/randomatic): Generate randomized strings of a specified length using simple character sequences. The original generate-password. | [homepage](https://github.com/jonschlinkert/randomatic "Generate randomized strings of a specified length using simple character sequences. The original generate-password.")
* [word-wrap](https://www.npmjs.com/package/word-wrap): Wrap words to a specified length. | [homepage](https://github.com/jonschlinkert/word-wrap "Wrap words to a specified length.")

### Author

**Jon Schlinkert**

* [GitHub Profile](https://github.com/jonschlinkert)
* [Twitter Profile](https://twitter.com/jonschlinkert)
* [LinkedIn Profile](https://linkedin.com/in/jonschlinkert)

### License

Copyright © 2019, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.8.0, on August 08, 2019._