% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genmodel.R
\name{genmodel}
\alias{genmodel}
\title{Generate a configuration matrix}
\usage{
genmodel(varlvls, facets, dir = tempdir(), quiet = TRUE,
  shell = FALSE, ...)
}
\arguments{
\item{varlvls}{a vector containing the number of levels of each variable}

\item{facets}{the facets generating the hierarchical model, a list of vectors
of variable indices}

\item{dir}{Directory to place the files in, without an ending /}

\item{quiet}{If FALSE, messages the 4ti2 output}

\item{shell}{Messages the shell code used to do the computation}

\item{...}{Additional arguments to pass to the function}
}
\value{
The configuration matrix of the model provided
}
\description{
genmodel runs 4ti2's genmodel program to compute the configuration matrix A
corresponding to graphical statistical models given by a simplicial complex
and levels on the nodes.
}
\examples{

if (has_4ti2()) {

varlvls <- rep(2, 2)
facets <- list(1, 2)
genmodel(varlvls, facets)
genmodel(varlvls, facets, quiet = FALSE)

varlvls <- rep(3, 3)
facets <- list(1:2, 2:3, c(3,1))
genmodel(varlvls, facets)

# compare this to algstat's hmat function

}

}
