% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visUpdateEdges.R
\name{visUpdateEdges}
\alias{visUpdateEdges}
\title{Function to update the information of edges, with shiny only.}
\usage{
visUpdateEdges(graph, edges, legend = FALSE)
}
\arguments{
\item{graph}{: a \code{ \link[visNetwork]{visNetworkProxy}}  object}

\item{edges}{: data.frame with the information of edges. See  \link[visNetwork]{visEdges}
\itemize{
 \item "id" edge id, for update
 \item "from" node id, begin of the edge
 \item "to" node id, end of the edge
 \item "label" label
 \item "value" size
 \item "title" tooltip
 \item ...
}}

\item{legend}{: Boolean. Update edges on legend ? Default to FALSE}
}
\description{
Function to update the information of edges, with shiny only. You can also use this function passing new edges.
The link is based on id.
}
\examples{
\dontrun{

# have a look to : 
shiny::runApp(system.file("shiny", package = "visNetwork"))

}

}
\references{
See online documentation \url{https://datastorm-open.github.io/visNetwork/}
}
\seealso{
\link[visNetwork]{visNodes} for nodes options,  \link[visNetwork]{visEdges} for edges options,  \link[visNetwork]{visGroups} for groups options, 
\link[visNetwork]{visLegend} for adding legend,  \link[visNetwork]{visOptions} for custom option,  \link[visNetwork]{visLayout} &  \link[visNetwork]{visHierarchicalLayout} for layout, 
\link[visNetwork]{visPhysics} for control physics,  \link[visNetwork]{visInteraction} for interaction,  \link[visNetwork]{visNetworkProxy} &  \link[visNetwork]{visFocus} &  \link[visNetwork]{visFit} for animation within shiny,
\link[visNetwork]{visDocumentation},  \link[visNetwork]{visEvents},  \link[visNetwork]{visConfigure} ...
}
