/*  This file is part of SAIL (https://github.com/HappySeaFox/sail)

    Copyright (c) 2020 Dmitry Baryshev

    The MIT License

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE.
*/

#pragma once

#include <stdint.h>

#include <sail-common/export.h>
#include <sail-common/status.h>

struct sail_hash_map;
struct sail_io;

/* File header. */
struct SailIcoHeader
{
    uint16_t reserved;
    uint16_t type; /* 1 = ICO, 2 = CUR. */
    uint16_t images_count;
};

struct SailIcoDirEntry
{
    uint8_t width;
    uint8_t height;
    uint8_t color_count; /* 0 when full color. */
    uint8_t reserved;
    uint16_t planes;    /* CUR: x hotspot. */
    uint16_t bit_count; /* CUR: y hotspot. */
    uint32_t image_size;
    uint32_t image_offset;
};

enum SailIcoImageType
{
    SAIL_ICO_IMAGE_BMP,
    SAIL_ICO_IMAGE_PNG,
};

SAIL_HIDDEN sail_status_t ico_private_read_header(struct sail_io* io, struct SailIcoHeader* header);

SAIL_HIDDEN sail_status_t ico_private_read_dir_entry(struct sail_io* io, struct SailIcoDirEntry* dir_entry);

SAIL_HIDDEN sail_status_t ico_private_probe_image_type(struct sail_io* io, enum SailIcoImageType* ico_image_type);

SAIL_HIDDEN sail_status_t ico_private_store_cur_hotspot(const struct SailIcoDirEntry* ico_dir_entry,
                                                        struct sail_hash_map* special_properties);

SAIL_HIDDEN sail_status_t ico_private_write_header(struct sail_io* io, const struct SailIcoHeader* header);

SAIL_HIDDEN sail_status_t ico_private_write_dir_entry(struct sail_io* io, const struct SailIcoDirEntry* dir_entry);

SAIL_HIDDEN sail_status_t ico_private_fetch_cur_hotspot(const struct sail_hash_map* special_properties,
                                                        uint16_t* hotspot_x,
                                                        uint16_t* hotspot_y);
