#!/bin/sh
set -e

VERSION=$2
TAR=../snappy-java_$VERSION.orig.tar.xz
DIR=snappy-java-$VERSION

tar -xf $3
rm $3

XZ_OPT=--best tar -cJvf $TAR \
    --exclude 'src/main/resources/org/xerial/snappy/native/*' \
    --exclude 'lib/*' \
    --exclude '*.bytecode' \
    --exclude '*.jar' \
    --exclude '*.class' \
    --exclude '.settings' \
    --exclude '.classpath' \
    --exclude '.project' \
    --exclude '.hg*' \
    --exclude '.travis.yml' \
    $DIR

rm -Rf $DIR
