/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef THEMEBUTTON_H
#define THEMEBUTTON_H

#include <QObject>
#include <QWidget>
#include <QPushButton>

#include "themeiconlabel.h"

class ThemeButton : public QPushButton
{
    Q_OBJECT
public:
    ThemeButton(const QString &name, QWidget *parent = nullptr);
    ThemeButton(const QString &name, const QPixmap &pixmap, QWidget *parent = nullptr);
    ThemeButton(QString name, QStringList iStringList, QWidget *parent = nullptr);
    ThemeButton(QString name, QList<QPixmap> iconList, QWidget *parent = nullptr);

    void initUi();
    void setConnect();
    void setRadius(int radius);
    void setRect(QSize size);
    void setPixmap(const QPixmap &pixmap);
    void setBtnClicked(bool status);
    QString getStyle(int border, int radius);

protected:
    void paintEvent(QPaintEvent *event);

private:
    QString themename;
    QString themeicon;
    ThemeIconLabel * mIconLabel;
    QLabel *mNameLabel;
    int mRadius = 8;
    int mWidth = 146;
    int mHeigh = 126;
    QString clickedBtnStyle;
    QString enterBtnStyle;
    QString leaveBtnStyle;

Q_SIGNALS:
    void btnCheckedSignals(bool status);
};

#endif // THEMEBUTTON_H
